/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.TransactionUtil;
import com.sun.messaging.jms.management.server.TransactionNotification;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class TransactionManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getTransactionInfoByIDSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] txnNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private long numTransactionsCommitted = 0L;
    private long numTransactionsRollback = 0L;

    public Integer getNumTransactions() {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        Vector transactions = tl.getTransactions(-1);
        return new Integer(transactions.size());
    }

    public Long getNumTransactionsCommitted() {
        return new Long(this.numTransactionsCommitted);
    }

    public Long getNumTransactionsRollback() {
        return new Long(this.numTransactionsRollback);
    }

    public void resetMetrics() {
        this.numTransactionsCommitted = 0L;
        this.numTransactionsRollback = 0L;
    }

    public String[] getTransactionIDs() throws MBeanException {
        return TransactionUtil.getTransactionIDs();
    }

    public CompositeData[] getTransactionInfo() throws MBeanException {
        CompositeData[] cds = null;
        try {
            cds = TransactionUtil.getTransactionInfo();
        }
        catch (Exception e) {
            this.handleOperationException("getTransactionInfo", e);
        }
        return cds;
    }

    public CompositeData getTransactionInfoByID(String transactionID) throws MBeanException {
        CompositeData cd = null;
        try {
            cd = TransactionUtil.getTransactionInfo(transactionID);
        }
        catch (Exception e) {
            this.handleOperationException("getTransactionInfoByID", e);
        }
        return cd;
    }

    @Override
    public String getMBeanName() {
        return "TransactionManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1163");
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyTransactionCommit(long id) {
        TransactionNotification n = new TransactionNotification("mq.transaction.commit", this, this.sequenceNumber++);
        n.setTransactionID(Long.toString(id));
        this.sendNotification(n);
        ++this.numTransactionsCommitted;
    }

    public void notifyTransactionPrepare(long id) {
        TransactionNotification n = new TransactionNotification("mq.transaction.prepare", this, this.sequenceNumber++);
        n.setTransactionID(Long.toString(id));
        this.sendNotification(n);
    }

    public void notifyTransactionRollback(long id) {
        TransactionNotification n = new TransactionNotification("mq.transaction.rollback", this, this.sequenceNumber++);
        n.setTransactionID(Long.toString(id));
        this.sendNotification(n);
        ++this.numTransactionsRollback;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[3];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumTransactions", Integer.class.getName(), mbr.getString("MB1154"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumTransactionsCommitted", Long.class.getName(), mbr.getString("MB1155"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumTransactionsRollback", Long.class.getName(), mbr.getString("MB1156"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("transactionID", String.class.getName(), mbr.getString("MB1162"));
        getTransactionInfoByIDSignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getTransactionIDs", mbr.getString("MB1158"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getTransactionInfo", mbr.getString("MB1159"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getTransactionInfoByID", mbr.getString("MB1160"), getTransactionInfoByIDSignature, CompositeData.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        txnNotificationTypes = new String[]{"mq.transaction.commit", "mq.transaction.prepare", "mq.transaction.rollback"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(txnNotificationTypes, TransactionNotification.class.getName(), mbr.getString("MB1164"));
        notifs = mBeanNotificationInfoArray;
    }
}

