/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.FileTransferCallback;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLink;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterServiceListener;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.FileTransferRunnable;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.WarningTask;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterFirstInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileEndInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileListInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileStartInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClusterImpl
implements Cluster,
ClusterListener {
    static boolean DEBUG = false;
    ClusterCallback cb = null;
    private boolean supportClusters = false;
    private int connLimit = 0;
    private Properties matchProps = null;
    protected boolean useGPackets = false;
    private BrokerAddressImpl self;
    private Map connectList;
    private HashMap brokerList;
    private boolean readyForBroadcast = false;
    private int flowControlState = 6;
    private String transport = null;
    private InetAddress listenHost = null;
    private int listenPort = 0;
    private ClusterServiceListener listener = null;
    private PingTimerTask pingTimer = null;
    private static final long DEFAULT_PING_INTERVAL = 60L;
    private long pingInterval = Globals.getConfig().getLongProperty("imq.cluster.ping.interval", 60L) * 1000L;
    private int tcpInbufsz = Globals.getConfig().getIntProperty("imq.cluster.tcp.inbufsz", 2048);
    private int sslInbufsz = Globals.getConfig().getIntProperty("imq.cluster.ssl.inbufsz", Globals.getConfig().getIntProperty("imq.cluster.tls.inbufsz", 2048));
    private int tcpOutbufsz = Globals.getConfig().getIntProperty("imq.cluster.tcp.outbufsz", 2048);
    private int sslOutbufsz = Globals.getConfig().getIntProperty("imq.cluster.ssl.outbufsz", Globals.getConfig().getIntProperty("imq.cluster.tls.outbufsz", 2048));
    private boolean tcpNodelay = Globals.getConfig().getBooleanProperty("imq.cluster.tcp.nodelay", true);
    private boolean sslNodelay = Globals.getConfig().getBooleanProperty("imq.cluster.ssl.nodelay", Globals.getConfig().getBooleanProperty("imq.cluster.tls.nodelay", true));
    private Object configServerLock = new Object();
    private BrokerAddressImpl configServer = null;
    private boolean configServerResolved = false;
    public static final String SERVICE_NAME = "cluster";
    public static final String SERVICE_TYPE = "CLUSTER";
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private TimerTask warningTask = null;
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 30;
    private static final String SHUTDOWN_TIMEOUT_PROP = "imq.cluster.shutdownTimeout";
    private ClusterManager clsmgr = null;
    protected Map<BrokerAddress, String> pendingFileTransfers = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, ExecutorService> fileTransferExecutors = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean fileTransferShutdownIn = false;
    private boolean fileTransferShutdownOut = false;
    private final int FILE_TRANSFER_SOTIMEOUT_IN = 15000;
    private final int FILE_TRANSFER_SOTIMEOUT_OUT = 300000;
    protected static final int FILE_TRANSFER_CHUNK_SIZE = 8192;

    public ClusterImpl(int connLimit) throws BrokerException {
        this.clsmgr = Globals.getClusterManager();
        this.transport = this.clsmgr.getTransport();
        assert (this.transport != null);
        if (this.transport.equalsIgnoreCase("tls")) {
            this.transport = "ssl";
        }
        boolean nocluster = !Globals.getHAEnabled() && this.clsmgr.getConfigBrokerCount() == 0;
        this.listenPort = this.clsmgr.getClusterPort();
        String listenh = this.clsmgr.getClusterHost();
        try {
            this.listenHost = BrokerMQAddress.resolveBindAddress(listenh, true);
        }
        catch (LoopbackAddressException e) {
            int level = nocluster ? 16 : 32;
            logger.log(level, "B3153", "imq.cluster.hostname");
            if (nocluster) {
                throw e;
            }
            Broker.getBroker().exit(1, br.getKString("B3153", "imq.cluster.hostname"), BrokerEvent.Type.FATAL_ERROR);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                logger.log(32, br.getKString("B3235", "imq.cluster.hostname", e.getMessage()));
            } else {
                logger.logStack(32, br.getKString("B3235", "imq.cluster.hostname", e.getMessage()), e);
            }
            Broker.getBroker().exit(1, br.getString("B3235", "imq.cluster.hostname", e.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            BrokerException be = new BrokerException(e.getMessage());
            be.initCause(e);
            throw be;
        }
        try {
            BrokerMQAddress.checkLoopbackAddress(Globals.getPortMapper().getBindAddress(), Globals.getPortMapper().getHostname());
        }
        catch (LoopbackAddressException e) {
            int level = nocluster ? 16 : 32;
            logger.log(level, "B3236", (Object)"imq.portmapper.hostname", e.getMessage());
            if (nocluster) {
                throw e;
            }
            Broker.getBroker().exit(1, br.getString("B3236", "imq.portmapper.hostname", e.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                logger.log(32, "B3236", (Object)"imq.portmapper.hostname", e.getMessage());
            } else {
                logger.logStack(32, "B3236", "imq.portmapper.hostname", e.getMessage(), e);
            }
            Broker.getBroker().exit(1, br.getString("B3236", "imq.portmapper.hostname", e.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            BrokerException be = new BrokerException(e.getMessage());
            be.initCause(e);
            throw be;
        }
        try {
            this.self = new BrokerAddressImpl();
        }
        catch (LoopbackAddressException e) {
            int level = nocluster ? 16 : 32;
            logger.log(level, br.getKString("B3168", e.getMessage()));
            if (nocluster) {
                throw e;
            }
            Broker.getBroker().exit(1, br.getString("B3168", e.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                logger.log(32, br.getKString("B3168", e.getMessage()));
            } else {
                logger.logStack(32, br.getKString("B3168", e.getMessage()), e);
            }
            Broker.getBroker().exit(1, br.getString("B3168", e.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            BrokerException be = new BrokerException(e.getMessage());
            be.initCause(e);
            throw be;
        }
        LicenseBase lb = Globals.getCurrentLicense(null);
        this.supportClusters = lb.getBooleanProperty("imq.enable_cluster", false);
        this.connLimit = connLimit;
        this.readyForBroadcast = false;
        ClusteredBroker masterb = this.clsmgr.getMasterBroker();
        this.initConfigServer(masterb);
        this.initBrokerList();
    }

    private void initConfigServer(ClusteredBroker masterb) throws BrokerException {
        if (masterb == null) {
            this.configServer = null;
            this.configServerResolved = true;
            return;
        }
        if (!this.supportClusters) {
            String emsg = br.getKString("B3123", Globals.getBrokerResources().getString("B0038"));
            logger.log(32, emsg);
            Broker.getBroker().exit(1, emsg, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(emsg);
        }
        if (Globals.getHAEnabled()) {
            String emsg = br.getKString("B3196");
            logger.log(32, emsg);
            Broker.getBroker().exit(1, emsg, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(emsg);
        }
        this.checkStoredLastConfigServer();
        try {
            this.configServer = new BrokerAddressImpl((BrokerMQAddress)masterb.getBrokerURL(), null, Globals.getHAEnabled(), masterb.getBrokerName());
        }
        catch (Exception e) {
            this.configServer = null;
            this.configServerResolved = false;
            throw new BrokerException(e.getMessage(), e);
        }
        BrokerMQAddress key = this.configServer.getMQAddress();
        if (key.equals(this.self.getMQAddress())) {
            this.configServer = this.self;
            this.configServerResolved = true;
            return;
        }
        this.configServerResolved = false;
    }

    private void checkStoredLastConfigServer() throws BrokerException {
        Store s = Globals.getStore();
        boolean bad = false;
        boolean potentiallyBad = false;
        LoadException le = s.getLoadPropertyException();
        LoadException savele = null;
        while (le != null) {
            Object o = le.getKey();
            if (o == null || !(o instanceof String)) {
                potentiallyBad = true;
                savele = le;
                le = le.getNextException();
                continue;
            }
            if (((String)o).equals("MessageBus.lastConfigServer")) {
                logger.log(32, "B3161", le);
                bad = true;
                break;
            }
            if (((String)o).equals("MessageBus.lastRefreshTime")) {
                logger.log(16, "B2100", le);
                try {
                    s.updateProperty("MessageBus.lastRefreshTime", new Long(-1L), false);
                }
                catch (BrokerException e) {
                    logger.log(32, "B3162", e);
                    bad = true;
                    break;
                }
            }
            le = le.getNextException();
        }
        if (potentiallyBad && !bad) {
            try {
                if (s.getProperty("MessageBus.lastConfigServer") == null) {
                    logger.log(32, "B3161", savele);
                    bad = true;
                }
            }
            catch (BrokerException e) {
                logger.log(32, e.getMessage(), e);
                logger.log(32, "B3161", savele);
                bad = true;
            }
        }
        if (bad) {
            logger.log(32, "B3161");
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3161"), BrokerEvent.Type.FATAL_ERROR);
        }
    }

    private void initBrokerList() throws BrokerException {
        String emsg;
        this.connectList = Collections.synchronizedMap(new HashMap());
        BrokerMQAddress selfKey = this.self.getMQAddress();
        if (DEBUG) {
            logger.log(8, "ClusterImpl:initBrokerList. selfKey =" + selfKey);
        }
        ClusteredBroker cb = null;
        BrokerAddressImpl b = null;
        BrokerLink link = null;
        Iterator itr = this.clsmgr.getConfigBrokers();
        int i = 0;
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            try {
                b = new BrokerAddressImpl((BrokerMQAddress)cb.getBrokerURL(), null, Globals.getHAEnabled(), cb.getBrokerName());
            }
            catch (Exception e) {
                throw new BrokerException(e.getMessage(), e);
            }
            BrokerMQAddress key = b.getMQAddress();
            if (key.equals(selfKey)) continue;
            link = new BrokerLink(this.self, b, this);
            link.setAutoConnect(true);
            this.connectList.put(key, link);
            ++i;
            if (!DEBUG) continue;
            logger.log(8, "ClusterImpl: Added to connectList: key=" + key + ", link=" + link + " (" + i + ")");
        }
        if (this.connectList.size() > 0 && !this.supportClusters) {
            emsg = br.getKString("B3123", Globals.getBrokerResources().getString("B0038"));
            logger.log(32, emsg);
            Broker.getBroker().exit(1, emsg, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(emsg);
        }
        if (this.connectList.size() > this.connLimit) {
            emsg = br.getKString("B3091", Integer.toString(this.connLimit + 1));
            logger.log(32, emsg);
            Broker.getBroker().exit(1, emsg, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(emsg);
        }
        this.brokerList = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerLink searchBrokerList(BrokerMQAddress key) {
        if (this.brokerList == null) {
            return null;
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            for (BrokerAddressImpl b : this.brokerList.keySet()) {
                if (!key.equals(b.getMQAddress())) continue;
                return (BrokerLink)this.brokerList.get(b);
            }
            return null;
        }
    }

    protected String getTransport() {
        return this.transport;
    }

    protected boolean getTCPNodelay() {
        return this.tcpNodelay;
    }

    protected boolean getSSLNodelay() {
        return this.sslNodelay;
    }

    protected int getTCPInputBufferSize() {
        return this.tcpInbufsz;
    }

    protected int getTCPOutputBufferSize() {
        return this.tcpOutbufsz;
    }

    protected int getSSLInputBufferSize() {
        return this.sslInbufsz;
    }

    protected int getSSLOutputBufferSize() {
        return this.sslOutbufsz;
    }

    private void setListenHost(String host) throws Exception {
        if (DEBUG) {
            logger.log(4, "ClusterImpl: Changing the listening hostname to {0}", host);
        }
        if (!this.supportClusters) {
            return;
        }
        InetAddress saveListenHost = this.listenHost;
        try {
            this.listenHost = BrokerMQAddress.resolveBindAddress(host, true);
            ClusterServiceListener newListener = new ClusterServiceListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = newListener;
        }
        catch (Exception e) {
            this.listenHost = saveListenHost;
            throw e;
        }
    }

    protected InetAddress getListenHost() {
        return this.listenHost;
    }

    private void setListenPort(int port) throws IOException {
        Object[] args = new String[]{SERVICE_NAME, String.valueOf(port), String.valueOf(1), String.valueOf(1)};
        logger.log(8, "B1090", args);
        if (!this.supportClusters) {
            return;
        }
        int saveListenPort = this.listenPort;
        try {
            this.listenPort = port;
            ClusterServiceListener newListener = new ClusterServiceListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = newListener;
        }
        catch (IOException e) {
            this.listenPort = saveListenPort;
            throw e;
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }

    protected boolean isConfigServerResolved() {
        return this.configServerResolved;
    }

    protected boolean waitForConfigSync() {
        if (this.cb == null) {
            return true;
        }
        return ((Protocol)this.cb).waitForConfigSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConfigServer(BrokerAddressImpl b) {
        Object object = this.configServerLock;
        synchronized (object) {
            if (this.configServerResolved) {
                return true;
            }
            if (this.configServer == null) {
                return false;
            }
            BrokerMQAddress key = b.getMQAddress();
            if (key.equals(this.configServer.getMQAddress())) {
                this.configServer = b;
                this.configServerResolved = true;
                if (this.warningTask != null) {
                    this.warningTask.cancel();
                    this.warningTask = null;
                }
            }
            return this.configServerResolved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addBroker(BrokerAddressImpl b, BrokerLink link) {
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Activating link = {0}", link);
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink rlink = (BrokerLink)this.brokerList.get(b);
            if (rlink != null) {
                BrokerAddressImpl remoteb = rlink.getRemote();
                if (!remoteb.getMQAddress().equals(b.getMQAddress())) {
                    Object[] args = new String[]{b.toShortString(), link.toString(), rlink.toString()};
                    logger.log(32, br.getKString("B3242", args));
                    Broker.getBroker().exit(1, br.getString("B3242", args), BrokerEvent.Type.FATAL_ERROR, null, false, true, false);
                }
                return false;
            }
            this.brokerList.put(b, link);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBroker(BrokerAddressImpl remote, BrokerLink link, boolean broken) {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink reallink = (BrokerLink)this.brokerList.get(remote);
            if (reallink != null && reallink != link) {
                return;
            }
            if (this.brokerList.remove(remote) == null) {
                return;
            }
            this.brokerList.notify();
        }
        this.cb.removeBrokerInfo(remote, broken);
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Removed link with = {0}", remote);
        }
    }

    protected void handleBrokerLinkShutdown(BrokerAddressImpl remote) {
        this.connectList.remove(remote.getMQAddress());
    }

    @Override
    public void receivedFileTransferRequest(BrokerAddress from, String uuid) {
        this.pendingFileTransfers.put(from, uuid + ":" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptConnection(Socket conn, boolean ssl) throws IOException {
        BrokerAddressImpl remote;
        block22: {
            boolean elog = false;
            remote = null;
            try {
                Object o = BrokerLink.consumeLinkInit(conn, null, this, true);
                if (o instanceof BrokerAddressImpl) {
                    remote = (BrokerAddressImpl)o;
                    if (remote == null) {
                        return;
                    }
                    break block22;
                }
                if (o == null) {
                    return;
                }
                elog = true;
                LinkInfo li = (LinkInfo)o;
                remote = li.getAddress();
                if (li.isFileTransferRequest()) {
                    logger.log(8, br.getKString("B1400", remote + "[" + conn.getInetAddress() + "]"));
                    ExecutorService es = null;
                    Map<String, ExecutorService> map = this.fileTransferExecutors;
                    synchronized (map) {
                        if (this.fileTransferShutdownIn) {
                            String emsg = br.getKString("B2251");
                            logger.log(16, emsg);
                            throw new BrokerException(emsg);
                        }
                        String key = remote.getMQAddress().getHostAddressNPort() + ":" + li.getAddress().getBrokerID();
                        es = this.fileTransferExecutors.get(key);
                        if (es != null) {
                            es.shutdownNow();
                            this.fileTransferExecutors.remove(key);
                        }
                        es = Executors.newSingleThreadExecutor();
                        this.fileTransferExecutors.put(key, es);
                    }
                    FileTransferRunnable runner = new FileTransferRunnable(conn, 15000, remote, es, this);
                    es.execute(runner);
                    return;
                }
                logger.log(32, br.getKString("B3287", "LINK_INIT[" + remote.getClusterVersion() + "]", remote + "[" + conn.getInetAddress() + "]"));
                conn.close();
                return;
            }
            catch (Exception e) {
                if (elog) {
                    if (e instanceof BrokerException) {
                        logger.log(16, e.getMessage(), e);
                    } else {
                        logger.logStack(16, e.getMessage(), e);
                    }
                } else if (DEBUG) {
                    logger.logStack(16, e.getMessage(), e);
                }
                conn.close();
                return;
            }
        }
        BrokerMQAddress key = remote.getMQAddress();
        BrokerLink oldlink = null;
        Map es = this.connectList;
        synchronized (es) {
            oldlink = (BrokerLink)this.connectList.get(key);
            if (oldlink != null && this.connectionInitiator(remote)) {
                this.connectList.remove(key);
                oldlink.shutdown();
                oldlink = null;
            }
        }
        if (oldlink != null) {
            oldlink.acceptConnection(remote, conn, ssl);
            return;
        }
        BrokerLink link = new BrokerLink(this.self, remote, this);
        link.setAutoConnect(false);
        if (link.acceptConnection(remote, conn, ssl)) {
            link.start();
        }
    }

    protected Packet getLinkInitPkt() {
        return this.getLinkInitPkt(null);
    }

    private Packet getLinkInitPkt(Integer service) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (service == null) {
                dos.writeInt(this.self.getClusterVersion());
            } else {
                dos.writeInt(service);
            }
            dos.writeUTF(this.self.getHostName());
            dos.writeUTF(this.self.getInstanceName());
            dos.writeInt(this.self.getPort());
            BrokerAddressImpl cs = (BrokerAddressImpl)this.getConfiguredConfigServer();
            dos.writeBoolean(cs != null);
            if (cs != null) {
                dos.writeUTF(cs.getHostName());
                dos.writeUTF(cs.getInstanceName());
                dos.writeInt(cs.getPort());
            }
            dos.writeInt(this.matchProps.size());
            Enumeration<?> e = this.matchProps.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                dos.writeUTF(prop);
                dos.writeUTF(this.matchProps.getProperty(prop));
            }
            dos.writeBoolean(Globals.getHAEnabled());
            dos.writeBoolean(this.self.getBrokerID() != null);
            if (this.self.getBrokerID() != null) {
                dos.writeUTF(this.self.getBrokerID());
            }
            dos.writeLong(this.self.getBrokerSessionUID().longValue());
            if (Globals.getHAEnabled()) {
                dos.writeLong(this.self.getStoreSessionUID().longValue());
            } else {
                UID uid = this.self.getStoreSessionUID();
                dos.writeBoolean(uid != null);
                if (uid != null) {
                    dos.writeLong(uid.longValue());
                }
            }
            dos.flush();
            bos.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] buf = bos.toByteArray();
        Packet p = new Packet();
        p.setPacketType(4);
        p.setPacketBody(buf);
        p.setDestId(0);
        return p;
    }

    protected static LinkInfo processLinkInit(Packet p) throws Exception {
        String hostName = null;
        String instName = null;
        String brokerID = null;
        UID brokerSessionUID = null;
        UID storeSessionUID = null;
        boolean ha = false;
        int port = 0;
        BrokerAddressImpl remote = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(p.getPacketBody());
        DataInputStream dis = new DataInputStream(bis);
        int clusterVersion = dis.readInt();
        hostName = dis.readUTF();
        instName = dis.readUTF();
        port = dis.readInt();
        BrokerAddressImpl configServer = null;
        boolean hasConfigServer = false;
        String cfgHostName = null;
        String cfgInstName = null;
        int cfgPort = 0;
        hasConfigServer = dis.readBoolean();
        if (hasConfigServer) {
            cfgHostName = dis.readUTF();
            cfgInstName = dis.readUTF();
            cfgPort = dis.readInt();
        }
        Properties props = new Properties();
        int nprops = dis.readInt();
        for (int i = 0; i < nprops; ++i) {
            String prop = dis.readUTF();
            String value = dis.readUTF();
            props.setProperty(prop, value);
        }
        if (clusterVersion >= 400) {
            ha = dis.readBoolean();
            if (dis.readBoolean()) {
                brokerID = dis.readUTF();
            }
            brokerSessionUID = new UID(dis.readLong());
            if (ha) {
                storeSessionUID = new UID(dis.readLong());
            } else {
                try {
                    if (dis.readBoolean()) {
                        storeSessionUID = new UID(dis.readLong());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (hasConfigServer) {
            if (ha) {
                throw new BrokerException(br.getKString("B3196"));
            }
            configServer = new BrokerAddressImpl(cfgHostName, cfgInstName, cfgPort, ha, null, null, null);
        }
        remote = new BrokerAddressImpl(hostName, instName, port, ha, brokerID, brokerSessionUID, storeSessionUID);
        remote.setClusterVersion(clusterVersion);
        LinkInfo li = new LinkInfo(remote, configServer, props);
        if (clusterVersion < 0) {
            int type = clusterVersion;
            li.setServiceRequestType(type);
        }
        return li;
    }

    private boolean connectionInitiator(BrokerAddressImpl remote) {
        return this.self.getMQAddress().hashCode() > remote.getMQAddress().hashCode();
    }

    protected Packet getBrokerInfoPkt() {
        BrokerInfo selfInfo = this.cb.getBrokerInfo();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(selfInfo);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] buf = bos.toByteArray();
        Packet p = new Packet();
        p.setPacketType(3);
        p.setPacketBody(buf);
        p.setDestId(0);
        return p;
    }

    protected ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo remote) throws Exception {
        if (this.cb == null) {
            throw new BrokerException(br.getKString("B4241"), 503);
        }
        return this.cb.getBrokerInfoReply(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerInfo receiveBrokerInfo(BrokerAddressImpl sender, byte[] pkt, String realRemote, BrokerLink l) {
        ByteArrayInputStream bis = new ByteArrayInputStream(pkt);
        BrokerInfo info = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            info = (BrokerInfo)ois.readObject();
            info.setRealRemoteString(realRemote);
        }
        catch (Exception e) {
            logger.log(16, "B2068", sender);
            if (l != null) {
                l.shutdown();
            }
            return null;
        }
        Integer v = info.getClusterProtocolVersion();
        if (v != null && v >= 400) {
            return info;
        }
        if (l != null) {
            l.handshakeSent();
        }
        int status = this.cb.addBrokerInfo(info);
        if (status == 0) {
            return info;
        }
        if (status == 1) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink link = (BrokerLink)this.brokerList.get(sender);
                if (link != null) {
                    link.closeConn();
                }
            }
        }
        if (status == 2) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink link = (BrokerLink)this.brokerList.get(sender);
                if (link != null) {
                    link.shutdown();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveBrokerInfoReply(BrokerAddressImpl sender, GPacket gp, String realRemote) {
        BrokerInfo info = null;
        try {
            ClusterBrokerInfoReply cbi = ClusterBrokerInfoReply.newInstance(gp);
            info = cbi.getBrokerInfo();
            info.setRealRemoteString(realRemote);
            if (DEBUG) {
                logger.log(4, "Received BROKER_INFO_REPLY from " + sender);
            }
            if (!info.getBrokerAddr().equals(sender)) {
                logger.log(32, "B3100", "mismatched BROKER_INFO (" + info.getBrokerAddr() + ") from " + sender);
                throw new BrokerException("mismatched BROKER_INFO");
            }
            if (Globals.getHAEnabled() && cbi.isTakingover()) {
                String msg = br.getKString("B3186", sender);
                BrokerException ex = new BrokerException(msg);
                logger.log(32, msg);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), msg, BrokerEvent.Type.RESTART, null, true, true, true);
                throw ex;
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            logger.logStack(32, e.getMessage(), e);
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink link = (BrokerLink)this.brokerList.get(sender);
                if (link != null) {
                    link.shutdown();
                }
            }
            return;
        }
        int status = this.cb.addBrokerInfo(info);
        if (status == 0) {
            return;
        }
        if (status == 1) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink link = (BrokerLink)this.brokerList.get(sender);
                if (link != null) {
                    link.closeConn();
                }
            }
        }
        if (status == 2) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink link = (BrokerLink)this.brokerList.get(sender);
                if (link != null) {
                    link.shutdown();
                }
            }
        }
    }

    protected GPacket getFirstInfoPacket() {
        if (!Globals.useSharedConfigRecord()) {
            return null;
        }
        ChangeRecordInfo cri = this.cb.getLastStoredChangeRecord();
        if (cri == null) {
            return null;
        }
        ClusterFirstInfoInfo cii = ClusterFirstInfoInfo.newInstance();
        cii.setLastStoredChangeRecord(cri);
        cii.setBroadcast(false);
        return cii.getGPacket();
    }

    protected void processFirstInfoPacket(GPacket gp, BrokerLink link) {
        try {
            if (!Globals.useSharedConfigRecord()) {
                throw new BrokerException("Unexpected " + ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + " packet from " + link.getRemote());
            }
            ClusterFirstInfoInfo cii = ClusterFirstInfoInfo.newInstance(gp);
            ChangeRecordInfo cri = cii.getLastStoredChangeRecord();
            if (cri == null) {
                return;
            }
            logger.log(8, br.getKString("B1369", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[(sharecc)" + cri.toString() + "]", link.getRemote()));
            this.cb.syncChangeRecordOnJoin(link.getRemote(), cri);
        }
        catch (Exception e) {
            logger.logStack(32, e.getMessage(), e);
            if (e instanceof BrokerException && ((BrokerException)e).getStatusCode() == 412) {
                link.shutdown();
                return;
            }
            link.closeConn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlowControl(BrokerAddressImpl addr, boolean enabled) {
        BrokerLink link = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            link = (BrokerLink)this.brokerList.get(addr);
        }
        if (link != null) {
            link.setFlowControl(enabled);
        }
    }

    protected Object receivePacket(BrokerAddressImpl from, Packet p, String realRemote, BrokerLink l) {
        BrokerInfo ret = null;
        if (this.cb == null) {
            return ret;
        }
        switch (p.getPacketType()) {
            case 1: {
                this.cb.receiveUnicast(from, p.getDestId(), p.getPacketBody());
                break;
            }
            case 2: {
                this.cb.receiveBroadcast(from, p.getDestId(), p.getPacketBody());
                break;
            }
            case 3: {
                ret = this.receiveBrokerInfo(from, p.getPacketBody(), realRemote, l);
                break;
            }
            case 5: {
                this.setFlowControl(from, true);
                break;
            }
            case 6: {
                this.setFlowControl(from, false);
                break;
            }
            case 7: {
                if (!DEBUG) break;
                logger.log(4, "ClusterImpl: Received ping from : " + from);
                break;
            }
            default: {
                logger.log(16, "ClusterImpl: INTERNAL ERROR - Received Unknown packet from : " + from);
            }
        }
        return ret;
    }

    protected void receivePacket(BrokerAddressImpl from, GPacket gp, String realRemote) {
        if (gp.getType() == 46) {
            this.receiveBrokerInfoReply(from, gp, realRemote);
            return;
        }
        if (this.cb == null) {
            return;
        }
        if (gp.getBit(2)) {
            this.cb.receiveBroadcast(from, gp);
        } else {
            this.cb.receiveUnicast(from, gp);
        }
    }

    @Override
    public void useGPackets(boolean useGPackets) {
        this.useGPackets = useGPackets;
    }

    @Override
    public void setCallback(ClusterCallback cb) {
        this.cb = cb;
        this.self.setClusterVersion(cb.getHighestSupportedVersion());
    }

    @Override
    public void setMatchProps(Properties matchProps) {
        this.matchProps = matchProps;
    }

    protected Properties getMatchProps() {
        return this.matchProps;
    }

    @Override
    public BrokerAddress getSelfAddress() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress getConfigServer() throws BrokerException {
        Object object = this.configServerLock;
        synchronized (object) {
            if (!this.configServerResolved) {
                if (Globals.getConfig().getBooleanProperty("imq.cluster.masterbroker.enforce", true)) {
                    throw new BrokerException(Globals.getBrokerResources().getString("B4118", this.configServer == null ? "null" : this.configServer.toString()));
                }
                return null;
            }
            return this.configServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeMasterBroker(BrokerAddress newmaster, BrokerAddress oldmaster) throws BrokerException {
        Object object = this.configServerLock;
        synchronized (object) {
            logger.log(8, br.getKString("B1381", this.configServer == null ? "null" : this.configServer.toString(), newmaster.toString()));
            if (this.configServer == null) {
                throw new BrokerException(br.getKString("B4333"), 412);
            }
            if (!oldmaster.equals(this.configServer)) {
                throw new BrokerException(br.getKString("B4337", oldmaster.toString(), this.configServer.toString()), 412);
            }
            BrokerAddressImpl oldconfigServer = this.configServer;
            this.configServer = (BrokerAddressImpl)newmaster;
            String newmasterhp = newmaster.getMQAddress().getHostAddressNPort();
            String oldmasterhp = Globals.getConfig().getProperty("imq.cluster.masterbroker");
            Properties prop = new Properties();
            prop.put("imq.cluster.masterbroker", newmasterhp);
            try {
                Globals.getConfig().updateProperties(prop, true);
            }
            catch (Exception e) {
                String emsg = br.getKString("B3272", e.getMessage());
                logger.logStack(32, emsg, e);
                try {
                    prop.put("imq.cluster.masterbroker", oldmasterhp);
                }
                catch (Exception e1) {
                    logger.log(32, br.getKString("B3273", e1.getMessage()));
                    throw new BrokerException(emsg, e, 500);
                }
                this.configServer = oldconfigServer;
                throw new BrokerException(emsg, e, 412);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrokerAddress getConfiguredConfigServer() {
        Object object = this.configServerLock;
        synchronized (object) {
            return this.configServer;
        }
    }

    @Override
    public void marshalBrokerAddress(BrokerAddress addr, GPacket gp) {
        ((BrokerAddressImpl)addr).writeBrokerAddress(gp);
    }

    @Override
    public BrokerAddress unmarshalBrokerAddress(GPacket gp) throws Exception {
        return BrokerAddressImpl.readBrokerAddress(gp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (!this.supportClusters) {
            return;
        }
        this.clsmgr.addEventListener(this);
        Map map = this.connectList;
        synchronized (map) {
            Collection values = this.connectList.values();
            for (BrokerLink link : values) {
                link.start();
            }
        }
        this.listener = new ClusterServiceListener(this);
        Object[] args = new Object[]{SERVICE_NAME, this.getTransport() + " [ " + this.getServerSocketString() + " ]", new Integer(1), new Integer(1)};
        logger.log(8, "B1004", args);
        if (Globals.getClusterID() != null) {
            logger.log(8, "B1229", Globals.getClusterID());
        }
        if (!this.configServerResolved) {
            this.warningTask = new WarningTask(this);
            Globals.getTimer().schedule(this.warningTask, 60000L, 180000L);
        }
        if (this.pingInterval <= 0L) {
            this.pingInterval = 60000L;
        }
        long p = this.pingInterval / 1000L;
        this.pingTimer = new PingTimerTask();
        logger.log(8, "B1228", new Long(p));
        Globals.getTimer().schedule((TimerTask)this.pingTimer, this.pingInterval, this.pingInterval);
    }

    protected String getServerSocketString() {
        ClusterServiceListener l = this.listener;
        if (l != null) {
            return l.getServerSocketString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean force, BrokerAddress excludedBroker) {
        if (!this.supportClusters) {
            return;
        }
        if (this.listener != null && excludedBroker == null) {
            this.listener.shutdown();
        }
        if (this.brokerList == null) {
            return;
        }
        Map<String, ExecutorService> map = this.fileTransferExecutors;
        synchronized (map) {
            this.fileTransferShutdownIn = true;
            if (excludedBroker == null) {
                this.fileTransferShutdownOut = true;
            }
            Iterator<Map.Entry<String, ExecutorService>> itr = this.fileTransferExecutors.entrySet().iterator();
            Map.Entry<String, ExecutorService> entry = null;
            while (itr.hasNext()) {
                entry = itr.next();
                entry.getValue().shutdownNow();
                itr.remove();
            }
        }
        long timeout = Globals.getConfig().getIntProperty(SHUTDOWN_TIMEOUT_PROP, 30);
        long waittime = timeout * 1000L;
        long endtime = System.currentTimeMillis() + waittime;
        int pv = -1;
        try {
            pv = Globals.getClusterBroadcast().getClusterVersion();
        }
        catch (Exception e) {
            logger.log(4, "Unable to get cluster protocol version on cluster shutdown: " + e.getMessage());
        }
        if (pv >= 400 && !force) {
            HashMap e = this.brokerList;
            synchronized (e) {
                while (this.brokerList.size() != 0 && (this.brokerList.size() != 1 || excludedBroker == null || this.brokerList.get(excludedBroker) == null)) {
                    logger.log(8, br.getKString("B1188", new Integer(this.brokerList.size())));
                    try {
                        this.brokerList.wait(waittime);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    long curtime = System.currentTimeMillis();
                    if (curtime >= endtime) {
                        if (this.brokerList.size() <= 0) break;
                        logger.log(16, br.getKString("B2125"));
                        break;
                    }
                    waittime = endtime - curtime;
                }
            }
        }
        BrokerAddress remote = null;
        BrokerLink l = null;
        Map map2 = this.brokerList;
        synchronized (map2) {
            Iterator itr = this.brokerList.keySet().iterator();
            while (itr.hasNext()) {
                remote = (BrokerAddress)itr.next();
                if (excludedBroker != null && remote.equals(excludedBroker)) continue;
                l = (BrokerLink)this.brokerList.get(remote);
                logger.log(16, br.getKString("B2126", remote, br.getString("B0084")));
                l.shutdown();
                itr.remove();
            }
        }
        map2 = this.connectList;
        synchronized (map2) {
            Collection values = this.connectList.values();
            for (BrokerLink link : values) {
                BrokerAddressImpl addr;
                if (excludedBroker != null && (addr = link.getRemote()) != null && ((BrokerAddress)addr).equals(excludedBroker)) continue;
                link.shutdown();
            }
        }
        if (this.warningTask != null) {
            try {
                this.warningTask.cancel();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.warningTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLink(BrokerAddress remote, boolean force) {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink l = (BrokerLink)this.brokerList.get(remote);
            if (l != null) {
                l.closeConn(force);
            }
            this.brokerList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLink(String brokerID, UID storeSession) {
        if (!Globals.getHAEnabled()) {
            return;
        }
        BrokerAddress remote2 = null;
        BrokerLink l = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            for (BrokerAddress remote2 : this.brokerList.keySet()) {
                l = (BrokerLink)this.brokerList.get(remote2);
                if (!remote2.getBrokerID().equals(brokerID) || storeSession != null && !remote2.getStoreSessionUID().equals(storeSession)) continue;
                logger.log(16, br.getKString("B2127", remote2));
                l.closeConn(false);
            }
        }
    }

    @Override
    public boolean isReachable(BrokerAddress remote, int timeout) throws IOException {
        Class<?> inetc = null;
        Method m = null;
        try {
            inetc = Class.forName("java.net.InetAddress");
            m = inetc.getMethod("isReachable", Integer.TYPE);
            boolean b = (Boolean)m.invoke((Object)((BrokerAddressImpl)remote).getHost(), new Integer(timeout * 1000));
            if (b) {
                logger.log(8, br.getKString("B1244", remote, new Integer(timeout)));
            } else {
                logger.log(8, br.getKString("B1245", remote, new Integer(timeout)));
            }
            return b;
        }
        catch (ClassNotFoundException e) {
            logger.logStack(16, e.getMessage(), e);
            return true;
        }
        catch (NoSuchMethodException e) {
            if (DEBUG) {
                logger.logStack(16, e.getMessage(), e);
            }
            return true;
        }
        catch (Exception e) {
            logger.logStack(16, e.getMessage(), e);
            return true;
        }
    }

    public void waitClusterInit() {
        BrokerLink link = null;
        Object[] values = this.connectList.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            link = (BrokerLink)values[i];
            link.waitLinkInit();
        }
        this.readyForBroadcast = true;
    }

    @Override
    public long getLinkInitWaitTime() {
        return BrokerLink.INIT_WAIT_TIME;
    }

    public void sendFlowControlUpdate(BrokerAddressImpl addr) throws IOException {
        if (this.flowControlState == 5) {
            this.sendFlowControlUpdate(addr, this.flowControlState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFlowControlUpdate(BrokerAddressImpl addr, int type) throws IOException {
        Packet p = new Packet();
        p.setPacketType(type);
        p.setPacketBody(null);
        p.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            if (addr != null) {
                BrokerLink link = (BrokerLink)this.brokerList.get(addr);
                link.sendPacket(p);
            } else {
                Collection values = this.brokerList.values();
                for (BrokerLink link : values) {
                    link.sendPacket(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 5;
        }
        this.sendFlowControlUpdate(null, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 6;
        }
        this.sendFlowControlUpdate(null, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingGPacket() throws Exception {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)33);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection values = this.brokerList.values();
            for (BrokerLink link : values) {
                if (!link.isIOActive()) {
                    try {
                        link.sendPacket(gp);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                link.clearIOActiveFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingPacket() throws Exception {
        Packet p = new Packet();
        p.setPacketType(7);
        p.setPacketBody(null);
        p.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection values = this.brokerList.values();
            for (BrokerLink link : values) {
                if (!link.isIOActive()) {
                    try {
                        link.sendPacket(p);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                link.clearIOActiveFlag();
            }
        }
    }

    @Override
    public void unicastUrgent(BrokerAddress addr, GPacket gp) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        this.unicast(addr, gp, false, false, true);
    }

    @Override
    public void unicast(BrokerAddress addr, GPacket gp) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        this.unicast(addr, gp, false, false, false);
    }

    @Override
    public void unicastAndClose(BrokerAddress addr, GPacket gp) throws IOException {
        this.unicast(addr, gp, false, true, false);
    }

    @Override
    public void unicast(BrokerAddress addr, GPacket gp, boolean flowControl) throws IOException {
        this.unicast(addr, gp, flowControl, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unicast(BrokerAddress addr, GPacket gp, boolean flowControl, boolean close, boolean urgent) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        if (addr.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, gp);
            }
            return;
        }
        BrokerLink link = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            link = (BrokerLink)this.brokerList.get(addr);
        }
        if (link == null) {
            throw new IOException(br.getString("B4205", addr.toString()));
        }
        gp.setBit(32, flowControl);
        link.sendPacket(gp, close, urgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(GPacket gp) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket broadcast on old cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        gp.setBit(2, true);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection values = this.brokerList.values();
            for (BrokerLink link : values) {
                link.sendPacket(gp);
            }
        }
    }

    @Override
    public void unicast(BrokerAddress addr, int destId, byte[] pkt) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        this.unicast(addr, destId, pkt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unicast(BrokerAddress addr, int destId, byte[] pkt, boolean flowControl) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        if (addr.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, destId, pkt);
            }
            return;
        }
        BrokerLink link = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            link = (BrokerLink)this.brokerList.get(addr);
        }
        if (link == null) {
            throw new IOException("Packet send failed. Unreachable BrokerAddress : " + addr);
        }
        Packet p = new Packet();
        p.setPacketType(1);
        p.setPacketBody(pkt);
        p.setDestId(destId);
        p.setFlag(1, flowControl);
        link.sendPacket(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(int destId, byte[] pkt) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet broadcast on raptor cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        Packet p = new Packet();
        p.setPacketType(2);
        p.setPacketBody(pkt);
        p.setDestId(destId);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection values = this.brokerList.values();
            for (BrokerLink link : values) {
                link.sendPacket(p);
            }
        }
    }

    @Override
    public void reloadCluster() {
        try {
            this.clsmgr.reloadConfig();
        }
        catch (Exception e) {
            logger.logStack(16, br.getKString("B2128"), e);
        }
    }

    @Override
    public void clusterPropertyChanged(String name, String value) {
        if (name.equals("imq.cluster.port")) {
            try {
                this.setListenPort(Integer.valueOf(value));
            }
            catch (IOException e) {
                logger.logStack(32, e.getMessage(), e);
            }
        }
    }

    @Override
    public void brokerAdded(ClusteredBroker broker, UID uid) {
        if (!broker.isConfigBroker()) {
            if (DEBUG) {
                logger.log(8, "ClusterImpl:brokerAdded: Ignore dynamic broker " + broker);
            }
            return;
        }
        BrokerMQAddress key = (BrokerMQAddress)broker.getBrokerURL();
        if (!key.equals(this.self.getMQAddress()) && !this.connectList.containsKey(key)) {
            if (this.connectList.size() > this.connLimit) {
                logger.log(32, "B3091", Integer.toString(this.connLimit + 1));
                return;
            }
            boolean newLink = false;
            BrokerLink link = this.searchBrokerList(key);
            if (link == null) {
                BrokerAddressImpl b = null;
                try {
                    b = new BrokerAddressImpl(key, null, Globals.getHAEnabled(), broker.getBrokerName());
                    link = new BrokerLink(this.self, b, this);
                    newLink = true;
                }
                catch (Exception e) {
                    logger.logStack(32, br.getKString("B2129", broker), e);
                    return;
                }
            }
            link.setAutoConnect(true);
            this.connectList.put(key, link);
            if (DEBUG) {
                logger.log(8, "ClusterImpl: Added link to connectList - " + link);
            }
            if (newLink) {
                link.start();
            }
            return;
        }
        if (DEBUG) {
            logger.log(8, "Broker link for " + key + " (" + broker + ") already exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("self", this.self.toString());
        BrokerAddressImpl cs = this.configServer;
        if (cs != null) {
            ht.put("configServer[masterbroker]", cs.toString());
            ht.put("configServerResolved", this.configServerResolved);
        }
        ArrayList clist = null;
        Map map = this.connectList;
        synchronized (map) {
            clist = new ArrayList(this.connectList.keySet());
        }
        ht.put("connectListCount", String.valueOf(clist.size()));
        for (BrokerMQAddress key : clist) {
            BrokerLink link = (BrokerLink)this.connectList.get(key);
            if (link == null) continue;
            ht.put(key.toString(), link.toString());
        }
        return ht;
    }

    @Override
    public void brokerRemoved(ClusteredBroker broker, UID uid) {
        if (!broker.isConfigBroker()) {
            if (DEBUG) {
                logger.log(8, "ClusterImpl:brokerRemoved: Ignore dynamic broker " + broker);
            }
            return;
        }
        BrokerMQAddress key = (BrokerMQAddress)broker.getBrokerURL();
        BrokerLink link = (BrokerLink)this.connectList.remove(key);
        if (link != null) {
            link.shutdown();
            if (DEBUG) {
                logger.log(8, "ClusterImpl: Removed link from connectList - " + link);
            }
            return;
        }
        if (DEBUG) {
            logger.log(8, "Broker link for " + key + " (" + broker + ") not exist");
        }
    }

    @Override
    public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
    }

    @Override
    public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID brokerSession, Object userData) {
        ClusteredBroker cb = this.clsmgr.getBroker(brokerid);
        if (!(cb instanceof HAClusteredBroker)) {
            return;
        }
        if (cb.isLocalBroker()) {
            return;
        }
        if (BrokerStatus.getBrokerIsDown(newStatus)) {
            this.closeLink(cb.getBrokerName(), (UID)userData);
        }
    }

    @Override
    public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
    }

    @Override
    public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
    }

    @Override
    public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFiles(String[] fileNames, BrokerAddress targetBroker, Long syncTimeout, String uuid, String myBrokerID, String module, FileTransferCallback callback) throws BrokerException {
        String to = targetBroker.toString();
        Socket socket = null;
        MessageDigest digest = null;
        try {
            if (this.fileTransferShutdownOut) {
                String emsg = br.getKString("B2251");
                logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            try {
                digest = MessageDigest.getInstance("SHA1");
            }
            catch (Exception e) {
                String emsg = "";
                if (e instanceof NoSuchAlgorithmException) {
                    emsg = "Unable to create MessageDigest for file transfer";
                    logger.log(32, emsg + ": " + e);
                } else {
                    emsg = "Unexpectd exception in creating MessageDigest for file transfer";
                    logger.logStack(32, emsg, e);
                }
                throw new BrokerException(emsg, e);
            }
            logger.log(8, br.getKString("B1406", targetBroker));
            socket = BrokerLink.makeSocket((BrokerAddressImpl)targetBroker, this, false, null);
            to = to + "[" + socket.getInetAddress() + "]";
            try {
                socket.setTcpNoDelay(false);
            }
            catch (Exception e) {
                logger.log(16, "Failed to set socket TCP_NODELAY for file transfer: " + e);
            }
            try {
                socket.setSoTimeout((int)Math.min(300000L, syncTimeout));
            }
            catch (Exception e) {
                logger.log(16, "Failed to set socket timeout for file transfer: " + e);
            }
            OutputStream os = socket.getOutputStream();
            logger.log(8, br.getKString("B1408", to));
            Packet pkt = this.getLinkInitPkt(-5000);
            pkt.writePacket(os);
            os.flush();
            int numFiles = fileNames.length;
            ClusterTransferFileListInfo tfl = ClusterTransferFileListInfo.newInstance(uuid, myBrokerID, numFiles, "store");
            Object[] tmpargs = new Object[]{String.valueOf(numFiles), tfl.toString(), to};
            logger.log(8, br.getKString("B1409", tmpargs));
            GPacket gp = tfl.getGPacket();
            gp.write(os);
            os.flush();
            String filename = null;
            long filesize = 0L;
            long lastmodtime = 0L;
            for (int cnt = 0; cnt < numFiles; ++cnt) {
                filename = fileNames[cnt];
                logger.log(8, br.getKString("B1407", filename + " [" + tmpargs + "]", to));
                if (this.fileTransferShutdownOut) {
                    String emsg = br.getKString("B2251");
                    logger.log(16, emsg);
                    throw new BrokerException(emsg);
                }
                HashMap props = new HashMap();
                FileInputStream is = callback.getFileInputStream(filename, targetBroker, props);
                try {
                    filesize = (Long)props.get("filesize");
                    lastmodtime = (Long)props.get("lastmodtime");
                    ClusterTransferFileStartInfo tfs = ClusterTransferFileStartInfo.newInstance(uuid, module, myBrokerID, filename, filesize, lastmodtime);
                    gp = tfs.getGPacket();
                    gp.write(os);
                    os.flush();
                    digest.reset();
                    byte[] buf = new byte[8192];
                    int totalread = 0;
                    while ((long)totalread < filesize) {
                        String emsg;
                        if (this.fileTransferShutdownOut) {
                            String emsg2 = br.getKString("B2251");
                            logger.log(16, emsg2);
                            throw new BrokerException(emsg2);
                        }
                        int count = 0;
                        try {
                            count = ((InputStream)is).read(buf, 0, (int)Math.min(8192L, filesize - (long)totalread));
                        }
                        catch (IOException e) {
                            emsg = br.getKString("B3294", filename);
                            throw new BrokerException(emsg);
                        }
                        if (count < 0) {
                            Object[] args = new String[]{String.valueOf(totalread), String.valueOf(filesize - (long)totalread), filename};
                            emsg = br.getKString("B3293", args);
                            throw new BrokerException(emsg);
                        }
                        totalread += count;
                        os.write(buf, 0, count);
                        os.flush();
                        digest.update(buf, 0, count);
                    }
                    byte[] dg = digest.digest();
                    ClusterTransferFileEndInfo tfe = ClusterTransferFileEndInfo.newInstance(uuid, module, myBrokerID, filename, dg, cnt + 1 < numFiles);
                    gp = tfe.getGPacket();
                    gp.write(os);
                    os.flush();
                    continue;
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {}
                }
            }
            if (numFiles > 0) {
                InputStream sis;
                block41: {
                    sis = socket.getInputStream();
                    gp = GPacket.getInstance();
                    gp.read(sis);
                    if (gp.getType() != 70) {
                        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), to, ProtocolGlobals.getPacketTypeDisplayString(70)};
                        String emsg = br.getKString("B3295", args);
                        logger.log(32, emsg);
                        throw new BrokerException(emsg);
                    }
                    int status = ClusterTransferFileEndInfo.getReplyStatus(gp);
                    if (status != 200) {
                        throw new BrokerException(ClusterTransferFileEndInfo.getReplyStatusReason(gp));
                    }
                    try {
                        gp = ClusterTransferFileEndInfo.getReplyAckGPacket(200, null);
                        gp.write(os);
                        os.flush();
                    }
                    catch (Throwable t) {
                        if (!DEBUG) break block41;
                        logger.log(8, "Exception in sending " + ProtocolGlobals.getPacketTypeDisplayString(71) + " to " + to);
                    }
                }
                try {
                    sis.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
        catch (Throwable t) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            StringBuffer buf = new StringBuffer();
            if (fileNames != null) {
                int len = fileNames.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(fileNames[i]);
                }
            }
            String emsg = br.getKString("B4365", "[" + buf.toString() + "[" + uuid + "]]: " + (t instanceof EOFException ? "peer socket closed" : t.getMessage()), to);
            logger.log(32, emsg);
            if (t instanceof BrokerException) {
                throw (BrokerException)t;
            }
            throw new BrokerException(emsg, t);
        }
    }

    private class PingTimerTask
    extends TimerTask {
        private PingTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (ClusterImpl.this.useGPackets) {
                    ClusterImpl.this.sendPingGPacket();
                } else {
                    ClusterImpl.this.sendPingPacket();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

