/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;

public class ClusterGoodbyeInfo {
    private boolean requestTakeover = false;
    private Cluster c = null;
    private GPacket pkt = null;
    private BrokerAddress sender = null;

    private ClusterGoodbyeInfo(boolean requestTakeover, Cluster c) {
        this.requestTakeover = requestTakeover;
        this.c = c;
    }

    private ClusterGoodbyeInfo(GPacket pkt, Cluster c) throws Exception {
        assert (pkt.getType() == 37);
        this.pkt = pkt;
        this.c = c;
        this.sender = c.unmarshalBrokerAddress(pkt);
        if (this.sender.getHAEnabled()) {
            this.requestTakeover = (Boolean)pkt.getProp("requestTakeover");
        }
    }

    public static ClusterGoodbyeInfo newInstance(boolean requestTakeover, Cluster c) {
        return new ClusterGoodbyeInfo(requestTakeover, c);
    }

    public static ClusterGoodbyeInfo newInstance(Cluster c) {
        return new ClusterGoodbyeInfo(false, c);
    }

    public static ClusterGoodbyeInfo newInstance(GPacket pkt, Cluster c) throws Exception {
        return new ClusterGoodbyeInfo(pkt, c);
    }

    public GPacket getGPacket() {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)37);
        gp.setBit(1, true);
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        if (this.c.getSelfAddress().getHAEnabled()) {
            gp.putProp("requestTakeover", this.requestTakeover);
        }
        return gp;
    }

    public boolean getRequestTakeover() {
        assert (this.pkt != null);
        Boolean b = (Boolean)this.pkt.getProp("requestTakeover");
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public String toString() {
        if (this.pkt == null) {
            if (Globals.getHAEnabled()) {
                return "requestTakeover=" + this.requestTakeover + " " + this.c.getSelfAddress().toString();
            }
            return this.c.getSelfAddress().toString();
        }
        if (this.sender.getHAEnabled()) {
            return "requestTakeover=" + this.requestTakeover + " " + this.sender.toString();
        }
        return this.sender.toString();
    }

    public static GPacket getReplyGPacket(int status) {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)38);
        gp.putProp("S", new Integer(status));
        return gp;
    }
}

