/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.HashMap;

class Resource {
    private final Logger logger = Globals.getLogger();
    private String resId = null;
    private Object owner = null;
    private long timestamp;
    private long xid;
    private int lockState;
    private boolean shared;
    private int status;
    private HashMap recipients;
    private Cluster c = null;

    public Resource(String resId, Cluster c) {
        this.resId = resId;
        this.c = c;
        this.timestamp = 0L;
        this.xid = 0L;
        this.recipients = new HashMap();
    }

    public String toString() {
        return "[" + this.resId + ", owner=" + this.owner + ", " + Resource.getLockStateString(this.lockState) + ", timestamp=" + this.timestamp + ", shared=" + this.shared + ", xid=" + this.xid + "]";
    }

    public static String getLockStateString(int s) {
        if (s == 1) {
            return "RESOURCE_LOCKED";
        }
        if (s == 0) {
            return "RESOURCE_LOCKING";
        }
        return "UNKNOWN";
    }

    public String getResId() {
        return this.resId;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getXid() {
        return this.xid;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setLockState(int lockState) {
        this.lockState = lockState;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean getShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String showRecipients() {
        String ret = "";
        for (BrokerAddress baddr : this.recipients.keySet()) {
            ret = ret + "\n\t" + baddr.toString();
        }
        return ret;
    }

    public synchronized void prepareLockRequest(BrokerAddress[] brokerList, long xid) {
        this.recipients.clear();
        for (int i = 0; i < brokerList.length; ++i) {
            this.recipients.put(brokerList[i], null);
        }
        this.xid = xid;
        this.status = 0;
    }

    private boolean hasUnreachable(int timeout) {
        boolean hasUnreachable = false;
        for (BrokerAddress baddr : this.recipients.keySet()) {
            try {
                if (this.c.isReachable(baddr, timeout)) continue;
                this.logger.log(8, Globals.getBrokerResources().getKString("B1242", baddr));
                this.c.closeLink(baddr, true);
                hasUnreachable = true;
            }
            catch (IOException e) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B2171", baddr, e.getMessage()));
            }
        }
        return hasUnreachable;
    }

    public synchronized int waitForStatusChange(int timeout, boolean failOntimeout) {
        long waittime = (long)timeout * 1000L;
        long endtime = System.currentTimeMillis() + waittime;
        boolean checkReachable = true;
        while (this.status == 0 && this.recipients.size() > 0) {
            try {
                this.wait(waittime);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.status != 0 || this.recipients.size() == 0) break;
            long curtime = System.currentTimeMillis();
            if (curtime >= endtime) {
                if (!failOntimeout && checkReachable && this.hasUnreachable(timeout)) {
                    waittime = (long)timeout * 1000L;
                    endtime = System.currentTimeMillis() + waittime;
                    checkReachable = false;
                    continue;
                }
                return -1;
            }
            waittime = endtime - curtime;
        }
        return this.status;
    }

    public synchronized void consumeResponse(long xid, BrokerAddress sender, int response) {
        if (xid != this.xid) {
            return;
        }
        if (this.status != 0) {
            return;
        }
        switch (response) {
            case 0: {
                this.recipients.remove(sender);
                break;
            }
            case 1: 
            case 2: {
                this.status = response;
            }
        }
        if (this.status != 0 || this.recipients.size() == 0) {
            this.notify();
        }
    }

    public synchronized void impliedFailure() {
        this.status = 1;
        this.notify();
    }

    public synchronized void brokerAdded(BrokerAddress broker) {
        this.status = 3;
        this.notify();
    }

    public synchronized void brokerRemoved(BrokerAddress broker) {
        if (this.status != 0) {
            return;
        }
        this.recipients.remove(broker);
        if (this.recipients.size() == 0) {
            this.notify();
        }
    }
}

