/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;

public class GoodbyeHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public GoodbyeHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == 37) {
            this.handleGoodbye(sender, pkt);
        } else if (pkt.getType() == 38) {
            this.handleGoodbyeReply(sender, pkt);
        } else {
            this.logger.log(16, "B3100", "Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleGoodbye(BrokerAddress sender, GPacket pkt) {
        try {
            ClusterGoodbyeInfo cgi = ClusterGoodbyeInfo.newInstance(pkt, this.c);
            this.p.goodbyeReceived(sender, cgi);
            this.p.sendGoodbye(sender);
            this.cbDispatcher.processGoodbye(sender, cgi);
            if (cgi.needReply()) {
                GPacket gp = ClusterGoodbyeInfo.getReplyGPacket(200);
                try {
                    this.c.unicastAndClose(sender, gp);
                    this.p.goodbyeReplySent(sender);
                }
                catch (IOException e) {
                    this.logger.logStack(4, Globals.getBrokerResources().getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), sender), e);
                }
            }
        }
        catch (Exception e) {
            this.logger.logStack(8, "B3100", "Unable to process packet: " + pkt, (Throwable)e);
            return;
        }
    }

    public void handleGoodbyeReply(BrokerAddress sender, GPacket pkt) {
        this.cbDispatcher.processGoodbyeReply(sender);
        this.p.goodbyeReplyReceived(sender);
    }
}

