/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.https;

import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerDriver;
import com.sun.messaging.jmq.httptunnel.api.server.HttpsTunnelServerDriver;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.http.HTTPProtocol;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public class HttpsProtocol
extends HTTPProtocol {
    private static final String SERVLET_HOST_TRUSTED_PROP = "isHostTrusted";
    protected boolean isServletHostTrusted = true;

    public HttpsProtocol() {
        this.driverClass = "com.sun.messaging.jmq.httptunnel.tunnel.server.HttpsTunnelServerDriverImpl";
    }

    @Override
    protected void createDriver() throws IOException {
        String name = InetAddress.getLocalHost().getHostName() + ":" + Globals.getConfigName();
        if (this.servletHost != null || this.servletPort != -1) {
            int port;
            String host = this.servletHost;
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            if ((port = this.servletPort) == -1) {
                port = 7674;
            }
            InetAddress paddr = InetAddress.getLocalHost();
            InetAddress saddr = InetAddress.getByName(host);
            InetAddress laddr = InetAddress.getByName("localhost");
            if (port == Globals.getPortMapper().getPort() && (saddr.equals(paddr) || saddr.equals(laddr))) {
                throw new IOException(Globals.getBrokerResources().getString("B4130"));
            }
            try {
                this.driver = (HttpTunnelServerDriver)Class.forName(this.driverClass).newInstance();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            ((HttpsTunnelServerDriver)this.driver).init(name, host, port, this.isServletHostTrusted);
            this.driver.start();
        } else {
            try {
                this.driver = (HttpTunnelServerDriver)Class.forName(this.driverClass).newInstance();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            ((HttpsTunnelServerDriver)this.driver).init(name, this.isServletHostTrusted);
            this.driver.start();
        }
        this.driver.setInactiveConnAbortInterval(this.connectionTimeout);
        this.driver.setRxBufSize(this.rxBufSize);
    }

    @Override
    public String toString() {
        return "https [ " + this.serversocket + "]";
    }

    @Override
    public Map setParameters(Map params) {
        String propval = (String)params.get(SERVLET_HOST_TRUSTED_PROP);
        if (propval != null) {
            try {
                boolean value;
                this.isServletHostTrusted = value = Boolean.valueOf(propval).booleanValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.setParameters(params);
    }
}

