/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tls;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.net.tls.TLSStreams;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.net.MQServerSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class TLSProtocol
extends TcpProtocol {
    private static boolean DEBUG = false;
    private static final int defaultPort = 11001;
    private static boolean TLS_ALLOWED = false;
    private static ServerSocketFactory ssfactory = null;
    protected static Logger logger = Globals.getLogger();
    protected static BrokerResources br = Globals.getBrokerResources();
    private static final Object classlock;

    public static void init() {
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
    }

    public static void destroy() {
        ssfactory = null;
        Object logger = null;
        br = null;
    }

    public TLSProtocol() {
        this.canChangeBlocking = false;
        this.port = 11001;
        if (!TLS_ALLOWED) {
            Globals.getLogger().log(32, "B3123", Globals.getBrokerResources().getString("B0036"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0036")), BrokerEvent.Type.FATAL_ERROR);
        }
    }

    @Override
    public ProtocolStreams accept() throws IOException {
        if (this.serversocket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Unable to accept on un-opened protocol"));
        }
        SSLSocket s = (SSLSocket)this.serversocket.accept();
        try {
            s.setTcpNoDelay(this.nodelay);
        }
        catch (SocketException e) {
            Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + s.toString() + "]setTcpNoDelay(" + this.nodelay + "): " + e.toString(), e);
        }
        TLSStreams streams = this.createConnection(s);
        return streams;
    }

    @Override
    public String toString() {
        return "SSL/TLS [ " + this.port + "," + this.backlog + "]";
    }

    @Override
    protected ServerSocket createSocket(String hostname, int port, int backlog, boolean blocking, boolean useChannel) throws IOException {
        ServerSocketFactory ssf = TLSProtocol.getServerSocketFactory();
        if (hostname != null && !hostname.equals("*")) {
            InetAddress endpoint = InetAddress.getByName(hostname);
            this.serversocket = ssf.createServerSocket(port, backlog, endpoint);
        } else {
            this.serversocket = ssf.createServerSocket(port, backlog);
        }
        if (DEBUG && this.serversocket != null) {
            logger.log(4, "TLSProtocol: " + this.serversocket + " " + MQServerSocketFactory.serverSocketToString(this.serversocket) + ", backlog=" + backlog + "");
        }
        return this.serversocket;
    }

    protected TLSStreams createConnection(SSLSocket socket) throws IOException {
        return new TLSStreams(socket, this.inputBufferSize, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocketFactory getServerSocketFactory() throws IOException {
        Object object = classlock;
        synchronized (object) {
            if (ssfactory == null) {
                try {
                    KeyManagerFactory kmf;
                    String keystore_location = KeystoreUtil.getKeystoreLocation();
                    File kf = new File(keystore_location);
                    if (!kf.exists()) {
                        throw new IOException(br.getKString("B3019", keystore_location));
                    }
                    String pass_phrase = KeystoreUtil.getKeystorePassword();
                    if (pass_phrase == null) {
                        pass_phrase = "";
                        logger.log(32, br.getKString("B3021"));
                    }
                    char[] passphrase = pass_phrase.toCharArray();
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    try {
                        kmf = KeyManagerFactory.getInstance("SunX509");
                    }
                    catch (NoSuchAlgorithmException e) {
                        String defaultAlg = KeyManagerFactory.getDefaultAlgorithm();
                        logger.log(8, br.getKString("B1312", e.getMessage(), defaultAlg));
                        kmf = KeyManagerFactory.getInstance(defaultAlg);
                    }
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(new FileInputStream(keystore_location), passphrase);
                    kmf.init(ks, passphrase);
                    TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    ctx.init(kmf.getKeyManagers(), tm, random);
                    ssfactory = MQServerSocketFactory.wrapFactory(ctx.getServerSocketFactory());
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception ex) {
                    logger.logStack(32, br.getKString("B4022"), ex);
                    throw new IOException(ex.getMessage());
                }
            }
            return ssfactory;
        }
    }

    static {
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            TLS_ALLOWED = license.getBooleanProperty("imq.enable_ssl", false);
        }
        catch (BrokerException ex) {
            TLS_ALLOWED = false;
        }
        classlock = new Object();
    }
}

