/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore200;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class MsgStore {
    static final String MESSAGE_FDPOOL_LIMIT_PROP = "imq.persist.file.message.fdpool.limit";
    static final int DEFAULT_MESSAGE_FDPOOL_LIMIT = 0;
    static final String FILE_POOL_LIMIT_PROP = "imq.persist.file.destination.message.filepool.limit";
    static final int DEFAULT_MESSAGE_FILE_POOL_LIMIT = 100;
    static final String FILE_POOL_CLEANRATIO_PROP = "imq.persist.file.message.filepool.cleanratio";
    static final int DEFAULT_FILE_POOL_CLEANRATIO = 60;
    static final String CLEANUP_MSGSTORE_PROP = "imq.persist.file.message.cleanup";
    static final boolean DEFAULT_CLEANUP_MSGSTORE = true;
    static final String INITIAL_VRFILE_SIZE_PROP = "imq.persist.file.message.vrfile.initial_size";
    static final long DEFAULT_INITIAL_VRFILE_SIZE = 1024L;
    static final String VRFILE_BLOCK_SIZE_PROP = "imq.persist.file.message.vrfile.block_size";
    static final int DEFAULT_VRFILE_BLOCK_SIZE = 256;
    static final String VRFILE_MAX_RECORD_SIZE_PROP = "imq.persist.file.message.max_record_size";
    static final long DEFAULT_VRFILE_MAX_RECORD_SIZE = 1024L;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private BrokerConfig config = Globals.getConfig();
    private static final String MESSAGE_DIR = "message" + File.separator;
    private File msgDir = null;
    int msgfdlimit = 0;
    int poollimit = 100;
    int cleanratio = 60;
    SizeString initialFileSize = null;
    SizeString maxRecordSize = null;
    int blockSize = 0;
    private HashMap dstMap = new HashMap();
    protected FileStore parent = null;
    private static final Enumeration emptyEnum = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    MsgStore(FileStore p, File top, boolean reset) throws BrokerException {
        this.init(p, top);
        if (reset) {
            if (Store.getDEBUG()) {
                this.logger.log(1, "MsgStore initialized with reset option");
            }
            this.clearAll(false);
        }
    }

    MsgStore(FileStore p, File top, File oldTop, boolean reset) throws BrokerException {
        this.init(p, top);
        if (reset) {
            File oldmsgdir = new File(oldTop, MESSAGE_DIR);
            try {
                FileUtil.removeFiles(oldmsgdir, false);
            }
            catch (IOException e) {
                this.logger.log(32, "B4149", (Object)oldmsgdir, (Throwable)e);
                throw new BrokerException(this.br.getString("B4149", oldmsgdir), e);
            }
        }
        boolean deleteold = p.upgradeNoBackup();
        try {
            MsgStore200 oldmsgstore = new MsgStore200(new File(oldTop, MESSAGE_DIR));
            while (oldmsgstore.hasMoreMessages()) {
                Packet msg = oldmsgstore.nextMessage();
                ConsumerUID[] iids = oldmsgstore.nextCUIDs();
                int[] states = oldmsgstore.nextStates();
                DestinationUID dst = DestinationUID.getUID(msg.getDestination(), msg.getIsQueue());
                this.storeMessage(dst, msg, iids, states, false);
                if (!deleteold) continue;
                oldmsgstore.removeData(msg.getSysMessageID(), false);
            }
            oldmsgstore.close();
        }
        catch (IOException e) {
            this.logger.log(32, "B4153", e);
            throw new BrokerException(this.br.getString("B4153"), e);
        }
    }

    private void init(FileStore p, File top) throws BrokerException {
        this.msgfdlimit = this.config.getIntProperty(MESSAGE_FDPOOL_LIMIT_PROP, 0);
        this.poollimit = this.config.getIntProperty(FILE_POOL_LIMIT_PROP, 100);
        this.cleanratio = this.config.getIntProperty(FILE_POOL_CLEANRATIO_PROP, 60);
        this.initialFileSize = this.config.getSizeProperty(INITIAL_VRFILE_SIZE_PROP, 1024L);
        this.blockSize = this.config.getIntProperty(VRFILE_BLOCK_SIZE_PROP, 256);
        this.maxRecordSize = this.config.getSizeProperty(VRFILE_MAX_RECORD_SIZE_PROP, 1024L);
        this.msgDir = new File(top, MESSAGE_DIR);
        if (!this.msgDir.exists() && !this.msgDir.mkdirs()) {
            this.logger.log(32, "B3017", this.msgDir.toString());
            throw new BrokerException(this.br.getString("B3017", this.msgDir.toString()));
        }
        this.parent = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDebugState() {
        Hashtable t = new Hashtable();
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            for (DstMsgStore dstMsgStore : this.dstMap.values()) {
                t.putAll(dstMsgStore.getDebugState());
            }
        }
        return t;
    }

    void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        long tid;
        long tid2;
        if (Store.getDEBUG()) {
            this.logger.log(1, "storeMessage for " + dst);
        }
        if (Globals.isNewTxnLogEnabled() && TransactionLogManager.logNonTransactedMsgSend && !TransactionLogManager.isReplayInProgress() && (tid2 = message.getTransactionID()) <= 0L) {
            TransactionWorkMessage twm = new TransactionWorkMessage(dst, message, iids);
            this.parent.logNonTxnMessage(twm);
            sync = false;
        }
        DstMsgStore msgstore = this.getDstMsgStore(dst, true, true, true);
        MessageInfo info = msgstore.storeMessage(message, iids, states, sync);
        if (Globals.logNonTransactedMsgSend() && !Globals.isNewTxnLogEnabled() && (tid = message.getTransactionID()) <= 0L) {
            byte[] msgBytes = info.getCachedMessageBytes();
            if (msgBytes == null) {
                msgBytes = message.getBytes();
            }
            ByteBuffer bbuf = ByteBuffer.allocate(msgBytes.length + 12);
            bbuf.putLong(tid);
            bbuf.putInt(1);
            bbuf.put(msgBytes);
            this.parent.logTxn(1, bbuf.array());
        }
    }

    Packet getMessage(DestinationUID dst, SysMessageID mid) throws BrokerException {
        try {
            return this.getDstMsgStore(dst).getMessage(mid);
        }
        catch (IOException e) {
            this.logger.log(32, "B4107", (Object)mid.toString(), (Throwable)e);
            throw new BrokerException(this.br.getString("B4107", mid.toString()), e);
        }
    }

    boolean containsMessage(DestinationUID dst, SysMessageID mid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true, true, true);
        return dstMsgStore.containsMsg(mid);
    }

    void removeMessage(DestinationUID dst, SysMessageID id, boolean sync) throws IOException, BrokerException {
        this.getDstMsgStore(dst).removeMessage(id, sync);
    }

    void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] ints, int[] states, boolean sync) throws IOException, BrokerException {
        SysMessageID mid = message.getSysMessageID();
        DstMsgStore fromdst = this.getDstMsgStore(from, true, true, false);
        if (fromdst == null || !fromdst.containsMsg(mid)) {
            this.logger.log(32, "B3007", (Object)mid, from);
            throw new BrokerException(this.br.getString("B3007", mid, from));
        }
        this.storeMessage(to, message, ints, states, sync);
        try {
            fromdst.removeMessage(message.getSysMessageID(), sync);
        }
        catch (BrokerException e) {
            this.getDstMsgStore(to).removeMessage(message.getSysMessageID(), sync);
            Object[] args = new Object[]{mid, from, to};
            this.logger.log(32, "B4187", args, (Throwable)e);
            throw e;
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).hasMessageBeenAck();
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        DstMsgStore msgfile = this.getDstMsgStore(destination.getDestinationUID(), true, false, false);
        if (msgfile != null) {
            return msgfile.getStorageInfo();
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compactDestination(Destination destination) throws BrokerException {
        if (destination != null) {
            DstMsgStore msgfile = this.getDstMsgStore(destination.getDestinationUID(), true, false, false);
            if (msgfile != null) {
                msgfile.compact();
            }
        } else {
            Iterator itr = null;
            HashMap hashMap = this.dstMap;
            synchronized (hashMap) {
                itr = ((HashMap)this.dstMap.clone()).values().iterator();
            }
            while (itr.hasNext()) {
                DstMsgStore file = (DstMsgStore)itr.next();
                file.compact();
            }
        }
    }

    void removeAllMessages(DestinationUID dst, boolean sync) throws IOException, BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true, false, false);
        if (dstMsgStore != null) {
            dstMsgStore.removeAllMessages(sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMessageDir(DestinationUID dst, boolean sync) throws IOException, BrokerException {
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.remove(dst);
            if (dstMsgStore != null) {
                dstMsgStore.releaseMessageDir(sync);
            }
        }
    }

    Enumeration messageEnumeration() {
        Enumeration msgEnum = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgStore.this.parent.getDstStore().getDestinations().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            @Override
            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        Destination dst = (Destination)this.dstitr.next();
                        try {
                            this.tempenum = MsgStore.this.messageEnumeration(dst.getDestinationUID());
                            break;
                        }
                        catch (BrokerException e) {
                            Logger logger = MsgStore.this.logger;
                            MsgStore.this.logger;
                            MsgStore.this.br;
                            logger.log(32, "B4145", (Object)dst.getDestinationUID(), (Throwable)e);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object tmp = this.nextToReturn;
                    this.nextToReturn = null;
                    return tmp;
                }
                throw new NoSuchElementException();
            }
        };
        return msgEnum;
    }

    Enumeration messageEnumeration(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.messageEnumeration();
        }
        return emptyEnum;
    }

    int getMessageCount(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.getMessageCount();
        }
        return 0;
    }

    long getByteCount(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.getByteCount();
        }
        return 0L;
    }

    void storeInterestStates(DestinationUID dst, SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        try {
            if (Globals.isNewTxnLogEnabled()) {
                DstMsgStore msgstore = this.getDstMsgStore(dst, true, true, true);
            }
            this.getDstMsgStore(dst).storeInterestStates(mid, iids, states, sync);
        }
        catch (IOException e) {
            this.logger.log(32, "B4105", mid.toString());
            throw new BrokerException(this.br.getString("B4105", mid.toString()), e);
        }
    }

    void updateInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID iid, int state, boolean sync) throws BrokerException {
        try {
            this.getDstMsgStore(dst).updateInterestState(mid, iid, state, sync);
        }
        catch (IOException e) {
            this.logger.log(32, "B4015", (Object)iid.toString(), mid.toString());
            throw new BrokerException(this.br.getString("B4015", iid.toString(), mid.toString()), e);
        }
    }

    int getInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID iid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getInterestState(iid);
    }

    HashMap getInterestStates(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getInterestStates();
    }

    ConsumerUID[] getConsumerUIDs(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getConsumerUIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean sync) throws BrokerException {
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            if (this.dstMap != null) {
                this.closeAllDstMsgStore(false);
                this.dstMap.clear();
            }
            try {
                FileUtil.removeFiles(this.msgDir, false);
            }
            catch (IOException e) {
                this.logger.log(32, "B4149", (Object)this.msgDir, (Throwable)e);
                throw new BrokerException(this.br.getString("B4149", this.msgDir), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            dstMsgStore = (DstMsgStore)this.dstMap.get(dst);
        }
        if (dstMsgStore != null) {
            dstMsgStore.sync();
        }
    }

    void close(boolean cleanup) {
        boolean msgCleanup = this.config.getBooleanProperty(CLEANUP_MSGSTORE_PROP, true);
        this.closeAllDstMsgStore(msgCleanup);
        this.dstMap.clear();
    }

    File getDirName(DestinationUID dst) {
        StringBuffer dstname = new StringBuffer(dst.toString());
        int indx = -1;
        while ((indx = dstname.indexOf(":")) != -1) {
            dstname.deleteCharAt(indx);
        }
        return new File(this.msgDir, dstname.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DstMsgStore getDstMsgStore(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            dstMsgStore = (DstMsgStore)this.dstMap.get(dst);
        }
        if (dstMsgStore == null) {
            String emsg = this.br.getKString("B3013", dst);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return dstMsgStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DstMsgStore getDstMsgStore(DestinationUID dst, boolean instantiate, boolean load, boolean create) throws BrokerException {
        this.parent.getDstStore().checkDestination(dst.toString());
        DstMsgStore dstMsgStore = null;
        try {
            HashMap hashMap = this.dstMap;
            synchronized (hashMap) {
                File dir;
                dstMsgStore = (DstMsgStore)this.dstMap.get(dst);
                if (dstMsgStore == null && instantiate && ((dir = this.getDirName(dst)).exists() || create)) {
                    dstMsgStore = new DstMsgStore(this, dst, dir, load);
                    this.dstMap.put(dst, dstMsgStore);
                }
            }
        }
        catch (BrokerException ex) {
            if ((instantiate || create) && ex.getStatusCode() == 405) {
                this.logger.log(32, ex.toString());
                Broker.getBroker().exit(14, ex.toString(), BrokerEvent.Type.FATAL_ERROR, ex, true, true, false);
            }
            throw ex;
        }
        return dstMsgStore;
    }

    private void closeAllDstMsgStore(boolean msgCleanup) {
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            if (dstMsgStore == null) continue;
            dstMsgStore.close(msgCleanup);
        }
    }
}

