/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.MessageInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

class DstMsgStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    DestinationUID myDestination = null;
    private ConcurrentHashMap messageMap = new ConcurrentHashMap(4096);
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();

    DstMsgStore(DestinationUID dst) {
        this.myDestination = dst;
    }

    MessageInfo storeMessage(Packet message, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        SysMessageID id = message.getSysMessageID();
        MessageInfo info = new MessageInfo(this, message, iids, states);
        MessageInfo oldmsg = this.messageMap.putIfAbsent(info.getID(), info);
        if (oldmsg != null) {
            this.logger.log(32, "B3008", (Object)id, this.myDestination);
            throw new BrokerException(this.br.getString("B3008", id, this.myDestination));
        }
        int msgsize = message.getPacketSize();
        this.incrMsgCount(msgsize);
        return info;
    }

    void removeMessage(SysMessageID id) throws IOException, BrokerException {
        MessageInfo oldmsg = (MessageInfo)this.messageMap.remove(id);
        if (oldmsg == null) {
            this.logger.log(32, "B3007", (Object)id, this.myDestination);
            throw new BrokerException(this.br.getString("B3007", id, this.myDestination));
        }
        this.decrMsgCount(oldmsg.getSize());
    }

    void removeAllMessages(boolean sync) throws IOException, BrokerException {
        this.messageMap.clear();
        this.clearCounts();
    }

    Enumeration messageEnumeration() {
        return new MsgEnumeration(this, this.getMessageIterator());
    }

    int getMessageCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getMessageCount()");
        }
        return this.msgCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getByteCount()");
        }
        return this.byteCount;
    }

    protected void close() {
        this.messageMap.clear();
    }

    MessageInfo getMessageInfo(SysMessageID mid) throws BrokerException {
        MessageInfo info = (MessageInfo)this.messageMap.get(mid);
        if (info == null) {
            this.logger.log(32, "B3007", (Object)mid, this.myDestination);
            throw new BrokerException(this.br.getString("B3007", mid, this.myDestination));
        }
        return info;
    }

    private Iterator getMessageIterator() {
        return this.messageMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int msgSize) {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int msgSize) {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + this.myDestination);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put(this.myDestination + ":messages in-memory", String.valueOf(this.msgCount));
        return t;
    }

    void storeInterestStates(SysMessageID mid, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        this.getMessageInfo(mid).storeStates(iids, states);
    }

    void updateInterestState(SysMessageID mid, ConsumerUID iid, int state) throws IOException, BrokerException {
        this.getMessageInfo(mid).updateState(iid, state);
    }

    boolean containsMsg(SysMessageID mid) {
        return this.messageMap.containsKey(mid);
    }

    Packet getMessage(SysMessageID mid) throws IOException, BrokerException {
        MessageInfo msginfo = (MessageInfo)this.messageMap.get(mid);
        if (msginfo == null) {
            this.logger.log(32, "B3007", (Object)mid, this.myDestination);
            throw new BrokerException(this.br.getString("B3007", mid, this.myDestination));
        }
        return msginfo.getMessage();
    }

    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore p, Iterator i) {
            this.parent = p;
            this.itr = i;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.itr.hasNext()) {
                this.objToReturn = this.itr.next();
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object result = null;
                if (this.objToReturn instanceof SysMessageID) {
                    try {
                        result = this.parent.getMessage((SysMessageID)this.objToReturn);
                    }
                    catch (IOException e) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, this.parent.myDestination, e);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException e) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, this.parent.myDestination, e);
                        throw new NoSuchElementException();
                    }
                } else {
                    result = this.objToReturn;
                }
                this.objToReturn = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

