/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class TxnStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap tidMap = null;
    private ConcurrentHashMap ackMap = null;
    private HashMap emptyHashMap = new HashMap();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];

    TxnStore() {
        this.tidMap = new ConcurrentHashMap(1024);
        this.ackMap = new ConcurrentHashMap(1024);
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore: closing, " + this.tidMap.size() + " in-memory transactions");
        }
        this.tidMap.clear();
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore: closing, " + this.ackMap.size() + " in-memory transactions with acks");
        }
        this.ackMap.clear();
    }

    void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        try {
            TransactionInfo oldValue = this.tidMap.putIfAbsent(id, new TransactionInfo(new TransactionState(ts)));
            if (oldValue != null) {
                this.logger.log(32, "B3015", id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    public void storeClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        TransactionInfo txnInfo = null;
        try {
            txnInfo = new TransactionInfo(new TransactionState(ts), null, brokers, 2);
            TransactionInfo oldValue = this.tidMap.putIfAbsent(id, txnInfo);
            if (oldValue != null) {
                this.logger.log(32, "B3015", id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
        }
        catch (RuntimeException e) {
            String msg = txnInfo != null ? id + " " + txnInfo.toString() : id.toString();
            this.logger.log(32, "B4019", (Object)msg, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", msg), e);
        }
    }

    public void storeRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] acks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        TransactionInfo txnInfo = null;
        boolean removedAcksFlag = false;
        try {
            if (this.tidMap.containsKey(id)) {
                this.logger.log(32, "B3015", id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
            if (acks != null && acks.length > 0) {
                this.storeTransactionAcks(id, acks);
                removedAcksFlag = true;
            }
            txnInfo = new TransactionInfo(new TransactionState(ts), txnHomeBroker, null, 3);
            this.tidMap.put(id, txnInfo);
        }
        catch (RuntimeException e) {
            String msg = txnInfo != null ? id + " " + txnInfo.toString() : id.toString();
            this.logger.log(32, "B4019", (Object)msg, (Throwable)e);
            try {
                if (removedAcksFlag) {
                    this.removeTransactionAck(id);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new BrokerException(this.br.getString("B4019", msg), e);
        }
    }

    void storeTransaction(TransactionUID id, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        try {
            this.tidMap.put(id, txnInfo);
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    void removeTransaction(TransactionUID id, boolean sync) throws BrokerException {
        try {
            Object txnInfo = this.tidMap.remove(id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4138", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4138", id), e);
        }
    }

    void updateTransactionState(TransactionUID id, int ts, boolean sync) throws IOException, BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txnInfo.getTransactionState();
            if (txnState.getState() != ts) {
                txnState.setState(ts);
                this.tidMap.put(id, txnInfo);
            }
        }
        catch (Exception e) {
            this.logger.log(32, "B4137", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4137", id), e);
        }
    }

    public void updateClusterTransaction(TransactionUID id, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            txnInfo.setType(2);
            txnInfo.setTransactionBrokers(brokers);
            this.tidMap.put(id, txnInfo);
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    void updateTransactionBrokerState(TransactionUID id, int expectedTxnState, TransactionBroker txnBkr, boolean sync) throws BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txnInfo.getTransactionState();
            if (txnState.getState() != expectedTxnState) {
                Object[] args = new Object[]{txnBkr, id, TransactionState.toString(expectedTxnState), TransactionState.toString(txnState.getState())};
                throw new BrokerException(this.br.getKString("B3219", args), 409);
            }
            txnInfo.updateBrokerState(txnBkr);
            this.tidMap.put(id, txnInfo);
        }
        catch (Exception e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    TransactionState getTransactionState(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return new TransactionState(txnInfo.getTransactionState());
    }

    int getTransactionStateValue(TransactionUID id) throws BrokerException {
        TransactionState txnState;
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
        if (txnInfo != null && (txnState = txnInfo.getTransactionState()) != null) {
            return txnState.getState();
        }
        return -1;
    }

    TransactionInfo getTransactionInfo(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return (TransactionInfo)txnInfo.clone();
    }

    BrokerAddress getRemoteTransactionHomeBroker(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return txnInfo.getTransactionHomeBroker();
    }

    TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        TransactionBroker[] txnBrokers = txnInfo.getTransactionBrokers();
        if (txnBrokers != null) {
            txnBrokers = (TransactionBroker[])txnBrokers.clone();
        }
        return txnBrokers;
    }

    HashMap getAllTransactionStates() throws IOException {
        HashMap map = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo txnInfo = (TransactionInfo)entry.getValue();
            int type = txnInfo.getType();
            if (type != 1 && type != 2) continue;
            map.put(entry.getKey(), new TransactionInfo(txnInfo));
        }
        return map;
    }

    HashMap getAllRemoteTransactionStates() throws IOException {
        HashMap map = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo txnInfo = (TransactionInfo)entry.getValue();
            int type = txnInfo.getType();
            if (type != 3) continue;
            map.put(entry.getKey(), txnInfo.getTransactionState());
        }
        return map;
    }

    Collection getAllTransactions() {
        return this.tidMap.keySet();
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnStore.clearAll() called");
        }
        this.tidMap.clear();
        this.ackMap.clear();
    }

    void clear(int state, boolean sync) throws BrokerException {
        boolean error = false;
        RuntimeException exception = null;
        Iterator itr = this.tidMap.entrySet().iterator();
        while (itr.hasNext()) {
            try {
                Map.Entry entry = itr.next();
                TransactionUID tid = (TransactionUID)entry.getKey();
                TransactionState ts = (TransactionState)entry.getValue();
                if (ts.getState() == state) continue;
                itr.remove();
                this.removeTransactionAck(tid);
            }
            catch (RuntimeException e) {
                error = true;
                exception = e;
                this.logger.log(32, "B4139", (Object)new Integer(state), (Throwable)e);
            }
        }
        if (!error) {
            for (TransactionUID tid : this.ackMap.keySet()) {
                TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get(tid);
                if (txnInfo != null && txnInfo.getTransactionStateValue() == state) continue;
                this.removeTransactionAck(tid);
            }
        }
        if (error) {
            this.clearAll();
            throw new BrokerException(this.br.getString("B4139", new Integer(state)), exception);
        }
    }

    void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (!this.tidMap.containsKey(tid)) {
            this.logger.log(32, "B3016", tid.toString());
            throw new BrokerException(this.br.getString("B3016", tid.toString()));
        }
        try {
            boolean putIfAbsent = false;
            HashSet acks = (HashSet)this.ackMap.get(tid);
            if (acks == null) {
                putIfAbsent = true;
                acks = new HashSet();
            } else if (acks.contains(ack)) {
                this.logger.log(32, "B3062", (Object)ack, tid);
                throw new BrokerException(this.br.getString("B3062", ack, tid));
            }
            acks.add(ack);
            HashSet oldValue = this.ackMap.putIfAbsent(tid, acks);
            if (putIfAbsent && oldValue != null) {
                acks = (HashSet)this.ackMap.get(tid);
                acks.add(ack);
                this.ackMap.put(tid, acks);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4056", (Object)ack.toString(), tid.toString());
            throw new BrokerException(this.br.getString("B4056", ack.toString(), tid.toString()), e);
        }
    }

    void storeTransactionAcks(TransactionUID tid, TransactionAcknowledgement[] txnAcks) throws BrokerException {
        List<TransactionAcknowledgement> ackList = Arrays.asList(txnAcks);
        try {
            boolean putIfAbsent = false;
            HashSet acks = (HashSet)this.ackMap.get(tid);
            if (acks == null) {
                putIfAbsent = true;
                acks = new HashSet(ackList.size());
            }
            acks.addAll(ackList);
            HashSet oldValue = this.ackMap.putIfAbsent(tid, acks);
            if (putIfAbsent && oldValue != null) {
                acks = (HashSet)this.ackMap.get(tid);
                acks.addAll(ackList);
                this.ackMap.put(tid, acks);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4056", (Object)ackList.toString(), tid.toString());
            throw new BrokerException(this.br.getString("B4056", ackList.toString(), tid.toString()), e);
        }
    }

    void removeTransactionAck(TransactionUID tid) throws BrokerException {
        try {
            HashSet acks = (HashSet)this.ackMap.remove(tid);
            if (acks != null) {
                acks.clear();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4060", tid.toString());
            throw new BrokerException(this.br.getString("B4060", tid.toString()), e);
        }
    }

    TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        HashSet acks = (HashSet)this.ackMap.get(tid);
        if (acks != null) {
            return acks.toArray(this.emptyAckArray);
        }
        return this.emptyAckArray;
    }

    HashMap getAllTransactionAcks() {
        if (this.ackMap.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap allacks = new HashMap(this.ackMap.size());
        Set entries = this.ackMap.entrySet();
        for (Map.Entry entry : entries) {
            HashSet set = (HashSet)entry.getValue();
            TransactionAcknowledgement[] acks = set.toArray(this.emptyAckArray);
            allacks.put(entry.getKey(), acks);
        }
        return allacks;
    }

    public int getNumberOfTxnAcks() {
        int size = 0;
        for (Map.Entry entry : this.ackMap.entrySet()) {
            HashSet acks = (HashSet)entry.getValue();
            size += acks.size();
        }
        return size;
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Transactions", String.valueOf(this.tidMap.size()));
        t.put("Txn acks", String.valueOf(this.ackMap.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nTransaction IDs");
        out.println("---------------");
        out.println("number of transaction ids: " + this.tidMap.size());
        out.println("\nTransaction acknowledgements");
        out.println("----------------------------");
        out.println("Number of transactions containing acknowledgements: " + this.ackMap.size());
    }
}

