/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.util.UID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BrokerDAOImpl
extends BaseDAOImpl
implements BrokerDAO {
    public static final String STORE_SESSION_ID_COLUMN = "STORE_SESSION_ID";
    protected String tableName;
    protected String insertSQL;
    protected String updateVersionSQL;
    protected String updateURLSQL;
    protected String resetTakeoverBrokerSQL;
    protected String restoreOnTakeoverFailSQL;
    protected String restoreHeartbeatOnTakeoverFailSQL;
    protected String updateHeartbeatSQL;
    protected String updateHeartbeatAndCheckStateSQL;
    protected String updateStateThisBrokerSQL;
    protected String updateStateOtherBrokerSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllByStateSQL;
    protected String selectHeartbeatSQL;
    protected String selectAllHeartbeatsSQL;
    protected String selectStateSQL;
    protected String selectAllStatesSQL;
    protected String selectIsBeingTakenOverSQL;
    private FaultInjection fi = FaultInjection.getInjection();

    BrokerDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQBKR41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(") VALUES ( ?, ?, ?, ?, ?, ? )").toString();
        this.updateVersionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("VERSION").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateURLSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("URL").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.resetTakeoverBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = NULL, ").append("STATE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" IS NOT NULL").append(" AND ").append("STATE").append(" = ").append(8).toString();
        this.restoreOnTakeoverFailSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = NULL, ").append("STATE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ").append(7).append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.restoreHeartbeatOnTakeoverFailSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ").append(7).append(" AND ").append("HEARTBEAT_TS").append(" = ? ").append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.updateHeartbeatSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeatAndCheckStateSQL = new StringBuffer(this.updateHeartbeatSQL).append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("STATE").append(" NOT IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
        this.updateStateThisBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" IS NULL ").toString();
        this.updateStateOtherBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = ?, ").append("STATE").append(" = ?, ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" is NULL").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT bTbl.").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(", sTbl.").append("ID").append(" AS ").append(STORE_SESSION_ID_COLUMN).append(" FROM ").append(this.tableName).append(" bTbl LEFT JOIN ").append(dbMgr.getTableName("MQSES41")).append(" sTbl ON bTbl.").append("ID").append(" = sTbl.").append("BROKER_ID").append(" AND sTbl.").append("IS_CURRENT").append(" = 1").toString();
        this.selectAllByStateSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("STATE").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("ID").append(" = ?").toString();
        this.selectHeartbeatSQL = new StringBuffer(128).append("SELECT ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllHeartbeatsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllStatesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).toString();
        this.selectIsBeingTakenOverSQL = new StringBuffer(128).append("SELECT 1 FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ? AND ").append("STATE").append(" IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQBKR41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, String id, String takeoverID, String url, int version, int state, Long sessionID, long heartbeat, List<UID> additionalSessions) throws BrokerException {
        Exception myex = null;
        boolean myConn = false;
        PreparedStatement pstmt = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                conn = dbMgr.getConnection(false);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.insertSQL);
            pstmt.setString(1, id);
            pstmt.setString(2, url);
            pstmt.setInt(3, version);
            pstmt.setInt(4, state);
            Util.setString(pstmt, 5, takeoverID);
            Util.setLong(pstmt, 6, heartbeat);
            pstmt.executeUpdate();
            pstmt.close();
            if (sessionID != null) {
                dbMgr.getDAOFactory().getStoreSessionDAO().insert(conn, id, sessionID, true);
                if (additionalSessions != null) {
                    UID uid2 = null;
                    for (UID uid2 : additionalSessions) {
                        this.logger.log(8, "XXX Create additional store session " + uid2 + " for this broker");
                        dbMgr.getDAOFactory().getStoreSessionDAO().insert(conn, id, uid2.longValue(), 0, id, System.currentTimeMillis());
                    }
                }
            }
            if (myConn) {
                conn.commit();
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4217", id), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public UID update(Connection conn, String id, int updateType, Object oldValue, Object newValue) throws BrokerException {
        UID updateCnt2;
        block23: {
            Exception myex;
            PreparedStatement pstmt;
            block22: {
                String _updatesql = "";
                UID currentID = null;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    switch (updateType) {
                        case 0: {
                            _updatesql = this.updateVersionSQL;
                            pstmt = conn.prepareStatement(this.updateVersionSQL);
                            pstmt.setInt(1, (Integer)newValue);
                            pstmt.setString(2, id);
                            pstmt.executeUpdate();
                            pstmt.close();
                            break;
                        }
                        case 1: {
                            _updatesql = this.updateURLSQL;
                            pstmt = conn.prepareStatement(this.updateURLSQL);
                            pstmt.setString(1, (String)newValue);
                            pstmt.setString(2, id);
                            pstmt.executeUpdate();
                            pstmt.close();
                            break;
                        }
                        case 2: {
                            _updatesql = this.resetTakeoverBrokerSQL;
                            pstmt = conn.prepareStatement(this.resetTakeoverBrokerSQL);
                            pstmt.setInt(1, BrokerState.OPERATING.intValue());
                            pstmt.setString(2, id);
                            int updateCnt2 = pstmt.executeUpdate();
                            pstmt.close();
                            if (updateCnt2 == 1) {
                                this.logger.log(8, this.br.getKString("B1332", "TAKEOVER_BROKER", id));
                                long ssid = dbMgr.getDAOFactory().getStoreSessionDAO().insert(conn, id, ((UID)newValue).longValue(), false);
                                this.logger.log(8, this.br.getKString("B1333", id, String.valueOf(ssid)));
                                currentID = new UID(ssid);
                                break;
                            }
                            if (updateCnt2 == 0) {
                                _updatesql = this.updateStateThisBrokerSQL;
                                if (this.updateState(conn, id, BrokerState.OPERATING, (BrokerState)oldValue, true)) break;
                                HABrokerInfo info = this.getBrokerInfo(conn, id);
                                throw new BrokerException("IllegalStateException for updating state " + oldValue + " to " + BrokerState.OPERATING.toString() + ": " + info);
                            }
                            throw new BrokerException("Unexpected affected row count " + updateCnt2 + " for updating broker info " + id);
                        }
                        case 4: {
                            if (this.fi.FAULT_INJECTION) {
                                this.fi.checkFaultAndThrowBrokerException("ha.takeover.restore.exception", null);
                                this.fi.checkFaultAndExit("ha.takeover.restore.halt", null, 2, false);
                            }
                            _updatesql = this.restoreOnTakeoverFailSQL;
                            pstmt = conn.prepareStatement(this.restoreOnTakeoverFailSQL);
                            pstmt.setInt(1, ((HABrokerInfo)newValue).getState());
                            pstmt.setString(2, id);
                            pstmt.setString(3, (String)oldValue);
                            int updateCnt2 = pstmt.executeUpdate();
                            pstmt.close();
                            if (updateCnt2 == 1) break;
                            throw new BrokerException("Unexpected affected row count " + updateCnt2 + " for restoring broker info " + id);
                        }
                        case 3: {
                            _updatesql = this.restoreHeartbeatOnTakeoverFailSQL;
                            pstmt = conn.prepareStatement(this.restoreHeartbeatOnTakeoverFailSQL);
                            pstmt.setLong(1, ((HABrokerInfo)newValue).getHeartbeat());
                            pstmt.setString(2, id);
                            pstmt.setLong(3, ((HABrokerInfo)newValue).getTakeoverTimestamp());
                            pstmt.setString(4, (String)oldValue);
                            pstmt.executeUpdate();
                            pstmt.close();
                            break;
                        }
                        default: {
                            throw new BrokerException("B3044 Unknown update type " + updateType + " for updating broker info " + id);
                        }
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    updateCnt2 = currentID;
                    if (!myConn) break block22;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + _updatesql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4217", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block23;
            }
            Util.close(null, pstmt, null, myex);
        }
        return updateCnt2;
    }

    @Override
    public Long updateHeartbeat(Connection conn, String id) throws BrokerException {
        Long newheartbeat = null;
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                try {
                    conn = DBManager.getDBManager().getConnectionNoRetry(true);
                    myConn = true;
                }
                catch (BrokerException e) {
                    e.setSQLReconnect(true);
                    e.setSQLRecoverable(true);
                    throw e;
                }
            }
            long heartbeat = System.currentTimeMillis();
            pstmt = conn.prepareStatement(this.updateHeartbeatSQL);
            pstmt.setLong(1, heartbeat);
            pstmt.setString(2, id);
            if (pstmt.executeUpdate() == 1) {
                newheartbeat = new Long(heartbeat);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatSQL + "]", (SQLException)e) : e;
            BrokerException be = new BrokerException(this.br.getKString("B4222", id), ex);
            be.setSQLRecoverable(true);
            throw be;
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
        return newheartbeat;
    }

    @Override
    public Long updateHeartbeat(Connection conn, String id, long lastHeartbeat) throws BrokerException {
        Long newheartbeat = null;
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                try {
                    conn = DBManager.getDBManager().getConnectionNoRetry(true);
                    myConn = true;
                }
                catch (BrokerException e) {
                    e.setSQLReconnect(true);
                    e.setSQLRecoverable(true);
                    throw e;
                }
            }
            long heartbeat = System.currentTimeMillis();
            pstmt = conn.prepareStatement(this.updateHeartbeatAndCheckStateSQL);
            pstmt.setLong(1, heartbeat);
            pstmt.setString(2, id);
            pstmt.setLong(3, lastHeartbeat);
            if (pstmt.executeUpdate() == 0) {
                HABrokerInfo bkrInfo = this.getBrokerInfo(conn, id);
                if (bkrInfo == null) {
                    String errorMsg = this.br.getKString("B3169", id);
                    throw new BrokerException(this.br.getKString("B4223", id, errorMsg));
                }
                String takeoverBroker = bkrInfo.getTakeoverBrokerID();
                int state = bkrInfo.getState();
                if (takeoverBroker != null && takeoverBroker.length() > 0 && (state == 9 || state == 7 || state == 8 || state == 10)) {
                    StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                    this.logger.log(32, this.br.getKString("B4223", id, bkrInfo.toString()), be);
                    throw be;
                }
            } else {
                newheartbeat = new Long(heartbeat);
            }
        }
        catch (Exception e) {
            myex = e;
            boolean recoverable = false;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                    recoverable = true;
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatAndCheckStateSQL + "]", (SQLException)e) : e;
            String arg = "Expected last heartbeat " + lastHeartbeat;
            BrokerException be = new BrokerException(this.br.getKString("B4223", id, arg), ex);
            be.setSQLRecoverable(recoverable);
            throw be;
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
        return newheartbeat;
    }

    @Override
    public boolean updateState(Connection conn, String id, BrokerState newState, BrokerState expectedState, boolean local) throws BrokerException {
        boolean updated;
        block18: {
            Exception myex;
            PreparedStatement pstmt;
            block17: {
                String _updatesql = "";
                updated = false;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    if (conn == null) {
                        try {
                            conn = DBManager.getDBManager().getConnectionNoRetry(true);
                            myConn = true;
                        }
                        catch (BrokerException e) {
                            e.setSQLReconnect(true);
                            e.setSQLRecoverable(true);
                            throw e;
                        }
                    }
                    if (local) {
                        _updatesql = this.updateStateThisBrokerSQL;
                        pstmt = conn.prepareStatement(this.updateStateThisBrokerSQL);
                        pstmt.setInt(1, newState.intValue());
                        pstmt.setString(2, id);
                        pstmt.setInt(3, expectedState.intValue());
                        if (pstmt.executeUpdate() == 1) {
                            updated = true;
                        }
                    } else {
                        _updatesql = this.updateStateOtherBrokerSQL;
                        pstmt = conn.prepareStatement(this.updateStateOtherBrokerSQL);
                        pstmt.setInt(1, newState.intValue());
                        pstmt.setString(2, id);
                        pstmt.setInt(3, expectedState.intValue());
                        pstmt.setString(4, DBManager.getDBManager().getBrokerID());
                        if (pstmt.executeUpdate() == 1) {
                            updated = true;
                        }
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        boolean recoverable = false;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                                recoverable = true;
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + _updatesql + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4217", id), ex);
                        be.setSQLRecoverable(recoverable);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block18;
            }
            Util.close(null, pstmt, null, myex);
        }
        return updated;
    }

    @Override
    public HABrokerInfo takeover(Connection conn, String id, String targetBrokerID, long lastHeartbeat, BrokerState expectedState, long newHeartbeat, BrokerState newState) throws BrokerException {
        HABrokerInfo bkrInfo = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            bkrInfo = this.getBrokerInfo(conn, targetBrokerID);
            if (bkrInfo == null) {
                String errorMsg = this.br.getKString("B3169", targetBrokerID);
                throw new BrokerException(this.br.getKString("B3100", errorMsg));
            }
            pstmt = conn.prepareStatement(this.takeoverSQL);
            pstmt.setString(1, id);
            pstmt.setInt(2, newState.intValue());
            pstmt.setLong(3, newHeartbeat);
            pstmt.setString(4, targetBrokerID);
            pstmt.setInt(5, expectedState.intValue());
            pstmt.setLong(6, lastHeartbeat);
            if (pstmt.executeUpdate() != 1) {
                HABrokerInfo binfo = this.getBrokerInfo(conn, targetBrokerID);
                String errorMsg = this.br.getKString("B3170", targetBrokerID);
                TakeoverLockException ex = new TakeoverLockException(errorMsg);
                ex.setBrokerInfo(binfo);
                throw ex;
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080", rbe);
                }
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)e) : e;
                throw new BrokerException(this.br.getKString("B3172", targetBrokerID), ex);
            }
            catch (Throwable throwable) {
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(null, pstmt, null, myex);
        return bkrInfo;
    }

    @Override
    public void delete(Connection conn, String id) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.deleteSQL);
            pstmt.setString(1, id);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4220", id), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(conn);
    }

    @Override
    public long getHeartbeat(Connection conn, String id) throws BrokerException {
        long heartBeat;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                heartBeat = -1L;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectHeartbeatSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        heartBeat = rs.getLong(1);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectHeartbeatSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4218", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return heartBeat;
    }

    @Override
    public HashMap getAllHeartbeats(Connection conn) throws BrokerException {
        HashMap<String, Long> data;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                data = new HashMap<String, Long>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectAllHeartbeatsSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String id = rs.getString(1);
                        long timestamp = rs.getLong(2);
                        data.put(id, new Long(timestamp));
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllHeartbeatsSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4221"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public BrokerState getState(Connection conn, String id) throws BrokerException {
        BrokerState state;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                state = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        try {
                            conn = DBManager.getDBManager().getConnectionNoRetry(true);
                            myConn = true;
                        }
                        catch (BrokerException e) {
                            e.setSQLReconnect(true);
                            e.setSQLRecoverable(true);
                            throw e;
                        }
                    }
                    pstmt = conn.prepareStatement(this.selectStateSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3169", id), 404);
                    }
                    state = BrokerState.getState(rs.getInt(1));
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4218", id), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return state;
    }

    @Override
    public Object[] getAllStates(Connection conn) throws BrokerException {
        Object[] data;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                ArrayList<String> ids = new ArrayList<String>();
                ArrayList<BrokerState> states = new ArrayList<BrokerState>();
                data = new Object[]{ids, states};
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectAllStatesSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String id = rs.getString(1);
                        int state = rs.getInt(2);
                        ids.add(id);
                        states.add(BrokerState.getState(state));
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectAllStatesSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllStatesSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4221"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public HABrokerInfo getBrokerInfo(Connection conn, String id) throws BrokerException {
        HABrokerInfo bkrInfo;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                bkrInfo = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        bkrInfo = this.loadData(rs);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4218", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return bkrInfo;
    }

    @Override
    public HashMap getAllBrokerInfos(Connection conn, boolean loadSession) throws BrokerException {
        HashMap<String, HABrokerInfo> data;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                data = new HashMap<String, HABrokerInfo>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectAllSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        HABrokerInfo bkrInfo = this.loadData(rs);
                        data.put(bkrInfo.getId(), bkrInfo);
                    }
                    if (loadSession) {
                        rs.close();
                        pstmt.close();
                        Map sessionMap = dbMgr.getDAOFactory().getStoreSessionDAO().getAllStoreSessions(conn);
                        for (Map.Entry entry : sessionMap.entrySet()) {
                            String brokerID = (String)entry.getKey();
                            HABrokerInfo bkrInfo = (HABrokerInfo)data.get(brokerID);
                            if (bkrInfo == null) continue;
                            bkrInfo.setSessionList((List)entry.getValue());
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4221"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public HashMap getAllBrokerInfosByState(Connection conn, BrokerState state) throws BrokerException {
        HashMap<String, HABrokerInfo> data;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                data = new HashMap<String, HABrokerInfo>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectAllByStateSQL);
                    pstmt.setInt(1, state.intValue());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        HABrokerInfo bkrInfo = this.loadData(rs);
                        data.put(bkrInfo.getId(), bkrInfo);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectAllByStateSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllByStateSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4221"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer strBuf = new StringBuffer(512);
        try {
            Collection data = this.getAllBrokerInfos(conn, false).values();
            for (Object obj : data) {
                strBuf.append(obj.toString()).append(BrokerResources.NL);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        map.put("Broker(" + this.tableName + ")", strBuf.toString());
        return map;
    }

    @Override
    public boolean isBeingTakenOver(Connection conn, String id) throws BrokerException {
        BrokerState brokerState = this.getState(conn, id);
        int state = brokerState.intValue();
        return state == 9 || state == 7 || state == 8 || state == 10;
    }

    protected HABrokerInfo loadData(ResultSet rs) throws SQLException {
        HABrokerInfo brokerInfo = new HABrokerInfo(rs.getString("ID"), rs.getString("TAKEOVER_BROKER"), rs.getString("URL"), rs.getInt("VERSION"), rs.getInt("STATE"), rs.getLong(STORE_SESSION_ID_COLUMN), rs.getLong("HEARTBEAT_TS"));
        return brokerInfo;
    }
}

