/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

class HADBMessageDAOImpl
extends MessageDAOImpl {
    HADBMessageDAOImpl() throws BrokerException {
    }

    @Override
    protected void deleteAll(Connection conn, String whereClause, String timestampColumn, int chunkSize) throws BrokerException {
        super.deleteAll(conn, whereClause, "CREATED_TS", 5000);
    }

    @Override
    public List getMessagesByBroker(Connection conn, String brokerID) throws BrokerException {
        List list;
        block17: {
            Exception myex;
            PreparedStatement pstmt;
            block16: {
                list = Collections.EMPTY_LIST;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    List<Long> sessions;
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    if (!(sessions = dbMgr.getDAOFactory().getStoreSessionDAO().getStoreSessionsByBroker(conn, brokerID)).isEmpty()) {
                        pstmt = conn.prepareStatement(this.selectMsgsBySessionSQL);
                        for (long sessionID : sessions) {
                            pstmt.setLong(1, sessionID);
                            ResultSet rs = pstmt.executeQuery();
                            if (list.isEmpty()) {
                                list = (List)this.loadData(rs, false);
                            } else {
                                list.addAll((List)this.loadData(rs, false));
                            }
                            rs.close();
                        }
                    }
                    if (!myConn) break block16;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.selectMsgsBySessionSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectMsgsBySessionSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B3176", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block17;
            }
            Util.close(null, pstmt, null, myex);
        }
        return list;
    }

    @Override
    protected void canInsertMsg(Connection conn, String msgID, String dstID, String brokerID) throws BrokerException {
        DBManager dbMgr;
        BrokerDAO dao;
        if (Globals.getHAEnabled() && (dao = (dbMgr = DBManager.getDBManager()).getDAOFactory().getBrokerDAO()).isBeingTakenOver(conn, brokerID)) {
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[canInsertMsg():" + msgID + "," + dstID, rbe);
            }
            StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
            throw be;
        }
    }
}

