/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class VersionDAOImpl
extends BaseDAOImpl
implements VersionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateLockSQL;
    protected String updateLockByLockIDSQL;
    protected String selectStoreVersionSQL;
    protected String selectLockSQL;
    protected String selectAllSQL;

    VersionDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQVER41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("STORE_VERSION").append(") VALUES ( ? )").toString();
        this.updateLockSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" IS NULL").toString();
        this.updateLockByLockIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" = ?").toString();
        this.selectStoreVersionSQL = new StringBuffer(128).append("SELECT ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
        this.selectLockSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_VERSION").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(", ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQVER41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, int storeVersion) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.insertSQL);
            pstmt.setInt(1, storeVersion);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4238", this.tableName), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public boolean updateLock(Connection conn, int storeVersion, String newLockID, String oldLockID) throws BrokerException {
        boolean updated;
        block15: {
            Exception myex;
            PreparedStatement pstmt;
            block14: {
                updated = false;
                boolean myConn = false;
                String sql = null;
                pstmt = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    if (oldLockID == null) {
                        sql = this.updateLockSQL;
                        pstmt = conn.prepareStatement(sql);
                        Util.setString(pstmt, 1, newLockID);
                        pstmt.setInt(2, storeVersion);
                    } else {
                        sql = this.updateLockByLockIDSQL;
                        pstmt = conn.prepareStatement(sql);
                        Util.setString(pstmt, 1, newLockID);
                        pstmt.setInt(2, storeVersion);
                        pstmt.setString(3, oldLockID);
                    }
                    if (pstmt.executeUpdate() > 0) {
                        updated = true;
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B3184"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block15;
            }
            Util.close(null, pstmt, null, myex);
        }
        return updated;
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(conn);
    }

    @Override
    public int getStoreVersion(Connection conn) throws BrokerException {
        int version;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                version = -1;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    if ((rs = (pstmt = conn.prepareStatement(this.selectStoreVersionSQL)).executeQuery()).next()) {
                        version = rs.getInt("STORE_VERSION");
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStoreVersionSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return version;
    }

    @Override
    public String getLock(Connection conn, int storeVersion) throws BrokerException {
        String lockID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                lockID = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectLockSQL);
                    pstmt.setInt(1, storeVersion);
                    rs = pstmt.executeQuery();
                    if (rs.next() && (lockID = rs.getString(1)) == null) {
                        lockID = "";
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectLockSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), ex, 404);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return lockID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer strBuf = new StringBuffer(256);
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.selectAllSQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                strBuf.append("(").append("STORE_VERSION").append("=").append(rs.getString("STORE_VERSION")).append(", ").append("LOCK_ID").append("=").append(rs.getString("LOCK_ID")).append(")").append(BrokerResources.NL);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)e);
        }
        finally {
            try {
                if (myConn) {
                    Util.close(rs, pstmt, conn, myex);
                } else {
                    Util.close(rs, pstmt, null, myex);
                }
            }
            catch (BrokerException be) {
                this.logger.log(32, be.getMessage(), be.getCause());
            }
        }
        map.put("Version(" + this.tableName + ")", strBuf.toString());
        return map;
    }
}

