/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnableFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.QueueBrowserInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.SessionListener;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceBootStrapContext;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;

public class IMQDirectService
extends IMQService
implements JMSService {
    protected static boolean DEBUG = false;
    private boolean acEnabled = false;
    Map localConnectionList = Collections.synchronizedMap(new HashMap());
    Map queueBrowseList = Collections.synchronizedMap(new HashMap());
    Protocol protocol;
    protected ThreadPool pool = null;
    private ConnectionManager connectionList = Globals.getConnectionManager();
    private AuthCacheData authCacheData = new AuthCacheData();
    protected Thread listenThread = null;
    HashMap serviceprops = null;

    public IMQDirectService(String name, int type, int min, int max, boolean acc) {
        super(name, type);
        this.protocol = Globals.getProtocol();
        this.acEnabled = acc;
        OperationRunnableFactory runfac = new OperationRunnableFactory(true);
        this.pool = new ThreadPool(name, min, max, runfac);
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (this.isServiceRunning() || this.listenThread != null) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] args = new String[]{this.getName(), "", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", args);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException e) {
            this.logger.log(16, "B2135", (Object)this.getName(), e.getMessage());
        }
        if (startPaused) {
            this.setServiceRunning(false);
            this.setState(4);
            try {
                Globals.getPortMapper().updateServicePort(this.name, 0);
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B3100", "starting paused service " + this, (Throwable)ex);
            }
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        Object cons;
        IMQDirectService iMQDirectService = this;
        synchronized (iMQDirectService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), ""};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
            this.notify();
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        iMQDirectService = this;
        synchronized (iMQDirectService) {
            this.setState(6);
            this.notify();
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0}", this.getName());
        }
    }

    @Override
    public void pauseService(boolean all) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] strings = new String[]{this.getName(), ""};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), ""};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setServiceRunning(true);
        IMQDirectService iMQDirectService = this;
        synchronized (iMQDirectService) {
            this.setState(3);
            this.notify();
        }
    }

    @Override
    public void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        Globals.getPortMapper().updateServicePort(this.name, 0);
        Globals.getPortMapper().removeService(this.name);
        Globals.getPortMapper().addService(this.name, "none", Globals.getConfig().getProperty("imq." + this.name + ".servicetype"), 0, this.getServiceProperties());
    }

    @Override
    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    private IMQConnection createDirectConnection(String username, String password) throws BrokerException {
        IMQDirectConnection con = null;
        con = new IMQDirectConnection(this);
        this.connectionList.addConnection(con);
        this.localConnectionList.put(con.getConnectionUID(), con);
        try {
            con.authenticate(username, password);
            con.setClientProtocolVersion(con.getHighestSupportedProtocol());
        }
        catch (Exception e) {
            e.printStackTrace();
            String errStr = "Authentication failed for username " + username + " in service " + this.getName() + ": " + e;
            this.logger.log(16, errStr);
            this.logger.log(16, "B2130", e);
            this.connectionList.removeConnection(con.getConnectionUID(), true, 4, errStr);
            this.localConnectionList.remove(con.getConnectionUID());
            throw new BrokerException(errStr, "B4051", e, 403);
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.registerConnection(con.getConnectionUID().longValue());
            agent.notifyConnectionOpen(con.getConnectionUID().longValue());
        }
        return con;
    }

    @Override
    public void removeConnection(ConnectionUID uid, int reason, String str) {
        this.connectionList.removeConnection(uid, true, reason, str);
        this.localConnectionList.remove(uid);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public String getJMSServiceID() {
        return this.getName();
    }

    @Override
    public JMSServiceReply createConnection(String username, String password, JMSServiceBootStrapContext ctx) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        IMQConnection cxn = null;
        try {
            cxn = this.createDirectConnection(username, password);
            if (DEBUG || this.protocol.getDEBUG()) {
                this.logger.log(8, "IMQDirectService:createConnection(" + username + "): [" + cxn.getConnectionUID() + ", " + cxn + "]");
            }
        }
        catch (BrokerException be) {
            Object[] args = new String[]{username, this.getName(), be.getMessage()};
            String emsg = Globals.getBrokerResources().getKString("B4447", args);
            this.logger.logStack(32, emsg, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            String ecode = be.getErrorCode();
            if (ecode != null) {
                props.put("JMQErrorCode", ecode);
            }
            throw new JMSServiceException(emsg, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQConnectionID", cxn.getConnectionUID().longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply destroyConnection(long connectionId) throws JMSServiceException {
        if (DEBUG || this.protocol.getDEBUG()) {
            this.logger.log(8, "IMQDirectService.destroyConnection(" + connectionId + ")");
        }
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        if (this.getState() != 6) {
            IMQConnection cxn = this.checkConnectionId(connectionId, "destroyConnection");
            this.localConnectionList.remove(cxn.getConnectionUID());
            cxn.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0059"));
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public long[] generateUID(long connectionId, int quantity) throws JMSServiceException {
        IMQConnection cxn = null;
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        cxn = this.checkConnectionId(connectionId, "generateUID");
        if (quantity < 0) {
            String errStr = "generateUID: quantity is less than 0: " + quantity;
            this.logger.log(32, errStr);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, props);
        }
        if (quantity == 0) {
            return null;
        }
        long[] ids = new long[quantity];
        short prefix = UID.getPrefix();
        for (int i = 0; i < quantity; ++i) {
            ids[i] = UniqueID.generateID(prefix);
        }
        return ids;
    }

    @Override
    public long generateUID(long connectionId) throws JMSServiceException {
        long[] oneId = this.generateUID(connectionId, 1);
        return oneId[0];
    }

    @Override
    public JMSServiceReply setClientId(long connectionId, String clientId, boolean shareable, String nameSpace) throws JMSServiceException {
        IMQConnection cxn = null;
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        cxn = this.checkConnectionId(connectionId, "setClientId");
        try {
            this.protocol.setClientID(cxn, clientId, nameSpace, shareable);
        }
        catch (BrokerException be) {
            String errStr = "setClientId: set client ID failed. Connection ID: " + connectionId + ", Client ID: " + clientId + ", Shareable: " + shareable + ", nameSpace: " + nameSpace;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply unsetClientId(long connectionId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "unsetClientId");
        try {
            this.protocol.setClientID(cxn, null, null, false);
        }
        catch (BrokerException be) {
            String errStr = "unsetClientId: unset client ID failed. Connection ID: " + connectionId;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply startConnection(long connectionId) throws JMSServiceException {
        IMQConnection cxn = this.checkConnectionId(connectionId, "startConnection");
        this.protocol.resumeConnection(cxn);
        SessionListener.startConnection(cxn);
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply stopConnection(long connectionId) throws JMSServiceException {
        IMQConnection cxn = this.checkConnectionId(connectionId, "stopConnection");
        this.protocol.pauseConnection(cxn);
        SessionListener.stopConnection(cxn);
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply createSession(long connectionId, JMSService.SessionAckMode ackMode) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        long sessionID = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "createSession");
        try {
            int brokerAckMode = this.convertToBrokerAckMode(ackMode);
            Session s = this.protocol.createSession(brokerAckMode, cxn);
            new SessionListener(this, s);
            sessionID = s.getSessionUID().longValue();
        }
        catch (BrokerException be) {
            String errStr = "createSession: create session failed. Connection ID: " + connectionId + ", acknowledge mode: " + (Object)((Object)ackMode);
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQSessionID", sessionID);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply destroySession(long connectionId, long sessionId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "destroySession");
        SessionUID sUID = new SessionUID(sessionId);
        try {
            this.protocol.destroySession(sUID, cxn);
            SessionListener.getListener(sUID).destroy();
        }
        catch (BrokerException be) {
            String errStr = "destroySession: destroy session failed. Connection ID: " + connectionId + ", Session ID: " + sessionId;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply startSession(long connectionId, long sessionId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "startSession");
        SessionUID sUID = new SessionUID(sessionId);
        try {
            SessionListener.getListener(sUID).startSession();
        }
        catch (Exception e) {
            String errStr = "startSession: Start of session failed. Session ID: " + sessionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply stopSession(long connectionId, long sessionId) throws JMSServiceException {
        return this.stopSession(connectionId, sessionId, false);
    }

    @Override
    public JMSServiceReply stopSession(long connectionId, long sessionId, boolean dowait) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "stopSession");
        SessionUID sUID = new SessionUID(sessionId);
        try {
            SessionListener.getListener(sUID).stopSession(dowait);
        }
        catch (Exception e) {
            String errStr = "stopSession: Stop of session failed. Session ID: " + sessionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply verifyDestination(long connectionId, Destination dest) throws JMSServiceException {
        Integer status;
        HashMap<String, Object> props = new HashMap<String, Object>();
        HashMap resultProps = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "verifyDestination");
        try {
            resultProps = this.protocol.verifyDestination(dest.getName(), dest.getType() == Destination.Type.QUEUE ? 1 : 2, null);
        }
        catch (Exception e) {
            String errStr = "verifyDestination: verify of destination failed. Destination name: " + dest.getName() + ", type: " + (Object)((Object)dest.getType());
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        if (resultProps != null && (status = (Integer)resultProps.get("JMQStatus")) != null) {
            if (status == 200) {
                props.put("JMQStatus", JMSServiceReply.Status.OK);
            } else if (status == 404) {
                Boolean canCreate = (Boolean)resultProps.get("JMQCanCreate");
                props.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
                if (canCreate != null) {
                    props.put("JMQCanCreate", canCreate);
                }
            }
        }
        props.put("JMQDestination", dest.getName());
        props.put("JMQDestType", (Object)dest.getType());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply createDestination(long connectionId, Destination dest) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "createDestination");
        int internalDestType = dest.getType() == Destination.Type.QUEUE ? 1 : 2;
        if (dest.getLife() == Destination.Life.TEMPORARY) {
            internalDestType |= 0x10;
        }
        if (cxn.isAdminConnection()) {
            internalDestType |= 0x20A0;
        }
        String errStr = "createDestination: Destination creation failed. Destination name: " + dest.getName() + ", type: " + (Object)((Object)dest.getType()) + ", lifespan: " + (Object)((Object)dest.getLife());
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination d = null;
            d = this.protocol.createDestination(dest.getName(), internalDestType, cxn, this.acEnabled);
        }
        catch (BrokerException be) {
            this.logger.logStack(32, errStr, be);
            int status = be.getStatusCode();
            if (status == 409) {
                props.put("JMQStatus", JMSServiceReply.Status.CONFLICT);
            } else if (status == 403) {
                props.put("JMQStatus", JMSServiceReply.Status.FORBIDDEN);
            } else {
                props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            }
            throw new JMSServiceException(errStr, be, props);
        }
        catch (IOException ioe) {
            this.logger.logStack(32, errStr, ioe);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, ioe, props);
        }
        catch (AccessControlException ace) {
            this.logger.logStack(32, errStr, ace);
            props.put("JMQStatus", JMSServiceReply.Status.FORBIDDEN);
            throw new JMSServiceException(errStr, ace, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQDestination", dest.getName());
        props.put("JMQDestType", (Object)dest.getType());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply destroyDestination(long connectionId, Destination dest) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "destroyDestination");
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination d = null;
            DestinationUID rmuid = DestinationUID.getUID(dest.getName(), dest.getType() == Destination.Type.QUEUE);
            Globals.getDestinationList();
            com.sun.messaging.jmq.jmsserver.core.Destination[] ds = DestinationList.getDestination(cxn.getPartitionedStore(), rmuid);
            d = ds[0];
            assert (d != null);
            Globals.getDestinationList();
            DestinationList.removeDestination(cxn.getPartitionedStore(), rmuid, true, Globals.getBrokerResources().getString("B0067", cxn.getConnectionUID()));
        }
        catch (Exception e) {
            String errStr = "destroyDestination: Destination destroy failed. Destination name: " + dest.getName() + ", type: " + (Object)((Object)dest.getType()) + ", lifespan: " + (Object)((Object)dest.getLife());
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply addProducer(long connectionId, long sessionId, Destination dest) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Producer prd = null;
        long producerID = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "addProducer");
        Session session = this.checkSessionId(sessionId, "addProducer");
        try {
            Globals.getDestinationList();
            com.sun.messaging.jmq.jmsserver.core.Destination[] ds = DestinationList.getDestination(cxn.getPartitionedStore(), dest.getName(), dest.getType() == Destination.Type.QUEUE);
            com.sun.messaging.jmq.jmsserver.core.Destination d = ds[0];
            prd = this.protocol.addProducer(d, cxn, new Object().toString(), this.acEnabled);
            producerID = prd.getProducerUID().longValue();
        }
        catch (Exception e) {
            String errStr = "addProducer: Add producer failed. Connection ID: " + connectionId + ", session ID: " + sessionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQProducerID", producerID);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply deleteProducer(long connectionId, long sessionId, long producerId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "deleteProducer");
        try {
            this.protocol.removeProducer(new ProducerUID(producerId), cxn, new Object().toString());
        }
        catch (Exception e) {
            String errStr = "deleteProducer: Delete producer failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", producer ID: " + producerId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply addConsumer(long connectionId, long sessionId, Destination dest, String selector, String subscriptionName, boolean durable, boolean share, boolean jmsshare, String clientId, boolean noLocal) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int size = 1000;
        long consumerID = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "addConsumer");
        Session session = this.checkSessionId(sessionId, "addConsumer");
        try {
            Globals.getDestinationList();
            com.sun.messaging.jmq.jmsserver.core.Destination[] ds = DestinationList.getDestination(cxn.getPartitionedStore(), dest.getName(), dest.getType() == Destination.Type.QUEUE);
            com.sun.messaging.jmq.jmsserver.core.Destination d = ds[0];
            boolean useFlowControl = false;
            Consumer con = this.protocol.createConsumer(d, cxn, session, selector, clientId, subscriptionName, durable, share, jmsshare, noLocal, size, new Object().toString(), this.acEnabled, useFlowControl);
            consumerID = con.getConsumerUID().longValue();
        }
        catch (Exception e) {
            String errStr = "addConsumer: Add consumer failed. Connection ID: " + connectionId + ", session ID: " + sessionId;
            this.logger.logStack(32, errStr, e);
            if (e instanceof SelectorFormatException) {
                props.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
            } else {
                props.put("JMQStatus", this.getErrorReplyStatus(e));
            }
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQConsumerID", consumerID);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply deleteConsumer(long connectionId, long sessionId, long consumerId, SysMessageID lastMessageSeen, boolean lastMessageSeenInTransaction, String durableName, String clientId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "deleteConsumer");
        Session session = this.checkSessionId(sessionId, "deleteConsumer");
        try {
            if (durableName == null) {
                ConsumerUID conUID = new ConsumerUID(consumerId);
                this.protocol.destroyConsumer(conUID, session, lastMessageSeen, lastMessageSeenInTransaction, cxn);
            } else {
                this.protocol.unsubscribe(durableName, clientId, cxn);
            }
        }
        catch (Exception e) {
            String errStr = "deleteConsumer: Delete consumer failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", consumer ID: " + consumerId + ", durable name: " + durableName + ", client ID: " + clientId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply setConsumerAsync(long connectionId, long sessionId, long consumerId, com.sun.messaging.jmq.jmsservice.Consumer consumer) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int size = -1;
        IMQConnection cxn = this.checkConnectionId(connectionId, "setConsumerAsync");
        Session session = this.checkSessionId(sessionId, "setConsumerAsync");
        try {
            ConsumerUID conUID = new ConsumerUID(consumerId);
            Consumer con = Consumer.getConsumer(conUID);
            SessionListener slistener = SessionListener.getListener(session.getSessionUID());
            slistener.setAsyncListener(con, consumer);
        }
        catch (Exception e) {
            String errStr = "setConsumerAsync: Set Async consumer failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", consumer ID: " + consumerId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQConsumerID", consumerId);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply startTransaction(long connectionId, long sessionId, Xid xid, int flags, JMSService.TransactionAutoRollback rollback, long timeout) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        TransactionUID txnUID = null;
        JMQXid jmqXid = null;
        Integer xaFlags = null;
        boolean isXA = false;
        AutoRollbackType type = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "startTransaction");
        if (xid != null) {
            isXA = true;
            jmqXid = new JMQXid(xid);
            xaFlags = new Integer(flags);
        }
        try {
            txnUID = this.protocol.startTransaction(jmqXid, xaFlags, type, timeout, cxn);
        }
        catch (BrokerException be) {
            String errStr = "startTransaction: start transaction failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", XID: " + xid;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQTransactionID", txnUID.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply endTransaction(long connectionId, long transactionId, Xid xid, int flags) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        TransactionUID txnUID = null;
        JMQXid jmqXid = null;
        Integer xaFlags = null;
        long tid = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "endTransaction");
        txnUID = new TransactionUID(transactionId);
        if (xid != null) {
            jmqXid = new JMQXid(xid);
            xaFlags = new Integer(flags);
        }
        try {
            this.protocol.endTransaction(txnUID, jmqXid, xaFlags, cxn);
        }
        catch (BrokerException be) {
            String errStr = "endTransaction: end transaction failed. Connection ID: " + connectionId + ", Transaction ID: " + transactionId + ", XID: " + xid;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQTransactionID", txnUID.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply prepareTransaction(long connectionId, long transactionId, Xid xid) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        TransactionUID txnUID = null;
        JMQXid jmqXid = null;
        Integer xaFlags = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "prepareTransaction");
        if (transactionId == 0L) {
            jmqXid = new JMQXid(xid);
            Object[] oo = TransactionList.mapXidToTid(jmqXid, cxn);
            if (oo == null) {
                String errStr = "prepareTransaction(" + connectionId + "): Unknown XID " + jmqXid;
                BrokerException be = new BrokerException(errStr, 404);
                props.put("JMQStatus", this.getErrorReplyStatus(be));
                throw new JMSServiceException(errStr, be, props);
            }
            txnUID = (TransactionUID)oo[1];
        } else {
            txnUID = new TransactionUID(transactionId);
        }
        try {
            this.protocol.prepareTransaction(txnUID, xaFlags, cxn);
        }
        catch (BrokerException be) {
            String errStr = "prepareTransaction: prepare transaction failed. Connection ID: " + connectionId + ", Transaction ID: " + transactionId + ", XID: " + xid;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQTransactionID", txnUID.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply commitTransaction(long connectionId, long transactionId, Xid xid, int flags) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        TransactionUID txnUID = null;
        JMQXid jmqXid = null;
        long tid = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "commitTransaction");
        txnUID = new TransactionUID(transactionId);
        if (xid != null) {
            jmqXid = new JMQXid(xid);
        }
        Integer xaFlags = new Integer(flags);
        try {
            this.protocol.commitTransaction(txnUID, jmqXid, xaFlags, cxn);
        }
        catch (BrokerException be) {
            String errStr = "CommitTransaction: commit failed. Connection ID: " + connectionId + ", Transaction ID: " + transactionId;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQTransactionID", txnUID.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply rollbackTransaction(long connectionId, long transactionId, Xid xid, boolean redeliver, boolean setRedelivered) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        TransactionUID txnUID = null;
        JMQXid jmqXid = null;
        Integer xaFlags = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "rollbackTransaction");
        txnUID = new TransactionUID(transactionId);
        if (xid != null) {
            jmqXid = new JMQXid(xid);
        }
        try {
            this.protocol.rollbackTransaction(txnUID, jmqXid, xaFlags, cxn, redeliver, setRedelivered);
        }
        catch (BrokerException be) {
            String errStr = "rollbackTransaction: rollback transaction failed. Connection ID: " + connectionId + ", Transaction ID: " + transactionId + ", XID: " + xid;
            this.logger.logStack(32, errStr, be);
            props.put("JMQStatus", this.getErrorReplyStatus(be));
            throw new JMSServiceException(errStr, be, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQTransactionID", txnUID.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public Xid[] recoverXATransactions(long connectionId, int flags) throws JMSServiceException {
        Xid[] jmqXids = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "recoverXATransactions");
        try {
            jmqXids = this.protocol.recoverTransaction(null);
        }
        catch (Exception e) {
            HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
            String errStr = "recoverXATransactions: recover XA transactions failed. Connection ID: " + connectionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        return jmqXids;
    }

    @Override
    public long recoverTransaction(long connectionId, long transactionId) throws JMSServiceException {
        TransactionUID txnUID = null;
        long tid = 0L;
        IMQConnection cxn = this.checkConnectionId(connectionId, "recoverTransaction");
        txnUID = new TransactionUID(transactionId);
        try {
            JMQXid[] jmqXids = this.protocol.recoverTransaction(txnUID);
            if (jmqXids.length > 0) {
                return transactionId;
            }
        }
        catch (Exception e) {
            String errStr = "recoverTransaction: recover transaction failed. Connection ID:" + connectionId + ", Transaction ID: " + transactionId;
            this.logger.logStack(32, errStr, e);
            HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        return 0L;
    }

    @Override
    public JMSServiceReply sendMessage(long connectionId, JMSPacket message) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "sendMessage");
        try {
            Packet p = new Packet();
            p.fill(message.getPacket());
            this.protocol.processMessage(cxn, p);
        }
        catch (Exception e) {
            String errStr = "sendMessage: Sending message failed. Connection ID: " + connectionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSPacket fetchMessage(long connectionId, long sessionId, long consumerId, long timeout, boolean acknowledge, long transactionId) throws JMSServiceException {
        Packet msg = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "fetchMessage");
        Session session = this.checkSessionId(sessionId, "fetchMessage");
        SessionListener slistener = SessionListener.getListener(session.getSessionUID());
        try {
            ConsumerUID conUID = new ConsumerUID(consumerId);
            msg = slistener.getNextConsumerPacket(conUID, timeout);
            if (msg != null && acknowledge) {
                TransactionUID txnUID = null;
                if (transactionId != 0L) {
                    txnUID = new TransactionUID(transactionId);
                }
                SysMessageID[] ids = new SysMessageID[]{msg.getSysMessageID()};
                ConsumerUID[] cids = new ConsumerUID[]{conUID};
                Globals.getProtocol().acknowledge(cxn, txnUID, false, 0, null, null, 0, ids, cids);
            }
        }
        catch (Exception e) {
            HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
            String errStr = "fetchMessage: Fetch Message failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", consumer ID: " + consumerId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, e, props);
        }
        return msg;
    }

    @Override
    public JMSServiceReply acknowledgeMessage(long connectionId, long sessionId, long consumerId, SysMessageID sysMessageID, long transactionId, JMSService.MessageAckType ackType) throws JMSServiceException {
        return this.acknowledgeMessage(connectionId, sessionId, consumerId, sysMessageID, transactionId, ackType, -1, null, null);
    }

    @Override
    public JMSServiceReply acknowledgeMessage(long connectionId, long sessionId, long consumerId, SysMessageID sysMessageID, long transactionId, JMSService.MessageAckType ackType, int retryCnt) throws JMSServiceException {
        return this.acknowledgeMessage(connectionId, sessionId, consumerId, sysMessageID, transactionId, ackType, retryCnt, null, null);
    }

    @Override
    public JMSServiceReply acknowledgeMessage(long connectionId, long sessionId, long consumerId, SysMessageID sysMessageID, long transactionId, JMSService.MessageAckType ackType, int retryCnt, String deadComment, Throwable deadThr) throws JMSServiceException {
        boolean validate = false;
        TransactionUID txnUID = null;
        SysMessageID[] ids = null;
        ConsumerUID[] cids = null;
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "acknowledgeMessage");
        if (transactionId != 0L) {
            txnUID = new TransactionUID(transactionId);
        }
        int brokerAckType = this.convertToBrokerAckType(ackType);
        ids = new SysMessageID[]{sysMessageID};
        cids = new ConsumerUID[]{new ConsumerUID(consumerId)};
        try {
            this.protocol.acknowledge(cxn, txnUID, validate, brokerAckType, deadThr, deadComment, retryCnt, ids, cids);
        }
        catch (Exception e) {
            String errStr = "acknowledgeMessage: Sending Acknowledgement failed. Connection ID: " + connectionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply sendAcknowledgement(long connectionId, JMSService.MessageAckType ackType, JMSPacket acks) throws JMSServiceException {
        boolean validate = false;
        long transactionId = -1L;
        TransactionUID txnUID = null;
        int deliverCnt = -1;
        SysMessageID[] ids = null;
        ConsumerUID[] cids = null;
        Throwable deadThr = null;
        String deadComment = null;
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "sendAcknowledgement");
        if (transactionId != -1L) {
            txnUID = new TransactionUID(transactionId);
        }
        int brokerAckType = this.convertToBrokerAckType(ackType);
        try {
            this.protocol.acknowledge(cxn, txnUID, validate, brokerAckType, deadThr, deadComment, deliverCnt, ids, cids);
        }
        catch (Exception e) {
            String errStr = "sendAcknowledgement: Sending Acknowledgement failed. Connection ID: " + connectionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply addBrowser(long connectionId, long sessionId, Destination dest, String selector) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "addBrowser");
        Session session = this.checkSessionId(sessionId, "addBrowser");
        try {
            Selector sel = Selector.compile(selector);
        }
        catch (SelectorFormatException sfe) {
            String errStr = "addBrowser: Add browser failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", destination: " + dest + ", selector: " + selector;
            this.logger.logStack(32, errStr, sfe);
            props.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
            throw new JMSServiceException(errStr, sfe, props);
        }
        ConsumerUID uid = new ConsumerUID();
        this.queueBrowseList.put(uid, new QueueBrowserInfo(dest, selector));
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQConsumerID", uid.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    @Override
    public JMSServiceReply deleteBrowser(long connectionId, long sessionId, long consumerId) throws JMSServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        IMQConnection cxn = this.checkConnectionId(connectionId, "deleteBrowser");
        Session session = this.checkSessionId(sessionId, "deleteBrowser");
        ConsumerUID uid = new ConsumerUID(consumerId);
        if (!this.queueBrowseList.containsKey(uid)) {
            String errStr = "deleteBrowser: consumer ID not found. Connection ID:" + connectionId + ", Session ID: " + sessionId + ", Consumer ID: " + consumerId;
            this.logger.log(32, errStr);
            props.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
            throw new JMSServiceException(errStr, props);
        }
        this.queueBrowseList.remove(uid);
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        props.put("JMQConsumerID", uid.longValue());
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JMSPacket[] browseMessages(long connectionId, long sessionId, long consumerId) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        JMSPacket[] msgs = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "browseMessages");
        Session session = this.checkSessionId(sessionId, "browseMessages");
        ConsumerUID uid = new ConsumerUID(consumerId);
        if (this.queueBrowseList.containsKey(uid)) {
            QueueBrowserInfo qbi = (QueueBrowserInfo)this.queueBrowseList.get(uid);
            try {
                Destination dest = qbi.dest;
                String selector = qbi.selector;
                com.sun.messaging.jmq.jmsserver.core.Destination[] ds = null;
                com.sun.messaging.jmq.jmsserver.core.Destination d = null;
                Globals.getDestinationList();
                ds = DestinationList.getDestination(cxn.getPartitionedStore(), dest.getName(), dest.getType() == Destination.Type.QUEUE);
                d = ds[0];
                if (d == null) {
                    String errStr = "browseMessages: destination not found. Connection ID:" + connectionId + ", Session ID: " + sessionId + ", Consumer ID: " + consumerId + "destination: " + dest.toString();
                    this.logger.log(32, errStr);
                    props.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
                    throw new JMSServiceException(errStr, props);
                }
                ArrayList msgIds = this.protocol.browseQueue(d, selector, cxn, this.acEnabled);
                if (msgIds == null) return msgs;
                int numMsgs = msgIds.size();
                if (numMsgs == 0) {
                    return null;
                }
                msgs = new JMSPacket[numMsgs];
                DestinationList dl = Globals.getDestinationList();
                for (int i = 0; i < numMsgs; ++i) {
                    PacketReference pr = DestinationList.get(null, (SysMessageID)msgIds.get(i));
                    msgs[i] = pr.getPacket();
                }
                return msgs;
            }
            catch (Exception e) {
                String errStr = "browseMessages: Browse queue failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", consumer ID: " + consumerId;
                this.logger.logStack(32, errStr, e);
                if (e instanceof SelectorFormatException) {
                    props.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
                    throw new JMSServiceException(errStr, e, props);
                } else {
                    props.put("JMQStatus", this.getErrorReplyStatus(e));
                }
                throw new JMSServiceException(errStr, e, props);
            }
        } else {
            String errStr = "browseMessages: consumer ID not found. Connection ID:" + connectionId + ", Session ID: " + sessionId + ", Consumer ID: " + consumerId;
            this.logger.log(32, errStr);
            props.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
            throw new JMSServiceException(errStr, props);
        }
    }

    @Override
    public JMSServiceReply redeliverMessages(long connectionId, long sessionId, SysMessageID[] messageIDs, Long[] consumerIds, long transactionId, boolean setRedelivered) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
        ConsumerUID[] conUIDs = null;
        TransactionUID txnUID = null;
        IMQConnection cxn = this.checkConnectionId(connectionId, "redeliverMessages");
        Session session = this.checkSessionId(sessionId, "redeliverMessages");
        if (consumerIds != null) {
            conUIDs = new ConsumerUID[consumerIds.length];
            for (int i = 0; i < consumerIds.length; ++i) {
                conUIDs[i] = new ConsumerUID(consumerIds[i]);
            }
        }
        if (transactionId != -1L) {
            txnUID = new TransactionUID(transactionId);
        }
        try {
            this.protocol.redeliver(conUIDs, messageIDs, cxn, txnUID, setRedelivered);
        }
        catch (Exception e) {
            String errStr = "redeliverMessages: Redeliver failed. Connection ID: " + connectionId + ", session ID: " + sessionId + ", transaction ID: " + transactionId;
            this.logger.logStack(32, errStr, e);
            props.put("JMQStatus", this.getErrorReplyStatus(e));
            throw new JMSServiceException(errStr, e, props);
        }
        props.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply reply = new JMSServiceReply(props, null);
        return reply;
    }

    protected IMQConnection checkConnectionId(long connectionId, String methodName) throws JMSServiceException {
        ConnectionManager cm = Globals.getConnectionManager();
        IMQConnection cxn = (IMQConnection)cm.getConnection(new ConnectionUID(connectionId));
        if (cxn == null) {
            String errStr = methodName + ": connection ID not found: " + connectionId;
            this.logger.log(32, errStr);
            HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, props);
        }
        return cxn;
    }

    private Session checkSessionId(long sessionId, String methodName) throws JMSServiceException {
        Session ses = Session.getSession(new SessionUID(sessionId));
        if (ses == null) {
            String errStr = methodName + ": session ID not found: " + sessionId;
            this.logger.log(32, errStr);
            HashMap<String, JMSServiceReply.Status> props = new HashMap<String, JMSServiceReply.Status>();
            props.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(errStr, props);
        }
        return ses;
    }

    private int convertToBrokerAckMode(JMSService.SessionAckMode ackMode) {
        switch (ackMode) {
            case AUTO_ACKNOWLEDGE: {
                return 1;
            }
            case CLIENT_ACKNOWLEDGE: {
                return 2;
            }
            case DUPS_OK_ACKNOWLEDGE: {
                return 3;
            }
            case NO_ACKNOWLEDGE: {
                return 32768;
            }
            case UNSPECIFIED: {
                return 0;
            }
        }
        return 0;
    }

    private int convertToBrokerAckType(JMSService.MessageAckType ackType) {
        switch (ackType) {
            case ACKNOWLEDGE: {
                return 0;
            }
            case UNDELIVERABLE: {
                return 1;
            }
            case DEAD: {
                return 2;
            }
        }
        return 0;
    }

    private JMSServiceReply.Status getErrorReplyStatus(Exception e) {
        JMSServiceReply.Status retStatus = JMSServiceReply.Status.ERROR;
        if (e instanceof BrokerException) {
            BrokerException be = (BrokerException)e;
            int status = be.getStatusCode();
            switch (status) {
                case 403: {
                    retStatus = JMSServiceReply.Status.FORBIDDEN;
                    break;
                }
                case 409: {
                    retStatus = JMSServiceReply.Status.CONFLICT;
                    break;
                }
                case 400: {
                    retStatus = JMSServiceReply.Status.BAD_REQUEST;
                    break;
                }
                case 404: {
                    retStatus = JMSServiceReply.Status.NOT_FOUND;
                    break;
                }
                case 405: {
                    retStatus = JMSServiceReply.Status.NOT_ALLOWED;
                    break;
                }
                case 412: {
                    retStatus = JMSServiceReply.Status.PRECONDITION_FAILED;
                    break;
                }
                case 304: {
                    retStatus = JMSServiceReply.Status.NOT_MODIFIED;
                    break;
                }
                case 501: {
                    retStatus = JMSServiceReply.Status.NOT_IMPLEMENTED;
                    break;
                }
                case 408: {
                    retStatus = JMSServiceReply.Status.TIMEOUT;
                }
            }
        }
        return retStatus;
    }
}

