/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MQThread;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.glassfish.grizzly.Connection;

public class GrizzlyMQIPConnection
extends IMQIPConnection
implements Runnable {
    private static boolean DEBUG = Globals.getLogger().getLevel() <= 4;
    private Connection grizzlyConn = null;
    private Thread writerThread = null;
    private Object assignWriteLock = new Object();
    private boolean writeThreadAssigned = false;

    public GrizzlyMQIPConnection(GrizzlyIPService svc, PacketRouter router, Connection c) throws IOException, BrokerException {
        super(svc, null, router);
        this.grizzlyConn = c;
        this.setRemoteIP(this.getRemoteAddress().getAddress());
        if (svc.useDedicatedWriter()) {
            this.writerThread = new MQThread(this, "GrizzlyMQIPConnection");
            this.writerThread.start();
        }
    }

    @Override
    protected InetAddress getRemoteAddress() {
        if (this.grizzlyConn == null) {
            return null;
        }
        return ((InetSocketAddress)this.grizzlyConn.getPeerAddress()).getAddress();
    }

    @Override
    protected int getRemotePort() {
        return ((InetSocketAddress)this.grizzlyConn.getPeerAddress()).getPort();
    }

    @Override
    public int getLocalPort() {
        return ((InetSocketAddress)this.grizzlyConn.getLocalAddress()).getPort();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public synchronized AbstractSelectableChannel getChannel() {
        throw new RuntimeException("Unexpected call: " + this.getClass().getName() + ".getChannel()");
    }

    @Override
    protected void closeProtocolStream() throws IOException {
        this.grizzlyConn.close();
    }

    @Override
    public void sendControlMessage(Packet msg) {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:sendControlMessage: " + msg + ", " + this.isValid());
        }
        if (!this.isValid() && msg.getPacketType() != 28) {
            this.logger.log(8, "Internal Warning: message " + msg + "queued on destroyed connection " + this);
        }
        if (!this.grizzlyConn.isOpen() && msg.getPacketType() == 28) {
            return;
        }
        try {
            if (GrizzlyMQIPConnection.getDEBUG() || GrizzlyMQIPConnection.getDumpPacket() || GrizzlyMQIPConnection.getDumpOutPacket()) {
                this.dumpControlPacket(msg);
            }
            this.grizzlyConn.write((Object)msg);
        }
        catch (Exception e) {
            this.logger.logStack(16, "Failed to send control packet " + msg + " to " + this.grizzlyConn, e);
        }
    }

    public void receivedPacket(Packet pkt) {
        this.readpkt = pkt;
    }

    @Override
    protected boolean readInPacket(Packet p) throws IllegalArgumentException, StreamCorruptedException, BigPacketException, IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:readInPacket: " + this.readpkt);
        }
        assert (this.readpkt != null);
        if (this.readpkt == null) {
            throw new IOException("No packet to read");
        }
        return true;
    }

    @Override
    protected boolean writeOutPacket(Packet p) throws IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:writeOutPacket(" + p + ") to " + this.grizzlyConn);
        }
        this.grizzlyConn.write((Object)p);
        return true;
    }

    @Override
    protected void handleWriteException(Throwable e) throws IOException, OutOfMemoryError {
        super.handleWriteException(e);
    }

    @Override
    protected void handleBigPacketException(Packet pkt, BigPacketException e) {
        super.handleBigPacketException(pkt, e);
    }

    @Override
    protected void handleIllegalArgumentExceptionPacket(Packet pkt, IllegalArgumentException e) {
        super.handleIllegalArgumentExceptionPacket(pkt, e);
    }

    @Override
    public synchronized void threadAssigned(OperationRunnable runner, int events) throws IllegalAccessException {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.threadAssigned()");
    }

    @Override
    protected void localFlushCtrl() {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.localFlushCtrl()");
    }

    @Override
    protected void localFlush() {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.localFlush()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean assignWriteThread(boolean b) {
        Object object = this.assignWriteLock;
        synchronized (object) {
            if (b && this.writeThreadAssigned) {
                return false;
            }
            this.writeThreadAssigned = b;
            return true;
        }
    }

    @Override
    public void run() {
        while (this.isValid()) {
            try {
                this.writeData(true);
            }
            catch (IOException e) {
                if (!this.isValid()) continue;
                this.logger.logStack(32, "Exception in writing data on conection " + this, e);
            }
        }
    }
}

