/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.portunif;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.portunif.PortMapperMessageFilter;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class PortMapperServiceFilter
extends BaseFilter {
    private PortMapper pm = null;
    private boolean ssl = false;

    public PortMapperServiceFilter(boolean ssl) {
        this.ssl = ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        Logger logger = Globals.getLogger();
        if (this.ssl) {
            logger.log(8, Globals.getBrokerResources().getKString("B1500", "SSL/TLS", ctx.getConnection().getPeerAddress()));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PortMapperServiceFilter portMapperServiceFilter = this;
        synchronized (portMapperServiceFilter) {
            if (this.pm == null) {
                this.pm = Globals.getPortMapper();
                if (this.pm == null) {
                    throw new IOException("Broker portmapper not ready yet");
                }
            }
            this.pm.getPortMapTable().write(bos);
        }
        byte[] reply = bos.toByteArray();
        bos.close();
        if (PortMapperMessageFilter.DEBUG) {
            logger.log(8, "PortMapperServiceFilter.handleRead() write data size " + reply.length + " to connection " + ctx.getConnection());
        }
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        Buffer output = mm.allocate(reply.length);
        output.put(reply);
        output.allowBufferDispose();
        final CloseCompletionHandler cch = new CloseCompletionHandler(ctx);
        ctx.write((Object)output, (CompletionHandler)new CompletionHandler<WriteResult>(){

            public void cancelled() {
                ctx.getConnection().close((CompletionHandler)cch);
            }

            public void failed(Throwable t) {
                ctx.getConnection().close((CompletionHandler)cch);
            }

            public void completed(WriteResult w) {
                ctx.getConnection().close((CompletionHandler)cch);
            }

            public void updated(WriteResult w) {
            }
        });
        return ctx.getStopAction();
    }

    private class CloseCompletionHandler
    implements CompletionHandler<Connection> {
        Logger logger = Globals.getLogger();
        FilterChainContext ctx = null;

        CloseCompletionHandler(FilterChainContext ctx) {
            this.ctx = ctx;
        }

        public void cancelled() {
            this.logger.log(16, "Close [" + this.ctx + "] connection cancelled");
        }

        public void failed(Throwable t) {
            this.logger.logStack(16, "Close [" + this.ctx + "] connection failed", t);
        }

        public void completed(Connection c) {
            this.logger.log(1, "Close [" + this.ctx + ":" + c + "] connection complete");
        }

        public void updated(Connection c) {
        }
    }
}

