/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class LockFile {
    private static LockFile currentLockFile = null;
    private String hostname = null;
    private String instance = null;
    private String filePath = null;
    private int port = 0;
    private boolean isMyLock = false;

    private LockFile() {
    }

    private LockFile(String instance, String hostname, int port) {
        this.hostname = hostname;
        this.instance = instance;
        this.port = port;
    }

    public static synchronized void clearLock() {
        currentLockFile = null;
    }

    public static synchronized LockFile getLock(String varhome, String instance, String hostname, int port) throws IOException {
        LockFile lf = null;
        File file = new File(LockFile.getLockFilePath(varhome, instance));
        if (file.createNewFile()) {
            lf = new LockFile(instance, hostname, port);
            lf.filePath = file.getCanonicalPath();
            lf.isMyLock = true;
            lf.writeLockFile(file);
            file.deleteOnExit();
            currentLockFile = lf;
            return lf;
        }
        lf = LockFile.loadLockFile(file);
        lf.filePath = file.getCanonicalPath();
        if (port == lf.getPort() && LockFile.equivalentHostNames(hostname, lf.getHost(), false) && instance.equals(lf.getInstance())) {
            file.deleteOnExit();
            lf.isMyLock = true;
            currentLockFile = lf;
            return lf;
        }
        if (port == lf.getPort() && LockFile.isSameIP(hostname, lf.getHost()) && instance.equals(lf.getInstance())) {
            lf.updateHostname(hostname);
            file.deleteOnExit();
            lf.isMyLock = true;
            currentLockFile = lf;
            return lf;
        }
        Socket s = null;
        try {
            s = new Socket(InetAddress.getByName(lf.hostname), lf.port);
            lf.isMyLock = false;
        }
        catch (IOException e) {
            if (!file.delete()) {
                throw new IOException(CommGlobals.getBrokerResources().getString("B4106"));
            }
            return LockFile.getLock(varhome, instance, hostname, port);
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        currentLockFile = lf;
        return lf;
    }

    public static boolean isSameIP(String host1, String host2) {
        boolean sflag = false;
        try {
            String addr1 = InetAddress.getByName(host1).getHostAddress();
            String addr2 = InetAddress.getByName(host2).getHostAddress();
            if (addr1.equals(addr2)) {
                sflag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sflag;
    }

    public static String getLockFilePath(String varhome, String instance) {
        return varhome + File.separator + "instances" + File.separator + instance + File.separator + "lock";
    }

    public boolean isMyLock() {
        return this.isMyLock;
    }

    public String getHost() {
        return this.hostname;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.instance + " " + this.hostname + ":" + this.port + " (" + this.isMyLock + ")";
    }

    public void updatePort(int port) throws IOException {
        File file = new File(this.filePath);
        int oldPort = this.port;
        this.port = port;
        try {
            this.writeLockFile(file);
        }
        catch (IOException e) {
            this.port = oldPort;
            throw e;
        }
    }

    public void updateHostname(String hostname) throws IOException {
        File file = new File(this.filePath);
        String oldHostname = this.hostname;
        this.hostname = hostname;
        try {
            this.writeLockFile(file);
        }
        catch (IOException e) {
            this.hostname = oldHostname;
            throw e;
        }
    }

    public static synchronized LockFile loadLockFile(File file) throws IOException {
        byte[] data = new byte[128];
        LockFile lf = new LockFile();
        FileInputStream fis = new FileInputStream(file);
        fis.read(data);
        String s = new String(data, "UTF8");
        StringTokenizer st = null;
        int i1 = s.indexOf(58);
        if (i1 == -1) {
            throw new IOException(CommGlobals.getBrokerResources().getKString("B4314", file.toString(), s));
        }
        st = new StringTokenizer(s.substring(0, i1), " \t\n\r\f");
        lf.instance = st.nextToken();
        int i2 = s.lastIndexOf(58);
        if (i2 == -1 || i1 == i2) {
            throw new IOException(CommGlobals.getBrokerResources().getKString("B4314", file.toString(), s));
        }
        st = new StringTokenizer(s.substring(i2 + 1), " \t\n\r\f");
        lf.port = Integer.parseInt(st.nextToken());
        st = new StringTokenizer(s.substring(i1 + 1, i2), " \t\n\r\f");
        lf.hostname = st.nextToken();
        fis.close();
        return lf;
    }

    public synchronized void writeLockFile(File file) throws IOException {
        String data = this.instance + ":" + this.hostname + ":" + this.port + "\n";
        FileOutputStream os = new FileOutputStream(file);
        os.write(data.getBytes("UTF8"));
        os.close();
    }

    public static LockFile getCurrentLockFile() {
        return currentLockFile;
    }

    public static boolean equivalentHostNames(String h1, String h2, boolean exact) {
        if (exact) {
            return h1.equals(h2);
        }
        StringTokenizer st1 = new StringTokenizer(h1, ".");
        StringTokenizer st2 = new StringTokenizer(h2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            if (st1.nextToken().equals(st2.nextToken())) continue;
            return false;
        }
        return true;
    }
}

