/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtil {
    FileUtil() {
    }

    public static void removeFiles(File path, boolean removeTopDir) throws IOException {
        if (!path.exists()) {
            return;
        }
        if (!path.isDirectory()) {
            if (!path.delete()) {
                throw new IOException("failed to delete " + path);
            }
        } else {
            String[] files = path.list();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.removeFiles(new File(path, files[i]), true);
                }
            }
            if (removeTopDir && !path.delete()) {
                throw new IOException("failed to delete " + path);
            }
        }
    }

    public static String getCanonicalPath(String path) {
        File f = new File(path);
        try {
            return f.getCanonicalPath();
        }
        catch (Exception e) {
            return path;
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtil.copyFile(srcDir, dstDir);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel dstChannel = new FileOutputStream(dst).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }
}

