/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class ASN1Header {
    private byte[] cachedEncoding = null;
    private Tag tag;
    private long contentLength;
    public static final Form PRIMITIVE = Form.PRIMITIVE;
    public static final Form CONSTRUCTED = Form.CONSTRUCTED;
    private Form form;
    private static final int MAX_LOOK_AHEAD = 32;

    public long getTotalLength() {
        if (this.contentLength == -1L) {
            return -1L;
        }
        return (long)this.encode().length + this.contentLength;
    }

    public Tag getTag() {
        return this.tag;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Form getForm() {
        return this.form;
    }

    public static ASN1Header lookAhead(InputStream inputStream) throws IOException, InvalidBERException {
        if (!inputStream.markSupported()) {
            throw new IOException("Mark not supported on this input stream");
        }
        inputStream.mark(32);
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        inputStream.reset();
        return aSN1Header;
    }

    public ASN1Header(InputStream inputStream) throws InvalidBERException, IOException {
        long l;
        byte by;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read();
        if (n == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        byteArrayOutputStream.write(n);
        byte by2 = (byte)n;
        Tag.Class clazz = Tag.Class.fromInt((by2 & 0xFF) >>> 6);
        this.form = (by2 & 0x20) == 32 ? CONSTRUCTED : PRIMITIVE;
        if ((by2 & 0x1F) == 31) {
            int n2;
            object = new Vector<Byte>();
            do {
                if ((n = inputStream.read()) == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
                }
                byteArrayOutputStream.write(n);
                by = (byte)n;
                ((Vector)object).addElement(new Byte(by));
            } while ((by & 0x80) == 128);
            Assert._assert(((Vector)object).size() > 0);
            byte[] byArray = new byte[(((Vector)object).size() * 7 + 7) / 8];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = 0;
            }
            int n3 = 0;
            n2 = byArray.length - 1;
            for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                Assert._assert(i >= 0);
                Assert._assert(i < ((Vector)object).size());
                Assert._assert(n2 >= 0);
                Assert._assert(n2 < byArray.length);
                byte by3 = (byte)((Byte)((Vector)object).elementAt(i) & 0x7F);
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | by3 << n3);
                if (n3 > 1) {
                    Assert._assert(n2 > 0);
                    int n5 = --n2;
                    byArray[n5] = (byte)(byArray[n5] | by3 >>> 8 - n3);
                }
                n3 = (n3 + 7) % 8;
            }
            l = new BigInteger(1, byArray).longValue();
        } else {
            l = by2 & 0x1F;
        }
        this.tag = new Tag(clazz, l);
        n = inputStream.read();
        if (n == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        byteArrayOutputStream.write(n);
        by = (byte)n;
        if ((by & 0x80) == 0) {
            this.contentLength = by;
        } else if ((by & 0x7F) == 0) {
            this.contentLength = -1L;
        } else {
            object = new byte[by & 0x7F];
            ASN1Util.readFully((byte[])object, inputStream);
            byteArrayOutputStream.write((byte[])object);
            this.contentLength = new BigInteger(1, (byte[])object).longValue();
        }
        this.cachedEncoding = byteArrayOutputStream.toByteArray();
    }

    public ASN1Header(Tag tag, Form form, long l) {
        this.tag = tag;
        this.form = form;
        Assert._assert(l >= 0L);
        this.contentLength = l;
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public byte[] encode() {
        Object object;
        if (this.cachedEncoding != null) {
            return this.cachedEncoding;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        n = (byte)(n | this.tag.getTagClass().toInt() << 6);
        if (this.form == CONSTRUCTED) {
            n = (byte)(n | 0x20);
        }
        if (this.tag.getNum() <= 30L) {
            n = (byte)((long)n | this.tag.getNum() & 0x1FL);
            byteArrayOutputStream.write(n);
        } else {
            n = (byte)(n | 0x1F);
            object = BigInteger.valueOf(this.tag.getNum());
            byteArrayOutputStream.write(n);
            int n2 = ((BigInteger)object).bitLength();
            int n3 = (n2 + 6) / 7;
            --n3;
            while (n3 > 0) {
                long l = this.tag.getNum() >>> 7 * n3;
                byteArrayOutputStream.write((byte)l & 0x7F | 0x80);
                --n3;
            }
            byteArrayOutputStream.write((byte)this.tag.getNum() & 0x7F);
        }
        if (this.contentLength == -1L) {
            byteArrayOutputStream.write(-128);
        } else if (this.contentLength <= 127L) {
            byteArrayOutputStream.write((byte)this.contentLength);
        } else {
            object = ASN1Header.unsignedBigIntToByteArray(BigInteger.valueOf(this.contentLength));
            byteArrayOutputStream.write((byte)((Object)object).length | 0x80);
            byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
        }
        this.cachedEncoding = byteArrayOutputStream.toByteArray();
        return this.cachedEncoding;
    }

    public static byte[] unsignedBigIntToByteArray(BigInteger bigInteger) {
        Assert._assert(bigInteger.compareTo(BigInteger.valueOf(0L)) != -1);
        int n = bigInteger.bitLength();
        int n2 = n == 0 ? 1 : (n + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (n2 == byArray.length) {
            return byArray;
        }
        Assert._assert(n2 == byArray.length - 1);
        Assert._assert(byArray[0] == 0);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        return byArray2;
    }

    public void validate(Tag tag, Form form) throws InvalidBERException {
        this.validate(tag);
        if (this.getForm() != form) {
            throw new InvalidBERException("Incorrect form: expected [" + form + "], found [" + this.getForm());
        }
    }

    public void validate(Tag tag) throws InvalidBERException {
        if (!this.getTag().equals(tag)) {
            throw new InvalidBERException("Incorrect tag: expected [" + tag + "], found [" + this.getTag() + "]");
        }
    }

    public boolean isEOC() {
        return this.tag.equals(Tag.EOC);
    }
}

