/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.MacData;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.DigestInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;

public class PFX
implements ASN1Value {
    private INTEGER version;
    private AuthenticatedSafes authSafes;
    private MacData macData;
    private byte[] encodedAuthSafes;
    private static final INTEGER VERSION = new INTEGER(3L);
    public static final int DEFAULT_ITERATIONS = 1;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public AuthenticatedSafes getAuthSafes() {
        return this.authSafes;
    }

    public MacData getMacData() {
        return this.macData;
    }

    private void setEncodedAuthSafes(byte[] byArray) {
        this.encodedAuthSafes = byArray;
    }

    public boolean verifyAuthSafes(Password password, StringBuffer stringBuffer) throws CryptoManager.NotInitializedException {
        try {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (this.macData == null) {
                stringBuffer.append("No MAC present in PFX");
                return false;
            }
            if (this.encodedAuthSafes == null) {
                this.encodedAuthSafes = ASN1Util.encode(this.authSafes);
            }
            DigestInfo digestInfo = this.macData.getMac();
            MacData macData = new MacData(password, this.macData.getMacSalt().toByteArray(), this.macData.getMacIterationCount().intValue(), this.encodedAuthSafes);
            if (macData.getMac().equals(digestInfo)) {
                return true;
            }
            stringBuffer.append("Digests do not match");
            return false;
        }
        catch (DigestException digestException) {
            digestException.printStackTrace();
            stringBuffer.append("A DigestException occurred");
            return false;
        }
        catch (TokenException tokenException) {
            stringBuffer.append("A TokenException occurred");
            return false;
        }
        catch (CharConversionException charConversionException) {
            stringBuffer.append("An exception occurred converting the password from chars to bytes");
            return false;
        }
    }

    private PFX() {
    }

    public PFX(INTEGER iNTEGER, AuthenticatedSafes authenticatedSafes, MacData macData) {
        if (iNTEGER == null || authenticatedSafes == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.version = iNTEGER;
        this.authSafes = authenticatedSafes;
        this.macData = macData;
    }

    public PFX(AuthenticatedSafes authenticatedSafes, MacData macData) {
        this(VERSION, authenticatedSafes, macData);
    }

    public PFX(AuthenticatedSafes authenticatedSafes) {
        this(VERSION, authenticatedSafes, null);
    }

    public void computeMacData(Password password, byte[] byArray, int n) throws CryptoManager.NotInitializedException, DigestException, TokenException, CharConversionException {
        this.macData = new MacData(password, byArray, n, ASN1Util.encode(this.authSafes));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.version);
        sEQUENCE.addElement(new ContentInfo(ASN1Util.encode(this.authSafes)));
        if (this.macData != null) {
            sEQUENCE.addElement(this.macData);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            if (stringArray.length != 2) {
                System.out.println("Usage: PFX <dbdir> <infile>");
                System.exit(-1);
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            int n = 0;
            CryptoManager.initialize(stringArray[0]);
            Template template = new Template();
            PFX pFX = (PFX)template.decode(new BufferedInputStream(fileInputStream, 2048));
            System.out.println("Decoded PFX");
            System.out.println("Version: " + pFX.getVersion());
            AuthenticatedSafes authenticatedSafes = pFX.getAuthSafes();
            SEQUENCE sEQUENCE = authenticatedSafes.getSequence();
            System.out.println("AuthSafes has " + sEQUENCE.size() + " SafeContents");
            System.out.println("Enter password: ");
            Password password = Password.readPasswordFromConsole();
            System.out.println("Enter new password:");
            Password password2 = Password.readPasswordFromConsole();
            StringBuffer stringBuffer = new StringBuffer();
            if (pFX.verifyAuthSafes(password, stringBuffer)) {
                System.out.println("AuthSafes verifies correctly");
            } else {
                System.out.println("AuthSafes failed to verify because: " + stringBuffer);
            }
            AuthenticatedSafes authenticatedSafes2 = new AuthenticatedSafes();
            for (int i = 0; i < sEQUENCE.size(); ++i) {
                object = authenticatedSafes.getSafeContentsAt(password, i);
                System.out.println("\n\nSafeContents #" + i + " has " + ((SET)object).size() + " bags");
                for (int j = 0; j < ((SET)object).size(); ++j) {
                    Object object2;
                    Object object3;
                    ASN1Value aSN1Value;
                    ASN1Value aSN1Value2;
                    SafeBag safeBag = (SafeBag)((SET)object).elementAt(j);
                    System.out.println("\nBag " + j + " has type " + safeBag.getBagType());
                    SET sET = safeBag.getBagAttributes();
                    if (sET == null) {
                        System.out.println("Bag has no attributes");
                    } else {
                        for (int k = 0; k < sET.size(); ++k) {
                            aSN1Value2 = (Attribute)sET.elementAt(k);
                            if (((Attribute)aSN1Value2).getType().equals(SafeBag.FRIENDLY_NAME)) {
                                aSN1Value = (BMPString)((ANY)((Attribute)aSN1Value2).getValues().elementAt(0)).decodeWith(BMPString.getTemplate());
                                System.out.println("Friendly Name: " + aSN1Value);
                                continue;
                            }
                            if (((Attribute)aSN1Value2).getType().equals(SafeBag.LOCAL_KEY_ID)) {
                                aSN1Value = (OCTET_STRING)((ANY)((Attribute)aSN1Value2).getValues().elementAt(0)).decodeWith(OCTET_STRING.getTemplate());
                                System.out.println("LocalKeyID:");
                                AuthenticatedSafes.print_byte_array(((OCTET_STRING)aSN1Value).toByteArray());
                                continue;
                            }
                            System.out.println("Unknown attribute type");
                        }
                    }
                    ASN1Value aSN1Value3 = safeBag.getInterpretedBagContent();
                    if (aSN1Value3 instanceof PrivateKeyInfo) {
                        System.out.println("content is PrivateKeyInfo");
                        continue;
                    }
                    if (aSN1Value3 instanceof EncryptedPrivateKeyInfo) {
                        aSN1Value2 = (EncryptedPrivateKeyInfo)aSN1Value3;
                        System.out.println("content is EncryptedPrivateKeyInfo, algoid:" + ((EncryptedPrivateKeyInfo)aSN1Value2).getEncryptionAlgorithm().getOID());
                        aSN1Value = ((EncryptedPrivateKeyInfo)aSN1Value2).decrypt(password, new PasswordConverter());
                        object3 = new byte[20];
                        object2 = CryptoManager.getInstance().getSecureRNG();
                        object2.nextBytes((byte[])object3);
                        aSN1Value2 = EncryptedPrivateKeyInfo.createPBE(PBEAlgorithm.PBE_SHA1_DES3_CBC, password2, (byte[])object3, 1, new PasswordConverter(), (PrivateKeyInfo)aSN1Value);
                        ((SET)object).insertElementAt(new SafeBag(safeBag.getBagType(), aSN1Value2, safeBag.getBagAttributes()), j);
                        ((SET)object).removeElementAt(j + 1);
                        continue;
                    }
                    if (aSN1Value3 instanceof CertBag) {
                        System.out.println("   content is CertBag");
                        aSN1Value2 = (CertBag)aSN1Value3;
                        if (((CertBag)aSN1Value2).getCertType().equals(CertBag.X509_CERT_TYPE)) {
                            aSN1Value = (OCTET_STRING)((CertBag)aSN1Value2).getInterpretedCert();
                            object3 = new FileOutputStream("cert" + n++ + ".der");
                            ((OCTET_STRING)aSN1Value).encode((OutputStream)object3);
                            ((FileOutputStream)object3).close();
                            object2 = (Certificate)ASN1Util.decode(Certificate.getTemplate(), ((OCTET_STRING)aSN1Value).toByteArray());
                            ((Certificate)object2).getInfo().print(System.out);
                            continue;
                        }
                        System.out.println("Unrecognized cert type");
                        continue;
                    }
                    System.out.println("content is ANY");
                }
                if (authenticatedSafes.safeContentsIsEncrypted(i)) {
                    authenticatedSafes2.addEncryptedSafeContents(AuthenticatedSafes.DEFAULT_KEY_GEN_ALG, password2, null, 1, (SEQUENCE)object);
                    continue;
                }
                authenticatedSafes2.addSafeContents((SEQUENCE)object);
            }
            PFX pFX2 = new PFX(authenticatedSafes2);
            pFX2.computeMacData(password2, null, 1);
            object = new FileOutputStream("newjss.p12");
            pFX2.encode((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addOptionalElement(MacData.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            ContentInfo contentInfo = (ContentInfo)sEQUENCE.elementAt(1);
            if (!contentInfo.getContentType().equals(ContentInfo.DATA)) {
                throw new InvalidBERException("ContentInfo containing AuthenticatedSafes does not have content-type DATA");
            }
            OCTET_STRING oCTET_STRING = (OCTET_STRING)contentInfo.getInterpretedContent();
            AuthenticatedSafes authenticatedSafes = (AuthenticatedSafes)ASN1Util.decode(AuthenticatedSafes.getTemplate(), oCTET_STRING.toByteArray());
            PFX pFX = new PFX((INTEGER)sEQUENCE.elementAt(0), authenticatedSafes, (MacData)sEQUENCE.elementAt(2));
            pFX.setEncodedAuthSafes(oCTET_STRING.toByteArray());
            return pFX;
        }
    }
}

