/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.util.Assert;

public class ResponseBody
implements ASN1Value {
    private SEQUENCE sequence;
    private SEQUENCE controlSequence;
    private SEQUENCE cmsSequence;
    private SEQUENCE otherMsgSequence;
    static Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private ResponseBody() {
    }

    public ResponseBody(SEQUENCE sEQUENCE, SEQUENCE sEQUENCE2, SEQUENCE sEQUENCE3) {
        this.sequence = new SEQUENCE();
        this.controlSequence = sEQUENCE;
        this.sequence.addElement(sEQUENCE);
        this.cmsSequence = sEQUENCE2;
        this.sequence.addElement(sEQUENCE2);
        this.otherMsgSequence = sEQUENCE3;
        this.sequence.addElement(sEQUENCE3);
    }

    public SEQUENCE getControlSequence() {
        return this.controlSequence;
    }

    public SEQUENCE getCmsSequence() {
        return this.cmsSequence;
    }

    public SEQUENCE getOtherMsgSequence() {
        return this.otherMsgSequence;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(TaggedAttribute.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 3);
            return new ResponseBody((SEQUENCE)sEQUENCE.elementAt(0), (SEQUENCE)sEQUENCE.elementAt(1), (SEQUENCE)sEQUENCE.elementAt(2));
        }
    }
}

