/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.mozilla.jss.tests.Constants;

public abstract class ClassServer
implements Runnable {
    private ServerSocket server = null;
    private Vector supportedCiphers = new Vector();

    protected ClassServer(ServerSocket serverSocket) {
        this.server = serverSocket;
        this.newListener();
    }

    public void run() {
        Socket socket = null;
        boolean bl = true;
        while (bl) {
            try {
                socket = this.server.accept();
            }
            catch (Exception exception) {
                System.exit(1);
            }
            this.newListener();
            try {
                InputStream inputStream = socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string.equals("null")) {
                    bl = false;
                } else if (string != null) {
                    this.supportedCiphers.add(string);
                }
                socket.close();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            System.exit(1);
        }
        System.out.println("Server exiting");
        System.out.println("--------------------------------------------------------");
        System.out.println("Summary of JSS client to JSSE server communication test :");
        System.out.println("--------------------------------------------------------");
        System.out.println("supportedCiphers.size " + this.supportedCiphers.size());
        System.out.println("Constants.jssCiphersSuites " + Constants.jssCipherSuites.length);
        for (int i = 0; i < this.supportedCiphers.size() - 1; ++i) {
            System.out.print(i + " SC " + new Integer((String)this.supportedCiphers.elementAt(i)));
            for (int j = 0; j < Constants.jssCipherSuites.length; ++j) {
                if (new Integer((String)this.supportedCiphers.elementAt(i)) != Constants.jssCipherSuites[j].value) continue;
                System.out.print(" JSSC ");
                System.out.println(" [" + i + "]\t" + Constants.jssCipherSuites[j].name);
                System.out.flush();
            }
        }
        System.out.println("--------------------------------------------------------");
        System.out.flush();
        if (!bl) {
            System.exit(0);
        }
    }

    private void newListener() {
        new Thread(this).start();
    }
}

