/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Base64OutputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final int WOULD_BLOCK = -2;
    private static int[] table;
    private int prev;
    private int savedPrev;
    private int state = 1;
    private int savedState;

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long skip(long l) throws IOException {
        long l2;
        for (l2 = 0L; l2 < l && this.read() != -1; ++l2) {
        }
        return l2;
    }

    private int read(boolean bl) throws IOException {
        int n = 0;
        boolean bl2 = false;
        block7: while (!bl2) {
            if (this.in.available() < 1 && !bl) {
                return -2;
            }
            int n2 = this.in.read();
            switch (this.state) {
                case 1: {
                    if (n2 == -1) {
                        this.state = 5;
                        return -1;
                    }
                    if (n2 == 61) {
                        this.state = 5;
                        throw new IOException("Invalid pad character");
                    }
                    if (table[n2] == -1) continue block7;
                    this.prev = n2;
                    this.state = 2;
                    continue block7;
                }
                case 2: {
                    if (n2 == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (n2 == 61) {
                        this.state = 5;
                        throw new IOException("Invalid pad character");
                    }
                    if (table[n2] == -1) continue block7;
                    n = table[this.prev] << 2 | (table[n2] & 0x30) >> 4;
                    this.prev = n2;
                    this.state = 3;
                    bl2 = true;
                    continue block7;
                }
                case 3: {
                    if (n2 == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (n2 == 61) {
                        this.state = 5;
                        return -1;
                    }
                    if (table[n2] == -1) continue block7;
                    n = (table[this.prev] & 0xF) << 4 | (table[n2] & 0x3C) >> 2;
                    this.prev = n2;
                    this.state = 4;
                    bl2 = true;
                    continue block7;
                }
                case 4: {
                    if (n2 == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (n2 == 61) {
                        this.state = 5;
                        return -1;
                    }
                    if (table[n2] == -1) continue block7;
                    n = (table[this.prev] & 3) << 6 | table[n2];
                    this.state = 1;
                    bl2 = true;
                    continue block7;
                }
                case 5: {
                    return -1;
                }
            }
            Assert._assert(false);
        }
        return n;
    }

    public int read() throws IOException {
        return this.read(true);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        while (n3 < n2) {
            int n4 = this.read(n3 == 0);
            if (n4 == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            if (n4 == -2) {
                Assert._assert(n3 > 0);
                return n3;
            }
            Assert._assert(n4 >= 0 && n4 <= 255);
            byArray[n + n3++] = (byte)n4;
        }
        return n3;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int n) {
        this.in.mark(n);
        this.savedPrev = this.prev;
        this.savedState = this.state;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
        this.prev = this.savedPrev;
        this.state = this.savedState;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        String string = stringArray[0];
        String string2 = string.concat(".b64");
        String string3 = string.concat(".recov");
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(new PrintStream(byteArrayOutputStream2), 18);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, 1024)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            base64OutputStream.write(byArray, 0, n);
        }
        base64OutputStream.close();
        byteArrayOutputStream.close();
        Base64InputStream base64InputStream = new Base64InputStream(new ByteArrayInputStream(byteArrayOutputStream2.toByteArray()));
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        while ((n = base64InputStream.read(byArray, 0, 1024)) != -1) {
            byteArrayOutputStream3.write(byArray, 0, n);
        }
        byteArrayOutputStream3.close();
        if (!Arrays.equals(byteArrayOutputStream.toByteArray(), byteArrayOutputStream3.toByteArray())) {
            throw new Exception("Did not recover original data");
        }
    }

    static {
        int n;
        int n2;
        table = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            Base64InputStream.table[n2] = -1;
        }
        n2 = 0;
        for (n = 65; n <= 90; ++n) {
            Base64InputStream.table[n] = n2++;
        }
        for (n = 97; n <= 122; ++n) {
            Base64InputStream.table[n] = n2++;
        }
        for (n = 48; n <= 57; ++n) {
            Base64InputStream.table[n] = n2++;
        }
        Base64InputStream.table[43] = 62;
        Base64InputStream.table[47] = 63;
    }
}

