/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.UnrecoverableAckFailureException;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class StompSubscriberSession
implements MessageListener {
    private Logger _logger = null;
    private String _subid = null;
    private Session _session = null;
    private MessageConsumer _subscriber = null;
    private StompOutputHandler _out = null;
    private ArrayList<Message> _unacked = new ArrayList();
    private String _duraName = null;
    private StompConnection _stompc;
    private StompBridgeResources _sbr = null;
    private boolean _clientack = false;
    private int _ackfailureCount = 0;
    private int MAX_CONSECUTIVE_ACK_FAILURES = 3;

    public StompSubscriberSession(String id, int ackMode, StompConnection sc) throws Exception {
        this._stompc = sc;
        this._subid = id;
        this._sbr = StompServer.getStompBridgeResources();
        this._session = sc.getConnection().createSession(false, ackMode);
        this._clientack = this._session.getAcknowledgeMode() == 2;
    }

    public void createSubscriber(Destination dest, String selector, String duraname, boolean nolocal, StompOutputHandler out) throws Exception {
        this._logger = StompServer.logger();
        if (this._subscriber != null) {
            throw new IllegalStateException("createSubscriber(): Unexpected call");
        }
        this._out = out;
        if (dest instanceof Queue) {
            this._subscriber = this._session.createConsumer(dest, selector);
        } else if (duraname != null) {
            this._subscriber = this._session.createDurableSubscriber((Topic)dest, duraname, selector, nolocal);
            this._duraName = duraname;
        } else {
            this._subscriber = this._session.createConsumer(dest, selector, nolocal);
        }
        this._subscriber.setMessageListener(this);
    }

    public void closeSubscriber() throws Exception {
        if (this._subscriber != null) {
            this._subscriber.close();
        }
    }

    public Session getJMSSession() {
        return this._session;
    }

    public String getDuraName() {
        return this._duraName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message msg) {
        String msgid = "";
        try {
            if (this._clientack) {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.add(msg);
                }
            }
            msgid = msg.getJMSMessageID();
            this._out.sendToClient(this._stompc.toStompFrameMessage(msg, this._subid, this._session));
        }
        catch (Throwable t) {
            try {
                block16: {
                    Object[] eparam = new String[]{msgid, this._subid, t.getMessage()};
                    if (t instanceof ClosedChannelException) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", eparam));
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.initCause(t);
                        throw re;
                    }
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", eparam), t);
                    StompFrameMessage err = null;
                    try {
                        err = StompProtocolHandler.toStompErrorMessage("Subscriber[" + this._subid + "].onMessage", t, true);
                    }
                    catch (Throwable tt) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3004", t.getMessage()), tt);
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.initCause(t);
                        throw re;
                    }
                    try {
                        this._out.sendToClient(err);
                    }
                    catch (Throwable ee) {
                        if (ee instanceof ClosedChannelException) {
                            this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()));
                            break block16;
                        }
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()), ee);
                    }
                }
                RuntimeException re = new RuntimeException(t.getMessage());
                re.initCause(t);
                throw re;
            }
            catch (Throwable throwable) {
                try {
                    this.closeSubscriber();
                }
                catch (Exception e) {
                    this._logger.log(Level.FINE, "Close subscriber " + this + " failed:" + e.getMessage(), e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String msgid) throws Exception {
        if (this._session.getAcknowledgeMode() != 2) {
            throw new JMSException(this._sbr.getKString("BSS4027", msgid, this._subid));
        }
        ArrayList<Message> arrayList = this._unacked;
        synchronized (arrayList) {
            Message msg = null;
            int end = this._unacked.size() - 1;
            boolean found = false;
            int i = 0;
            for (i = end; i >= 0; --i) {
                msg = this._unacked.get(i);
                if (!msgid.equals(msg.getJMSMessageID())) continue;
                try {
                    ((MessageImpl)msg).acknowledgeUpThroughThisMessage();
                    this._ackfailureCount = 0;
                }
                catch (Exception e) {
                    ++this._ackfailureCount;
                    UnrecoverableAckFailureException ex = null;
                    if (e instanceof JMSException && this._session instanceof SessionImpl && ((SessionImpl)((Object)this._session))._appCheckRemoteException((JMSException)e)) {
                        ex = new UnrecoverableAckFailureException("An unrecoverable ACK failure has occurred in subscriber " + this);
                        ((JMSException)ex).setLinkedException(e);
                        throw ex;
                    }
                    if (this._ackfailureCount > this.MAX_CONSECUTIVE_ACK_FAILURES) {
                        ex = new UnrecoverableAckFailureException("Maximum consecutive ACK failures " + this.MAX_CONSECUTIVE_ACK_FAILURES + " has occurred in subscriber " + this);
                        ((JMSException)ex).setLinkedException(e);
                        throw ex;
                    }
                    throw e;
                }
                found = true;
                break;
            }
            if (found) {
                for (int j = 0; j <= i; ++j) {
                    this._unacked.remove(0);
                }
                return;
            }
        }
        throw new JMSException(this._sbr.getKString("BSS4028", msgid, this._subid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            this._subscriber.close();
        }
        catch (Exception exception) {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
        finally {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
    }
}

