/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.UserProperties;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;
import java.util.Properties;

public class BrokerListProperties
extends UserProperties {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static final String PROP_NAME_BROKER_BASENAME = "broker";
    private static final String PROP_NAME_BROKER_COUNT = "broker.count";
    private static final String PROP_NAME_BROKER_KEY_PREFIX = "key";
    private static final String PROP_NAME_BROKER_RECV_TIMEOUT_PREFIX = "receiveTimeout";
    private static final String PROP_NAME_BROKER_USERNAME_PREFIX = "userName";
    private static final String PROP_NAME_BROKER_PASSWD_PREFIX = "password";
    private static final String PROP_NAME_BROKER_ATTR_PREFIX = "attrs";
    private boolean DEBUG = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerListProperties() {
        this.setProperty(PROP_NAME_VERSION, "2.0");
    }

    public String getVersion() {
        String val = this.getProperty(PROP_NAME_VERSION);
        return val;
    }

    public int getBrokerCount() {
        int ret;
        String val = this.getProperty(PROP_NAME_BROKER_COUNT);
        if (val == null || val.equals("")) {
            return 0;
        }
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public BrokerAdmin[] getBrokerAdmin() throws BrokerAdminException {
        int count = this.getBrokerCount();
        if (count <= 0) {
            return null;
        }
        BrokerAdmin[] baArray = new BrokerAdmin[count];
        for (int i = 0; i < count; ++i) {
            baArray[i] = this.getBrokerAdmin(i);
        }
        return baArray;
    }

    public BrokerAdmin getBrokerAdmin(int index) throws BrokerAdminException {
        Properties brokerAttrs = new Properties();
        String basePropName = PROP_NAME_BROKER_BASENAME + new Integer(index).toString() + ".";
        String keyPropName = basePropName + PROP_NAME_BROKER_KEY_PREFIX;
        String keyValue = this.getProperty(keyPropName, null);
        String timeoutPropName = basePropName + PROP_NAME_BROKER_RECV_TIMEOUT_PREFIX;
        long timeout = -1L;
        String usernamePropName = basePropName + PROP_NAME_BROKER_USERNAME_PREFIX;
        String usernameValue = this.getProperty(usernamePropName, "");
        String passwdPropName = basePropName + PROP_NAME_BROKER_PASSWD_PREFIX;
        String passwdValue = this.getProperty(passwdPropName, "");
        String brokerAttrsStr = basePropName + PROP_NAME_BROKER_ATTR_PREFIX + ".";
        int brokerAttrsLen = brokerAttrsStr.length();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith(brokerAttrsStr)) continue;
            String newPropName = propName.substring(brokerAttrsLen);
            String value = this.getProperty(propName);
            brokerAttrs.setProperty(newPropName, value);
        }
        BrokerAdmin ba = new BrokerAdmin(brokerAttrs, usernameValue, passwdValue, timeout);
        if (keyValue != null) {
            ba.setKey(keyValue);
        }
        return ba;
    }

    public void addBrokerAdmin(BrokerAdmin ba) {
        int index = this.getBrokerCount();
        if (this.DEBUG) {
            System.err.println("Setting properties:");
        }
        String basePropName = PROP_NAME_BROKER_BASENAME + new Integer(index).toString() + ".";
        String keyPropName = basePropName + PROP_NAME_BROKER_KEY_PREFIX;
        String keyValue = ba.getKey();
        this.setProperty(keyPropName, keyValue);
        String usernamePropName = basePropName + PROP_NAME_BROKER_USERNAME_PREFIX;
        String usernameValue = ba.getUserName();
        this.setProperty(usernamePropName, usernameValue);
        String passwdPropName = basePropName + PROP_NAME_BROKER_PASSWD_PREFIX;
        String passwdValue = ba.getPassword();
        this.setProperty(passwdPropName, passwdValue);
        String brokerAttrsStr = basePropName + PROP_NAME_BROKER_ATTR_PREFIX + ".";
        Properties brokerAttrs = ba.getBrokerAttrs();
        Enumeration<?> e = brokerAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String newValue = brokerAttrs.getProperty(propName);
            String newPropName = brokerAttrsStr + propName;
            this.setProperty(newPropName, newValue);
        }
        this.setProperty(PROP_NAME_BROKER_COUNT, new Integer(++index).toString());
    }

    @Override
    public Object setProperty(String key, String value) {
        if (this.DEBUG) {
            System.err.println("\tSetting property: " + key + "=" + value);
        }
        return super.setProperty(key, value);
    }

    @Override
    public void load() throws UserPropertiesException, SecurityException {
        super.load();
        String v = this.getVersion();
        if (v == null) {
            return;
        }
        this.checkVersion(v, "2.0", "2.0");
    }

    private void checkVersion(String fileVersionStr, String expectedVersionStr, String firstVersionStr) throws UserPropertiesException {
        double fileVersion2;
        double firstVersion2;
        double expectedVersion2;
        try {
            expectedVersion2 = Double.parseDouble(expectedVersionStr);
        }
        catch (NumberFormatException nfe) {
            double expectedVersion2 = 0.0;
            UserPropertiesException upe = new UserPropertiesException(acr.getString("A3080", expectedVersionStr));
            throw upe;
        }
        try {
            firstVersion2 = Double.parseDouble(firstVersionStr);
        }
        catch (NumberFormatException nfe) {
            double firstVersion2 = 0.0;
            UserPropertiesException upe = new UserPropertiesException(acr.getString("A3080", firstVersionStr));
            throw upe;
        }
        try {
            fileVersion2 = Double.parseDouble(fileVersionStr);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[4];
            double fileVersion2 = 0.0;
            args[0] = this.getAbsoluteFileName();
            args[1] = PROP_NAME_VERSION;
            args[2] = fileVersionStr;
            args[3] = expectedVersionStr;
            String s = acr.getString("A3081", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
        if (fileVersion2 < firstVersion2) {
            Object[] args = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = acr.getString("A3081", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
        if (fileVersion2 > expectedVersion2) {
            Object[] args = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = acr.getString("A3081", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
    }
}

