/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.bridgemgr;

import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrException;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrHelpPrinter;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrOptionParser;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrOptions;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrProperties;
import com.sun.messaging.bridge.admin.bridgemgr.CmdRunner;
import com.sun.messaging.bridge.admin.bridgemgr.Globals;
import com.sun.messaging.bridge.admin.bridgemgr.resources.BridgeAdminResources;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.util.options.OptionException;
import java.util.Enumeration;
import java.util.Properties;

public class BridgeMgr
implements BridgeMgrOptions {
    private static BridgeAdminResources ar = Globals.getBridgeAdminResources();

    public static void main(String[] args) {
        BridgeMgrHelpPrinter hp;
        int exitcode = 0;
        if (BridgeMgr.silentModeOptionSpecified(args)) {
            Globals.setSilentMode(true);
        }
        if (BridgeMgr.shortHelpOptionSpecified(args)) {
            hp = new BridgeMgrHelpPrinter();
            hp.printShortHelp(0);
        } else if (BridgeMgr.longHelpOptionSpecified(args)) {
            hp = new BridgeMgrHelpPrinter();
            hp.printLongHelp();
        }
        if (BridgeMgr.versionOptionSpecified(args)) {
            CommonCmdRunnerUtil.printBanner();
            CommonCmdRunnerUtil.printVersion();
            System.exit(0);
        }
        BridgeMgrProperties bridgeMgrProps = null;
        try {
            bridgeMgrProps = BridgeMgrOptionParser.parseArgs(args);
        }
        catch (OptionException e) {
            CommonCmdRunnerUtil.handleArgsParsingExceptions(e, "-p", "imqbridgemgr");
            System.exit(1);
        }
        try {
            BridgeMgr.checkOptions(bridgeMgrProps);
        }
        catch (BridgeMgrException ome) {
            BridgeMgr.handleCheckOptionsExceptions(ome);
            System.exit(1);
        }
        Properties sysProps = bridgeMgrProps.getSysProps();
        if (sysProps != null && sysProps.size() > 0) {
            Enumeration<?> e = sysProps.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = sysProps.getProperty(name);
                if (bridgeMgrProps.adminDebugModeSet()) {
                    Globals.stdOutPrintln("Setting system property: " + name + "=" + value);
                }
                try {
                    System.setProperty(name, value);
                }
                catch (Exception ex) {
                    Globals.stdErrPrintln("Failed to set system property: " + name + "=" + value);
                    Globals.stdErrPrintln(ex.toString());
                }
            }
        }
        CmdRunner cmdRunner = new CmdRunner(bridgeMgrProps);
        exitcode = cmdRunner.runCommand();
        System.exit(exitcode);
    }

    private static void checkOptions(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        String numRetriesStr;
        String cmd;
        if (bridgeMgrProps.debugModeSet() || bridgeMgrProps.noCheckModeSet()) {
            if (bridgeMgrProps.adminDebugModeSet()) {
                Globals.stdOutPrintln("Option checking turned off.");
            }
            return;
        }
        if (bridgeMgrProps.adminDebugModeSet()) {
            Globals.stdErrPrintln("BridgeMgrProperties dump:");
            bridgeMgrProps.list(System.err);
            Globals.stdErrPrintln("-------------\n");
            Globals.stdErrPrintln("Command: " + bridgeMgrProps.getCommand());
            Globals.stdErrPrintln("Command Argument: " + bridgeMgrProps.getCommandArg());
            Globals.stdErrPrintln("Broker Host/Port: " + bridgeMgrProps.getBrokerHostPort());
            Globals.stdErrPrintln("Admin User ID: " + bridgeMgrProps.getAdminUserId());
            Globals.stdErrPrintln("Admin User Password: " + bridgeMgrProps.getAdminPasswd());
        }
        if ((cmd = bridgeMgrProps.getCommand()) == null) {
            BridgeMgrException objMgrEx = new BridgeMgrException(10000);
            objMgrEx.setProperties(bridgeMgrProps);
            throw objMgrEx;
        }
        if (cmd.equals("list")) {
            BridgeMgr.checkList(bridgeMgrProps);
        } else if (cmd.equals("pause")) {
            BridgeMgr.checkPause(bridgeMgrProps);
        } else if (cmd.equals("resume")) {
            BridgeMgr.checkResume(bridgeMgrProps);
        } else if (cmd.equals("start")) {
            BridgeMgr.checkStart(bridgeMgrProps);
        } else if (cmd.equals("stop")) {
            BridgeMgr.checkStop(bridgeMgrProps);
        } else if (!bridgeMgrProps.debugModeSet() || !cmd.equals("debug")) {
            BridgeMgrException objMgrEx = new BridgeMgrException(10001);
            objMgrEx.setProperties(bridgeMgrProps);
            throw objMgrEx;
        }
        String recvTimeoutStr = bridgeMgrProps.getProperty("receiveTimeout");
        if (recvTimeoutStr != null) {
            try {
                int timeout = BridgeMgr.checkIntegerValue(bridgeMgrProps, "receiveTimeout", recvTimeoutStr);
            }
            catch (Exception e) {
                BridgeMgrException bce = new BridgeMgrException(10004);
                bce.setProperties(bridgeMgrProps);
                bce.setErrorString(recvTimeoutStr);
                throw bce;
            }
        }
        if ((numRetriesStr = bridgeMgrProps.getProperty("numRetries")) != null) {
            try {
                int numRetries = BridgeMgr.checkIntegerValue(bridgeMgrProps, "numRetries", numRetriesStr);
            }
            catch (Exception e) {
                BridgeMgrException bce = new BridgeMgrException(10005);
                bce.setProperties(bridgeMgrProps);
                bce.setErrorString(numRetriesStr);
                throw bce;
            }
        }
    }

    private static void checkList(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProps, CMD_LIST_VALID_CMDARGS);
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProps);
            BridgeMgr.checkLinkName(bridgeMgrProps);
        }
    }

    private static void checkPause(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProps, CMD_PAUSE_VALID_CMDARGS);
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProps);
            BridgeMgr.checkLinkName(bridgeMgrProps);
        }
    }

    private static void checkResume(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProps, CMD_RESUME_VALID_CMDARGS);
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProps);
            BridgeMgr.checkLinkName(bridgeMgrProps);
        }
    }

    private static void checkStart(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProps, CMD_START_VALID_CMDARGS);
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProps);
            BridgeMgr.checkLinkName(bridgeMgrProps);
        }
    }

    private static void checkStop(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProps, CMD_STOP_VALID_CMDARGS);
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProps);
            BridgeMgr.checkLinkName(bridgeMgrProps);
        }
    }

    private static int checkIntegerValue(BridgeMgrProperties bridgeMgrProps, String type, String maxValue) throws BridgeMgrException {
        int iValue;
        BridgeMgrException ex = null;
        try {
            iValue = Integer.parseInt(maxValue);
            if (iValue < -1) {
                ex = new BridgeMgrException(10008);
                ex.setProperties(bridgeMgrProps);
                ex.setErrorString(type);
                throw ex;
            }
        }
        catch (Exception e) {
            ex = new BridgeMgrException(10008);
            ex.setProperties(bridgeMgrProps);
            ex.setErrorString(type);
            throw ex;
        }
        return iValue;
    }

    private static void checkCmdArg(BridgeMgrProperties bridgeMgrProps, String[] validCmdArgs) throws BridgeMgrException {
        String cmdArg = bridgeMgrProps.getCommandArg();
        if (cmdArg == null) {
            BridgeMgrException ex = new BridgeMgrException(10002);
            ex.setProperties(bridgeMgrProps);
            throw ex;
        }
        if (validCmdArgs == null) {
            return;
        }
        for (int i = 0; i < validCmdArgs.length; ++i) {
            if (!cmdArg.equals(validCmdArgs[i])) continue;
            if (cmdArg.equals("bridge") && bridgeMgrProps.getLinkName() != null) {
                BridgeMgrException ex = new BridgeMgrException(5002);
                ex.setProperties(bridgeMgrProps);
                throw ex;
            }
            return;
        }
        BridgeMgrException ex = new BridgeMgrException(10003);
        ex.setProperties(bridgeMgrProps);
        ex.setValidCmdArgs(validCmdArgs);
        throw ex;
    }

    private static void checkBridgeName(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        String bn = bridgeMgrProps.getBridgeName();
        if (bn == null || bn.trim().length() == 0) {
            BridgeMgrException ex = new BridgeMgrException(5000);
            ex.setProperties(bridgeMgrProps);
            throw ex;
        }
    }

    private static void checkLinkName(BridgeMgrProperties bridgeMgrProps) throws BridgeMgrException {
        String ln = bridgeMgrProps.getLinkName();
        if (ln == null || ln.trim().length() == 0) {
            BridgeMgrException ex = new BridgeMgrException(5001);
            ex.setProperties(bridgeMgrProps);
            throw ex;
        }
    }

    private static boolean shortHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-H") && !args[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-v") && !args[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void handleCheckOptionsExceptions(BridgeMgrException e) {
        BridgeMgrProperties bridgeMgrProps = (BridgeMgrProperties)e.getProperties();
        String cmd = bridgeMgrProps.getCommand();
        String cmdArg = bridgeMgrProps.getCommandArg();
        String[] validCmdArgs = e.getValidCmdArgs();
        String[] validAttrs = e.getValidAttrs();
        String badAttr = e.getBadAttr();
        String badValue = e.getBadValue();
        String errorString = e.getErrorString();
        int type = e.getType();
        switch (type) {
            case 5000: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3000", "-bn"));
                break;
            }
            case 5001: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3001", "-ln"));
                break;
            }
            case 5002: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3002", "-ln", cmd + " " + cmdArg));
                break;
            }
            default: {
                CommonCmdRunnerUtil.handleCommonCheckOptionsExceptions(e, cmd, cmdArg, new BridgeMgrHelpPrinter());
            }
        }
    }
}

