/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.service.stomp.FrameParseException;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class StompMessageFilter
extends BaseFilter {
    protected static final String STOMP_PROTOCOL_HANDLER = "STOMP_PROTOCOL_HANDLER";
    private final String _OOMMSG = "Running low on memory while parsing stomp incoming data";
    private Logger _logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private final Attribute<PacketParseState> parsestateAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(StompMessageFilter.class + ".parsestateAttr", new NullaryFunction<PacketParseState>(){

        @Override
        public PacketParseState evaluate() {
            return new PacketParseState();
        }
    });
    private final Attribute<StompProtocolHandler> sphAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(StompMessageFilter.class + ".sphAttr", new NullaryFunction<StompProtocolHandler>(){

        @Override
        public StompProtocolHandler evaluate() {
            return new StompProtocolHandler(StompMessageFilter.this._bc, StompMessageFilter.this._jmsprop);
        }
    });

    public StompMessageFilter() {
        this._bc = StompServer._bc;
        this._jmsprop = StompServer.jmsprop;
        this._logger = StompServer.logger();
    }

    protected StompMessageFilter(BridgeContext bc, Properties props) {
        this._bc = bc;
        this._jmsprop = props;
        this._logger = StompServer.logger();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection c = ctx.getConnection();
        StompProtocolHandler sph = this.sphAttr.get(c);
        if (sph != null) {
            sph.close(false);
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this + ", conn=@" + c.hashCode() + ", sph=@" + (sph == null ? "null" : Integer.valueOf(sph.hashCode())));
        }
        return super.handleClose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        StompMessageFilter stompMessageFilter = this;
        synchronized (stompMessageFilter) {
            if (this._bc == null) {
                this._bc = StompServer._bc;
                this._jmsprop = StompServer.jmsprop;
                this._logger = StompServer.logger();
            }
            if (this._bc == null || this._jmsprop == null || this._logger == null) {
                if (this._logger != null) {
                    this._logger.log(Level.WARNING, "Stomp Service not ready yet");
                }
                throw new IOException("Stomp service not ready yet");
            }
        }
        Connection c = ctx.getConnection();
        StompProtocolHandler sph = this.sphAttr.get(c);
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, this + ", conn=@" + c.hashCode() + ", sph=@" + (sph == null ? "null" : Integer.valueOf(sph.hashCode())));
        }
        AttributeHolder ah = ctx.getAttributes();
        ah.setAttribute(STOMP_PROTOCOL_HANDLER, sph);
        Buffer input = (Buffer)ctx.getMessage();
        PacketParseState parsestate = this.parsestateAttr.get(c);
        int pos = input.position();
        StompFrameMessage _message = null;
        try {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINEST, this + ", position=" + pos + ", input=" + input);
            }
            if (parsestate.message == null) {
                if (input.remaining() >= 3) {
                    parsestate.message = StompFrameMessage.parseCommand(input);
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.log(Level.FINEST, "returned from parseCommand with " + parsestate.message);
                    }
                }
                if (parsestate.message == null) {
                    input.position(pos);
                    return ctx.getStopAction(input);
                }
            }
            if ((_message = parsestate.message).getNextParseStage() == StompFrameMessage.ParseStage.HEADER) {
                _message.parseHeader(input);
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "returned from parseHeader");
                }
            }
            if (_message.getNextParseStage() == StompFrameMessage.ParseStage.BODY) {
                _message.readBody(input);
            }
            if (_message.getNextParseStage() == StompFrameMessage.ParseStage.NULL) {
                _message.readNULL(input);
            }
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINEST, "position=" + input.position() + ", input=" + input + ", nextParseState=" + (Object)((Object)_message.getNextParseStage()));
            }
            if (_message.getNextParseStage() != StompFrameMessage.ParseStage.DONE) {
                this._logger.log(Level.FINEST, "StopAction with position=" + input.position() + ", hasRemaining=" + input.hasRemaining());
                return ctx.getStopAction(input.hasRemaining() ? input : null);
            }
            ctx.setMessage(_message);
            Exception pex = _message.getParseException();
            if (pex != null) {
                _message = pex instanceof FrameParseException ? ((FrameParseException)pex).getStompMessageERROR() : new FrameParseException(pex.getMessage(), pex).getStompMessageERROR();
                ctx.setMessage(_message);
                parsestate.reset();
                return ctx.getInvokeAction();
            }
            Buffer remainder = input.split(input.position());
            parsestate.reset();
            return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
        }
        catch (Throwable t) {
            block28: {
                if (t instanceof OutOfMemoryError) {
                    this._logger.log(Level.SEVERE, "Running low on memory while parsing stomp incoming data");
                    this._bc.handleGlobalError(t, "Running low on memory while parsing stomp incoming data");
                } else {
                    this._logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3003", t.getMessage()), t);
                }
                try {
                    if (t instanceof FrameParseException) {
                        _message = ((FrameParseException)t).getStompMessageERROR();
                        _message.setFatalERROR();
                    } else {
                        _message = new FrameParseException(t.getMessage(), t, true).getStompMessageERROR();
                    }
                }
                catch (Throwable tt) {
                    if (t instanceof OutOfMemoryError) {
                        _message = FrameParseException.OOMMSG;
                        break block28;
                    }
                    this._logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3004", t.getMessage()), tt);
                    RuntimeException re = new RuntimeException(tt.getMessage());
                    re.initCause(tt);
                    throw re;
                }
            }
            ctx.setMessage(_message);
            parsestate.reset();
            return ctx.getInvokeAction();
        }
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        StompFrameMessage message = (StompFrameMessage)ctx.getMessage();
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        ctx.setMessage(message.marshall(mm));
        return ctx.getInvokeAction();
    }

    static final class PacketParseState {
        StompFrameMessage message = null;

        PacketParseState() {
        }

        void reset() {
            this.message = null;
        }
    }
}

