/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Debug {
    public static boolean debug;
    private static boolean debugAll;
    private static boolean debugVerbose;
    private static boolean silentMode;
    private static PrintStream ps;
    private static final String READ_ONLY_PACKET = "ReadOnlyPacket";
    private static final String READ_WRITE_PACKET = "ReadWritePacket";
    private static final String PACKET_TYPE = "imq.packetType";
    public static final String WRITING_PACKET = " -------writing packet----->";
    public static final String READING_PACKET = " <------reading packet------";
    private static boolean debugTransaction;
    private static boolean useLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String msg) {
        if (debugVerbose) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(msg);
                ps.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String msg) {
        if (!silentMode) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(msg);
                ps.flush();
            }
        }
    }

    public static void printReadPacket(ReadOnlyPacket pkt) {
        String debugClass = System.getProperty(READ_ONLY_PACKET);
        boolean debugPacket = Debug.matchPacketType(pkt);
        if (debugAll || debugClass != null || debugPacket) {
            Debug.printPacket(pkt, READING_PACKET);
        }
    }

    public static void printWritePacket(ReadOnlyPacket pkt) {
        String debugClass = System.getProperty(READ_WRITE_PACKET);
        boolean debugPacket = Debug.matchPacketType(pkt);
        if (debugAll || debugClass != null || debugPacket) {
            Debug.printPacket(pkt, WRITING_PACKET);
        }
    }

    public static boolean matchPacketType(ReadOnlyPacket pkt) {
        String prop = System.getProperty(PACKET_TYPE);
        boolean isMatched = Debug.matchPacketType(pkt, prop);
        if (!isMatched && debugTransaction) {
            isMatched = Debug.isTransactedPacket(pkt);
        }
        return isMatched;
    }

    public static boolean matchPacketType(ReadOnlyPacket pkt, String prop) {
        if (prop != null) {
            StringTokenizer tokenizer = new StringTokenizer(prop, "|");
            while (tokenizer.hasMoreTokens()) {
                String packetType = tokenizer.nextToken();
                if (pkt.getPacketType() != Integer.parseInt(packetType)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPacket(ReadOnlyPacket pkt, String msg) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(new Date().toString() + msg);
            pkt.dump(ps);
            ps.flush();
        }
    }

    public static void matchAndPrintPacket(ReadOnlyPacket pkt, String pktFilter, String msg) {
        boolean shouldPrint = true;
        if (pktFilter != null) {
            shouldPrint = Debug.matchPacketType(pkt, pktFilter);
        }
        if (shouldPrint) {
            Debug.printPacket(pkt, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(Traceable traceable) {
        block6: {
            try {
                String debugClassFullName;
                String debugClassName = debugClassFullName = traceable.getClass().getName();
                String debugClass = null;
                int index = debugClassFullName.lastIndexOf(46);
                if (index >= 0) {
                    debugClassName = debugClassFullName.substring(index + 1);
                }
                debugClass = System.getProperty(debugClassName);
                if (!debugAll && debugClass == null) break block6;
                PrintStream printStream = ps;
                synchronized (printStream) {
                    ps.println("-------- begin dump class: " + traceable.getClass().getName());
                    traceable.dump(ps);
                    ps.println("^^^^^^^^ end dump class: " + traceable.getClass().getName());
                    ps.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setUseLogger(boolean b) {
        useLogger = b;
    }

    public static synchronized void printStackTrace(Throwable e) {
        if (silentMode) {
            return;
        }
        if (useLogger) {
            ExceptionHandler.rootLogger.log(Level.INFO, e.getMessage(), e);
        } else {
            e.printStackTrace(ps);
        }
    }

    public static PrintStream getPrintStream() {
        return ps;
    }

    public static boolean isTransactedPacket(ReadOnlyPacket pkt) {
        int type = pkt.getPacketType();
        switch (type) {
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 78: 
            case 79: {
                return true;
            }
        }
        return false;
    }

    static {
        String debugFile;
        debug = false;
        debugAll = false;
        debugVerbose = false;
        silentMode = false;
        ps = System.out;
        debugTransaction = false;
        useLogger = false;
        if (System.getProperty("imq.debug") != null) {
            debug = true;
        }
        if (System.getProperty("imq.debug.all") != null) {
            debug = true;
            debugVerbose = true;
            debugAll = true;
        }
        if (System.getProperty("imq.debug.verbose") != null) {
            debug = true;
            debugVerbose = true;
        }
        if ((debugFile = System.getProperty("imq.debug.file")) != null) {
            debug = true;
            try {
                FileOutputStream fos = new FileOutputStream(debugFile, false);
                ps = new PrintStream(fos, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (System.getProperty("imq.silent") != null) {
            silentMode = true;
        }
        if (System.getProperty("imq.debug.transaction") != null) {
            debug = true;
            debugTransaction = true;
        }
    }
}

