/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class TextMessageImpl
extends MessageImpl
implements TextMessage,
Traceable {
    private String text = null;

    @Override
    protected void setMessageBodyToPacket() throws JMSException {
        if (this.text == null) {
            return;
        }
        try {
            this.setMessageBody(this.text.getBytes("UTF8"));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4014");
        }
    }

    @Override
    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] body = this.getMessageBody();
            if (body != null) {
                this.text = new String(body, "UTF8");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4015");
        }
    }

    protected TextMessageImpl() throws JMSException {
        this.setPacketType(1);
    }

    @Override
    public void clearBody() throws JMSException {
        this.text = null;
        this.setMessageReadMode(false);
    }

    @Override
    public void setText(String string) throws JMSException {
        this.checkMessageAccess();
        this.text = string;
    }

    @Override
    public String getText() throws JMSException {
        return this.text;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("\nText:\t").append(this.text).append(super.toString()).toString();
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ TextMessageImpl dump ------");
        super.dump(ps);
    }
}

