/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Debug;

public class JSS_SelfServServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String fServerCertNick = null;
    private String fServerHost = "localhost";
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private boolean TestInetAddress = false;
    private boolean success = true;
    private boolean bVerbose = false;
    private boolean bBypass = false;
    public int port = 29754;
    public static String usage = "\nUSAGE:\njava JSS_SelfServServer [certdb path] [password file]\n[server_host_name] [testInetAddress: true|false]<port> <bypass> <verbose> <cert nickname> ";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_SelfServServer().doIt(stringArray);
        }
        catch (Exception exception) {
            System.out.println("JSS_SelfServServer exiting with Exception " + exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void JSS_SelfServServer() {
    }

    public void doIt(String[] stringArray) throws Exception {
        int n;
        int[] nArray;
        if (stringArray.length < 5 || stringArray[0].toLowerCase().equals("-h")) {
            System.out.println(usage);
            System.exit(1);
        }
        try {
            if (!stringArray[0].equals(".")) {
                this.fCertDbPath = stringArray[0];
            }
            if (!stringArray[1].equals("passwords")) {
                this.fPasswordFile = stringArray[1];
            }
            if (!stringArray[2].equals("localhost")) {
                this.fServerHost = stringArray[2];
            }
            if (stringArray[3].equalsIgnoreCase("true")) {
                this.TestInetAddress = true;
            }
            if (stringArray.length >= 5) {
                this.port = new Integer(stringArray[4]);
            }
            if (stringArray.length >= 6 && stringArray[5].equalsIgnoreCase("bypass")) {
                this.bBypass = true;
            }
            if (stringArray.length >= 7 && stringArray[6].equalsIgnoreCase("verbose")) {
                this.bVerbose = true;
            }
            if (stringArray.length >= 8 && !stringArray[7].equalsIgnoreCase("default")) {
                this.fServerCertNick = stringArray[7];
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing command line " + exception.getMessage());
            System.out.println(usage);
            System.exit(1);
        }
        if (this.bVerbose) {
            System.out.println("initializing JSS");
        }
        CryptoManager.initialize(this.fCertDbPath);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(this.fPasswordFile);
        cryptoToken.login(filePasswordCallback);
        if (this.bVerbose) {
            Debug.setLevel(10);
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        if (cryptoManager.FIPSEnabled()) {
            if (this.bBypass) {
                System.out.println("Bypass mode cannot be set in FIPS mode.");
                System.out.println(usage);
                System.exit(1);
            }
            SSLSocket.enableSSL2Default(false);
            SSLSocket.enableSSL3Default(false);
            nArray = SSLSocket.getImplementedCipherSuites();
            for (n = 0; n < nArray.length; ++n) {
                if (SSLSocket.isFipsCipherSuite(nArray[n])) {
                    SSLSocket.setCipherPreferenceDefault(nArray[n], true);
                    continue;
                }
                if (!SSLSocket.getCipherPreferenceDefault(nArray[n])) continue;
                SSLSocket.setCipherPreferenceDefault(nArray[n], false);
            }
        } else {
            nArray = SSLSocket.getImplementedCipherSuites();
            for (n = 0; n < nArray.length; ++n) {
                try {
                    SSLSocket.setCipherPreferenceDefault(nArray[n], true);
                    if (!this.bVerbose) continue;
                    System.out.println(Constants.cipher.cipherToString(nArray[n]) + " " + Integer.toHexString(nArray[n]));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
            }
            SSLSocket.enableSSL2Default(false);
            SSLSocket.bypassPKCS11Default(this.bBypass);
        }
        if (this.bVerbose) {
            if (this.bBypass) {
                System.out.println("SSLSockets in Bypass Mode");
            } else {
                System.out.println("SSLSockets in Non Bypass Mode");
            }
        }
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ about .... to create socket");
        }
        if (this.TestInetAddress) {
            if (this.bVerbose) {
                System.out.println("JSS_SelfServServ HostName " + this.fServerHost + " the Inet Address " + InetAddress.getByName(this.fServerHost));
            }
            serverSock = new SSLServerSocket(this.port, 5, InetAddress.getByName(this.fServerHost), null, true);
        } else {
            if (this.bVerbose) {
                System.out.println("Inet set to Null");
            }
            serverSock = new SSLServerSocket(this.port, 5, null, null, true);
        }
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ created socket");
        }
        serverSock.setSoTimeout(600000);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname("Server_ECDSA");
        serverSock.setServerCertNickname("Server_RSA");
        serverSock.setServerCertNickname("Server_DSS");
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ specified cert by nickname");
        }
        System.out.println("JSS_SelfServServ " + this.fServerHost + " ready to accept connections on " + this.port);
        int n2 = 0;
        try {
            while (true) {
                sock = (SSLSocket)serverSock.accept();
                sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
                ++n2;
                sock.setSoTimeout(300000);
                if (this.bVerbose) {
                    System.out.println("Timeout value for SSL sockets: " + sock.getSoTimeout() + " milliseconds");
                }
                readWriteThread readWriteThread2 = new readWriteThread(sock, n2);
                readWriteThread2.start();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (n2 == 0) {
                System.out.println("JSS_SelfServServ No Client attempted to connect! If test ran from all.pl check the client execution for errors.");
            } else {
                System.out.println("JSS_SelfServServ there has been " + n2 + " client " + " connections but the server Accept has timed out!");
            }
            System.out.println("JSS_SelfServServ Timeout value: " + serverSock.getSoTimeout() + " milliseconds");
            socketTimeoutException.printStackTrace();
            System.out.println("JSS_SelfServServ exiting due to timeout.");
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("JSS_SelfServServ Exception:");
            exception.printStackTrace();
            System.out.println("JSS_SelfServServ exiting.");
            System.exit(1);
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServServer boss;

        public HandshakeListener(String string, JSS_SelfServServer jSS_SelfServServer) {
            this.who = string;
            this.boss = jSS_SelfServServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket socket = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sSLSocket, int n) {
            this.socket = sSLSocket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                String string = null;
                String string2 = null;
                InputStream inputStream = this.socket.getInputStream();
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.equalsIgnoreCase("shutdown")) {
                            if (JSS_SelfServServer.this.bVerbose) {
                                System.out.println("Client told  JSS_SelfServServer to Shutdown!");
                            }
                            inputStream.close();
                            outputStream.close();
                            this.socket.close();
                            System.exit(0);
                        }
                        string2 = "ServerSSLSocket- " + this.socketCntr;
                        if (JSS_SelfServServer.this.bVerbose) {
                            System.out.println("ServerSSLSocket-" + this.socketCntr + ": Received " + string);
                            System.out.println("Sending" + string2);
                        }
                        printWriter.println(string2);
                        printWriter.flush();
                    }
                    if (JSS_SelfServServer.this.bVerbose) {
                        System.out.println("ServerSSLSocket-" + this.socketCntr + " read null aborting connection.");
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    System.out.println("ServerSSLSocket-" + this.socketCntr + " timed out: " + socketTimeoutException.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inputStream.close();
                outputStream.close();
                this.socket.close();
                if (JSS_SelfServServer.this.bVerbose) {
                    System.out.println("ServerSSLSocket " + this.socketCntr + " has been Closed.");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

