/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.util.MetricData;
import java.util.Hashtable;
import java.util.Iterator;

class BrokerMetricsMonitor
extends Monitor {
    public BrokerMetricsMonitor(Destination d) {
        super(d);
    }

    @Override
    protected Hashtable getMonitorData() {
        Hashtable<String, Long> mapMessage = new Hashtable<String, Long>();
        MetricManager mm = Globals.getMetricManager();
        MetricData md = mm.getMetrics();
        mapMessage.put("numConnections", new Long(md.nConnections));
        mapMessage.put("numMsgsIn", new Long(md.totals.messagesIn));
        mapMessage.put("numMsgsOut", new Long(md.totals.messagesOut));
        Globals.getDestinationList();
        mapMessage.put("numMsgs", new Long(DestinationList.totalCount()));
        mapMessage.put("msgBytesIn", new Long(md.totals.messageBytesIn));
        mapMessage.put("msgBytesOut", new Long(md.totals.messageBytesOut));
        mapMessage.put("numPktsIn", new Long(md.totals.packetsIn));
        mapMessage.put("numPktsOut", new Long(md.totals.packetsOut));
        mapMessage.put("pktBytesIn", new Long(md.totals.packetBytesIn));
        mapMessage.put("pktBytesOut", new Long(md.totals.packetBytesOut));
        Globals.getDestinationList();
        mapMessage.put("totalMsgBytes", new Long(DestinationList.totalBytes()));
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        long numDests = 0L;
        while (itr.hasNext()) {
            Destination oneDest = (Destination)itr.next();
            if (oneDest.isInternal() || oneDest.isAdmin() || oneDest.getDestinationName().equals("__JMQBridgeAdmin") || oneDest.getDestinationName().equals("__JMQAdmin")) continue;
            ++numDests;
        }
        mapMessage.put("numDestinations", new Long(numDests));
        return mapMessage;
    }
}

