/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class GetConnectionsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetConnectionsHandler.getDEBUG();

    public GetConnectionsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "GetConnections: " + cmd_props);
        }
        ConnectionManager cm = Globals.getConnectionManager();
        String serviceName = (String)cmd_props.get("JMQServiceName");
        Long cxnId = (Long)cmd_props.get("JMQConnectionID");
        int status = 200;
        String errMsg = null;
        Vector<Hashtable> v = new Vector<Hashtable>();
        Service s = null;
        if (serviceName != null && (s = Globals.getServiceManager().getService(serviceName)) == null) {
            status = 404;
            errMsg = this.rb.getString("B4057", serviceName);
        }
        if (status == 200) {
            ConnectionInfo cxnInfo = null;
            IMQConnection cxn2 = null;
            if (cxnId != null) {
                cxn2 = (IMQConnection)cm.getConnection(new ConnectionUID(cxnId));
                if (cxn2 != null) {
                    if (DEBUG) {
                        cxn2.dump();
                    }
                    cxnInfo = cxn2.getConnectionInfo();
                    v.add(GetConnectionsHandler.getConnectionInfoHashtable(cxnInfo));
                } else {
                    status = 404;
                    errMsg = this.rb.getString("B3130", String.valueOf(cxnId));
                }
            } else {
                List connections = cm.getConnectionList(s);
                for (IMQConnection cxn2 : connections) {
                    cxnInfo = cxn2.getConnectionInfo();
                    v.add(GetConnectionsHandler.getConnectionInfoHashtable(cxnInfo));
                }
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetConnectionsHandler.setProperties(reply, 17, status, errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static Hashtable getConnectionInfoHashtable(ConnectionInfo cxnInfo) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("cxnid", new Long(cxnInfo.uuid));
        if (cxnInfo.clientID == null) {
            cxnInfo.clientID = "";
        }
        table.put("clientid", cxnInfo.clientID);
        if (cxnInfo.remoteIP != null) {
            table.put("host", String.valueOf(IPAddress.rawIPToString(cxnInfo.remoteIP, true, true)));
        }
        table.put("port", new Integer(cxnInfo.remPort));
        table.put("user", cxnInfo.user);
        table.put("nproducers", new Integer(cxnInfo.nproducers));
        table.put("nconsumers", new Integer(cxnInfo.nconsumers));
        table.put("clientplatform", cxnInfo.userAgent);
        table.put("service", cxnInfo.service);
        return table;
    }
}

