/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jms.management.server.ConnectionNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ConnectionManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] cxnNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private long numConnectionsOpened = 0L;
    private long numConnectionsRejected = 0L;

    public Integer getNumConnections() {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        return new Integer(connections.size());
    }

    public long getNumConnectionsOpened() {
        return this.numConnectionsOpened;
    }

    public long getNumConnectionsRejected() {
        return this.numConnectionsRejected;
    }

    public void resetMetrics() {
        this.numConnectionsOpened = 0L;
        this.numConnectionsRejected = 0L;
    }

    public ObjectName[] getConnections() throws MBeanException {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        if (connections.size() == 0) {
            return null;
        }
        ObjectName[] oNames = new ObjectName[connections.size()];
        Iterator itr = connections.iterator();
        int i = 0;
        while (itr.hasNext()) {
            ConnectionInfo cxnInfo = (ConnectionInfo)itr.next();
            try {
                ObjectName o = MQObjectName.createConnectionMonitor(Long.toString(cxnInfo.uuid));
                oNames[i++] = o;
            }
            catch (Exception e) {
                this.handleOperationException("getConnections", e);
            }
        }
        return oNames;
    }

    @Override
    public String getMBeanName() {
        return "ConnectionManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1066");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyConnectionOpen(long id) {
        ConnectionNotification cn = new ConnectionNotification("mq.connection.open", this, this.sequenceNumber++);
        cn.setConnectionID(Long.toString(id));
        this.sendNotification(cn);
        ++this.numConnectionsOpened;
    }

    public void notifyConnectionClose(long id) {
        ConnectionNotification cn = new ConnectionNotification("mq.connection.close", this, this.sequenceNumber++);
        cn.setConnectionID(Long.toString(id));
        this.sendNotification(cn);
    }

    public void notifyConnectionReject(String serviceName, String userName, String remoteHostString) {
        ConnectionNotification cn = new ConnectionNotification("mq.connection.reject", this, this.sequenceNumber++);
        cn.setServiceName(serviceName);
        cn.setUserName(userName);
        cn.setRemoteHost(remoteHostString);
        this.sendNotification(cn);
        ++this.numConnectionsRejected;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[3];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConnections", Integer.class.getName(), mbr.getString("MB1059"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumConnectionsOpened", Long.class.getName(), mbr.getString("MB1060"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumConnectionsRejected", Long.class.getName(), mbr.getString("MB1061"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConnections", mbr.getString("MB1064"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
        cxnNotificationTypes = new String[]{"mq.connection.open", "mq.connection.close", "mq.connection.reject"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(cxnNotificationTypes, ConnectionNotification.class.getName(), mbr.getString("MB1067"));
        notifs = mBeanNotificationInfoArray;
    }
}

