/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class DestinationConfig
extends MQMBeanReadWrite {
    private Destination d = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] pauseSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationConfig(Destination dest) {
        this.d = dest;
    }

    public void setConsumerFlowLimit(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "ConsumerFlowLimit");
            this.d.setMaxPrefetch(l.intValue());
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("ConsumerFlowLimit", e);
        }
    }

    public Long getConsumerFlowLimit() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return new Long(di.maxPrefetch);
    }

    public Boolean getLocalOnly() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di.isDestinationLocal()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLocalOnly() {
        return this.getLocalOnly();
    }

    public void setLimitBehavior(String s) throws MBeanException {
        try {
            this.checkLimitBehavior(s);
            this.d.setLimitBehavior(DestinationUtil.toInternalDestLimitBehavior(s));
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("LimitBehavior", e);
        }
    }

    public String getLimitBehavior() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return DestinationUtil.toExternalDestLimitBehavior(di.destLimitBehavior);
    }

    private void checkLimitBehavior(String s) throws InvalidAttributeValueException {
        if (s.equals("FLOW_CONTROL") || s.equals("REMOVE_OLDEST") || s.equals("REJECT_NEWEST") || s.equals("REMOVE_LOW_PRIORITY")) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for Destination LimitBehavior specified: " + s);
    }

    public void setLocalDeliveryPreferred(Boolean b) throws MBeanException {
        try {
            int cdp = b != false ? 1 : 2;
            this.d.setClusterDeliveryPolicy(cdp);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("LocalDeliveryPreferred", e);
        }
    }

    public Boolean getLocalDeliveryPreferred() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di.destCDP == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setMaxBytesPerMsg(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxBytesPerMsg");
            SizeString ss = new SizeString();
            ss.setBytes(l);
            this.d.setMaxByteSize(ss);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxBytesPerMsg", e);
        }
    }

    public Long getMaxBytesPerMsg() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(di.maxMessageSize));
    }

    public void setMaxNumActiveConsumers(Integer i) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(i, "MaxNumActiveConsumers");
            this.d.setMaxActiveConsumers(i);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxNumActiveConsumers", e);
        }
    }

    public Integer getMaxNumActiveConsumers() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(di.maxActiveConsumers);
    }

    public void setMaxNumBackupConsumers(Integer i) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(i, "MaxNumBackupConsumers");
            this.d.setMaxFailoverConsumers(i);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxNumBackupConsumers", e);
        }
    }

    public Integer getMaxNumBackupConsumers() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(di.maxFailoverConsumers);
    }

    public void setMaxNumMsgs(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxNumMsgs");
            this.d.setCapacity(l.intValue());
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxNumMsgs", e);
        }
    }

    public Long getMaxNumMsgs() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(di.maxMessages));
    }

    public void setMaxNumProducers(Integer i) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(i, "MaxNumProducers");
            this.d.setMaxProducers(i);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxNumProducers", e);
        }
    }

    public Integer getMaxNumProducers() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(di.maxProducers);
    }

    public void setMaxTotalMsgBytes(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxTotalMsgBytes");
            SizeString ss = new SizeString();
            ss.setBytes(l);
            this.d.setByteCapacity(ss);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("MaxTotalMsgBytes", e);
        }
    }

    public Long getMaxTotalMsgBytes() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(di.maxMessageBytes));
    }

    public String getName() {
        return this.d.getDestinationName();
    }

    public String getType() {
        return this.d.isQueue() ? "q" : "t";
    }

    public void setUseDMQ(Boolean b) throws MBeanException {
        try {
            this.d.setUseDMQ(b);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("UseDMQ", e);
        }
    }

    public Boolean getUseDMQ() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        return di.useDMQ;
    }

    public void setValidateXMLSchemaEnabled(Boolean b) throws MBeanException {
        try {
            this.d.setValidateXMLSchemaEnabled(b);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("ValidateXMLSchemaEnabled", e);
        }
    }

    public Boolean getValidateXMLSchemaEnabled() {
        return this.d.validateXMLSchemaEnabled();
    }

    public void setXMLSchemaURIList(String s) throws MBeanException {
        try {
            this.d.setXMLSchemaUriList(s);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("XMLSchemaURIList", e);
        }
    }

    public String getXMLSchemaURIList() {
        return this.d.getXMLSchemaUriList();
    }

    public void setReloadXMLSchemaOnFailure(Boolean b) throws MBeanException {
        try {
            this.d.setReloadXMLSchemaOnFailure(b);
            this.d.update();
        }
        catch (Exception e) {
            this.handleSetterException("ReloadXMLSchemaOnFailure", e);
        }
    }

    public Boolean getReloadXMLSchemaOnFailure() {
        return this.d.reloadXMLSchemaOnFailure();
    }

    public void compact() throws MBeanException {
        try {
            if (!this.d.isPaused()) {
                String msg = rb.getString("B3134");
                String errMsg = rb.getString("B4161", this.getName(), msg);
                throw new BrokerException(errMsg);
            }
            this.d.compact();
        }
        catch (Exception e) {
            this.handleOperationException("compact", e);
        }
    }

    public void pause() throws MBeanException {
        this.pause("ALL");
    }

    public void pause(String pauseType) throws MBeanException {
        try {
            DestinationUtil.checkPauseType(pauseType);
            this.logger.log(8, "B1249", (Object)(this.getType() + ":" + this.getName()), pauseType);
            int pauseVal = DestinationUtil.toInternalPauseType(pauseType);
            this.d.pauseDestination(pauseVal);
        }
        catch (Exception e) {
            this.handleOperationException("pause", e);
        }
    }

    public void purge() throws MBeanException {
        try {
            String criteria_str = Globals.getBrokerResources().getKString("B1035");
            this.logger.log(8, "B1034", (Object)this.getName(), criteria_str);
            this.d.purgeDestination();
        }
        catch (Exception e) {
            this.handleOperationException("purge", e);
        }
    }

    public void resume() throws MBeanException {
        try {
            this.logger.log(8, "B1129", this.getName());
            this.d.resumeDestination();
        }
        catch (Exception e) {
            this.handleOperationException("resume", e);
        }
    }

    @Override
    public String getMBeanName() {
        return "DestinationConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1076");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationAttrUpdated(int attr, Object oldVal, Object newVal) {
        String attrName = DestinationUtil.getAttrNameFromDestinationInfoAttr(attr);
        if (attrName != null) {
            this.notifyAttrChange(attrName, newVal, oldVal);
        } else {
            this.logger.log(16, this.getMBeanDescription() + ": Unknown attribute updated in destination " + this.d.toString());
        }
    }

    private Long checkLongUnlimitedZero(Long l) {
        if (l == 0L) {
            return new Long(-1L);
        }
        return l;
    }

    private void checkLongNegOneAndUp(Long l, String attrName) throws InvalidAttributeValueException {
        if (l >= -1L) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for attribute " + attrName + ": " + l + ". Please use a positive number or -1");
    }

    private void checkIntNegOneAndUp(Integer i, String attrName) throws InvalidAttributeValueException {
        if (i >= -1) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for attribute " + attrName + ": " + i + ". Please use a positive number or -1");
    }

    private void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal.getClass().getName(), oldVal, newVal));
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[16];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConsumerFlowLimit", Long.class.getName(), mbr.getString("MB1077"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("LocalOnly", Boolean.class.getName(), mbr.getString("MB1078"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("LimitBehavior", String.class.getName(), mbr.getString("MB1079"), true, true, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("LocalDeliveryPreferred", Boolean.class.getName(), mbr.getString("MB1080"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("MaxBytesPerMsg", Long.class.getName(), mbr.getString("MB1081"), true, true, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("MaxNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1082"), true, true, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("MaxNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1083"), true, true, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("MaxNumMsgs", Long.class.getName(), mbr.getString("MB1084"), true, true, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("MaxNumProducers", Integer.class.getName(), mbr.getString("MB1085"), true, true, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("MaxTotalMsgBytes", Long.class.getName(), mbr.getString("MB1086"), true, true, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1087"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("Type", String.class.getName(), mbr.getString("MB1088"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("UseDMQ", Boolean.class.getName(), mbr.getString("MB1089"), true, true, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("ValidateXMLSchemaEnabled", Boolean.class.getName(), mbr.getString("MB1259"), true, true, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("XMLSchemaURIList", String.class.getName(), mbr.getString("MB1260"), true, true, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("ReloadXMLSchemaOnFailure", Boolean.class.getName(), mbr.getString("MB1261"), true, true, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("pauseType", String.class.getName(), mbr.getString("MB1125"));
        pauseSignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("compact", mbr.getString("MB1122"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("pause", mbr.getString("MB1123"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("pause", mbr.getString("MB1124"), pauseSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("purge", mbr.getString("MB1126"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("resume", mbr.getString("MB1127"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

