/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;

public class TakeoverCompleteHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TakeoverCompleteHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == 41) {
            if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
                this.logger.log(32, "B3100", "Received Unexpected TAKEOVER_COMPLETE from " + sender);
                return;
            }
            this.handleTakeoverComplete(sender, pkt);
        } else {
            this.logger.log(32, "B3100", "Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleTakeoverComplete(BrokerAddress sender, GPacket pkt) {
        ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(pkt);
        try {
            this.p.receivedTakeoverComplete(sender, cti);
        }
        catch (Exception e) {
            this.logger.logStack(8, "B3100", "Unable to process packet: " + pkt, (Throwable)e);
            return;
        }
    }
}

