/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.ext;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ext.JMSBGDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMSBGDAOImpl
extends BaseDAOImpl
implements JMSBGDAO {
    private String tableName = null;
    protected String insertSQL;
    protected String updateBrokerIdSQL;
    protected String deleteSQL;
    protected String selectBrokerIdSQL;
    protected String selectUpdatedTimeSQL;
    protected String selectCreatedTimeSQL;
    protected String selectNamesByBrokerIdSQL;

    public JMSBGDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQJMSBG41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("NAME").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(", ").append("UPDATED_TS").append(") VALUES ( ?, ?, ?, ?)").toString();
        this.updateBrokerIdSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?, ").append("UPDATED_TS").append(" = ? ").append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").append(Util.brokerNotTakenOverClause(dbMgr)).toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectBrokerIdSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectUpdatedTimeSQL = new StringBuffer(128).append("SELECT ").append("UPDATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectCreatedTimeSQL = new StringBuffer(128).append("SELECT ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectNamesByBrokerIdSQL = new StringBuffer(128).append("SELECT ").append("NAME").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQJMSBG41";
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, String name, Logger logger_) throws DupKeyException, Exception {
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            try {
                pstmt = conn.prepareStatement(this.insertSQL);
                pstmt.setString(1, name);
                pstmt.setString(2, dbMgr.getBrokerID());
                pstmt.setLong(3, System.currentTimeMillis());
                pstmt.setLong(4, 0L);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                this.checkDupKeyOnException(conn, name, logger_);
                throw e;
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
    }

    @Override
    public void updateBrokerId(Connection conn, String name, String newBrokerId, String expectedBrokerId, Logger logger_) throws KeyNotFoundException, StoreBeingTakenOverException, Exception {
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = conn.prepareStatement(this.updateBrokerIdSQL);
            pstmt.setString(1, newBrokerId);
            pstmt.setLong(2, System.currentTimeMillis());
            pstmt.setString(3, name);
            pstmt.setString(4, expectedBrokerId);
            if (Globals.getHAEnabled()) {
                pstmt.setString(5, dbMgr.getBrokerID());
            }
            if (pstmt.executeUpdate() == 0) {
                Util.checkBeingTakenOver(conn, dbMgr, this.logger, logger_);
                throw new KeyNotFoundException("Name " + name + " not found in store");
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
    }

    @Override
    public void delete(Connection conn, String name, Logger logger_) throws Exception {
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = conn.prepareStatement(this.deleteSQL);
            pstmt.setString(1, name);
            pstmt.setString(2, dbMgr.getBrokerID());
            if (pstmt.executeUpdate() == 0) {
                throw new KeyNotFoundException("Name " + name + " not found in store ");
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        String whereClause = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("'").toString();
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public String getBrokerId(Connection conn, String name, Logger logger_) throws Exception {
        String brokerId = null;
        Connection myconn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                myconn = conn = DBManager.getDBManager().getConnection(true);
            }
            pstmt = conn.prepareStatement(this.selectBrokerIdSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new KeyNotFoundException("Name " + name + " not found in store");
            }
            brokerId = rs.getString(1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectBrokerIdSQL + "]", rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return brokerId;
    }

    @Override
    public long getUpdatedTime(Connection conn, String name, Logger logger_) throws KeyNotFoundException, Exception {
        long updatedTime = -1L;
        Connection myconn = conn;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                myconn = conn = DBManager.getDBManager().getConnection(true);
            }
            pstmt = conn.prepareStatement(this.selectUpdatedTimeSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new KeyNotFoundException("Name " + name + " not found in store");
            }
            updatedTime = rs.getLong(1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectUpdatedTimeSQL + "]", rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return updatedTime;
    }

    @Override
    public long getCreatedTime(Connection conn, String name, Logger logger_) throws KeyNotFoundException, Exception {
        long createdTime = -1L;
        Connection myconn = conn;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                myconn = conn = DBManager.getDBManager().getConnection(true);
            }
            pstmt = conn.prepareStatement(this.selectCreatedTimeSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new KeyNotFoundException("Name " + name + " not found in store");
            }
            createdTime = rs.getLong(1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return createdTime;
    }

    @Override
    public List getNamesByBroker(Connection conn, String brokerID, Logger logger_) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection myconn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = DBManager.getDBManager().getConnection(true);
            }
            pstmt = conn.prepareStatement(this.selectNamesByBrokerIdSQL);
            pstmt.setString(1, brokerID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectNamesByBrokerIdSQL + "]", rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return list;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("JMSBridge(" + this.tableName + ")", String.valueOf(count));
        return map;
    }

    private void checkDupKeyOnException(Connection conn, String name, Logger logger_) throws DupKeyException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(this.selectCreatedTimeSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new DupKeyException("Name " + name + " already exists in DB");
            }
        }
        catch (Exception e) {
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", rbe);
            }
            if (e instanceof DupKeyException) {
                throw (DupKeyException)e;
            }
            String emsg = this.br.getKString("B4117", "Exception on checkDupKey for name " + name);
            this.logger.log(16, emsg, e);
            Util.logExt(logger_, Level.WARNING, emsg, e);
        }
    }

    private void closeSQL(ResultSet rset, PreparedStatement pstmt, Connection conn, Throwable myex, Logger logger_) {
        try {
            Util.close(rset, pstmt, conn, myex);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String emsg = "Unable to close SQL connection or statement: " + e.getMessage() + (cause == null ? "" : " - " + cause.getMessage());
            this.logger.log(16, emsg, e);
            Util.logExt(logger_, Level.WARNING, emsg, e);
        }
    }
}

