/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class Bits {
    public static byte short1(short x) {
        return (byte)(x >> 8);
    }

    public static byte short0(short x) {
        return (byte)(x >> 0);
    }

    public static byte int3(int x) {
        return (byte)(x >> 24);
    }

    public static byte int2(int x) {
        return (byte)(x >> 16);
    }

    public static byte int1(int x) {
        return (byte)(x >> 8);
    }

    public static byte int0(int x) {
        return (byte)(x >> 0);
    }

    public static byte long7(long x) {
        return (byte)(x >> 56);
    }

    public static byte long6(long x) {
        return (byte)(x >> 48);
    }

    public static byte long5(long x) {
        return (byte)(x >> 40);
    }

    public static byte long4(long x) {
        return (byte)(x >> 32);
    }

    public static byte long3(long x) {
        return (byte)(x >> 24);
    }

    public static byte long2(long x) {
        return (byte)(x >> 16);
    }

    public static byte long1(long x) {
        return (byte)(x >> 8);
    }

    public static byte long0(long x) {
        return (byte)(x >> 0);
    }

    public static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    public static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    public static int put(byte[] dst, int index, short value) {
        dst[index++] = Bits.short1(value);
        dst[index++] = Bits.short0(value);
        return index;
    }

    public static int put(byte[] dst, int index, int value) {
        dst[index++] = Bits.int3(value);
        dst[index++] = Bits.int2(value);
        dst[index++] = Bits.int1(value);
        dst[index++] = Bits.int0(value);
        return index;
    }

    public static int put(byte[] dst, int index, long value) {
        dst[index++] = Bits.long7(value);
        dst[index++] = Bits.long6(value);
        dst[index++] = Bits.long5(value);
        dst[index++] = Bits.long4(value);
        dst[index++] = Bits.long3(value);
        dst[index++] = Bits.long2(value);
        dst[index++] = Bits.long1(value);
        dst[index++] = Bits.long0(value);
        return index;
    }

    public static int put(byte[] dst, int index, byte[] value) {
        System.arraycopy(value, 0, dst, index, value.length);
        return index + value.length;
    }

    public static short getShort(byte[] buf, int index) {
        return Bits.makeShort(buf[index + 0], buf[index + 1]);
    }

    public static int getInt(byte[] buf, int index) {
        return Bits.makeInt(buf[index + 0], buf[index + 1], buf[index + 2], buf[index + 3]);
    }

    public static long getLong(byte[] buf, int index) {
        return Bits.makeLong(buf[index + 0], buf[index + 1], buf[index + 2], buf[index + 3], buf[index + 4], buf[index + 5], buf[index + 6], buf[index + 7]);
    }

    public static byte[] randomBits(int nBytes) {
        int n;
        long[] seeds = new long[]{System.currentTimeMillis(), new Object().hashCode(), Runtime.getRuntime().freeMemory(), Runtime.getRuntime().totalMemory()};
        byte[] seedbuf = new byte[seeds.length * 8];
        int i = 0;
        for (int n2 = 0; n2 < seeds.length; ++n2) {
            i = Bits.put(seedbuf, i, seeds[n2]);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] digest = md.digest(seedbuf);
        byte[] output = new byte[nBytes];
        for (n = 0; n < output.length && n < digest.length; ++n) {
            output[n] = digest[n];
        }
        if (n < output.length) {
            Random r = new Random();
            while (n < output.length) {
                output[n] = (byte)r.nextInt(127);
                ++n;
            }
        }
        return output;
    }

    public static String toHexString(byte[] buf, boolean useDelim) {
        if (buf.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        String COLON = ":";
        StringBuffer sb = new StringBuffer(3 * buf.length);
        int n = 0;
        while (n < buf.length) {
            int value = buf[n + 1] & 0xFF;
            sb.append(Integer.toHexString(value |= buf[n] << 8 & 0xFF00));
            if ((n += 2) >= buf.length || !useDelim) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        long lValue;
        int iValue;
        short sMaxValue = Short.MAX_VALUE;
        short sMinValue = Short.MIN_VALUE;
        int iMaxValue = Integer.MAX_VALUE;
        int iMinValue = Integer.MIN_VALUE;
        long lMaxValue = Long.MAX_VALUE;
        long lMinValue = Long.MIN_VALUE;
        int totalBytes = 28;
        byte[] buf = new byte[totalBytes];
        int i = 0;
        i = Bits.put(buf, i, sMaxValue);
        i = Bits.put(buf, i, iMaxValue);
        i = Bits.put(buf, i, lMaxValue);
        i = Bits.put(buf, i, sMinValue);
        i = Bits.put(buf, i, iMinValue);
        i = Bits.put(buf, i, lMinValue);
        System.out.println("Data: " + sMaxValue + " " + iMaxValue + " " + lMaxValue + " " + sMinValue + " " + iMinValue + " " + lMinValue + " " + "\n" + "Buf: " + Bits.toHexString(buf, true));
        i = 0;
        short sValue = Bits.getShort(buf, i);
        if (sValue != sMaxValue) {
            System.err.println("ERROR1 short " + sValue + "!=" + sMaxValue);
        }
        if ((iValue = Bits.getInt(buf, i += 2)) != iMaxValue) {
            System.err.println("ERROR2 int " + iValue + "!=" + iMaxValue);
        }
        if ((lValue = Bits.getLong(buf, i += 4)) != lMaxValue) {
            System.err.println("ERROR3 long " + lValue + "!=" + lMaxValue);
        }
        if ((sValue = Bits.getShort(buf, i += 8)) != sMinValue) {
            System.err.println("ERROR4 short " + sValue + "!=" + sMinValue);
        }
        if ((iValue = Bits.getInt(buf, i += 2)) != iMinValue) {
            System.err.println("ERROR5 int " + iValue + "!=" + iMinValue);
        }
        if ((lValue = Bits.getLong(buf, i += 4)) != lMinValue) {
            System.err.println("ERROR6 long " + lValue + "!=" + lMinValue);
        }
        i += 8;
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        try {
            sValue = dis.readShort();
            if (sValue != sMaxValue) {
                System.err.println("ERROR7 short " + sValue + "!=" + sMaxValue);
            }
            if ((iValue = dis.readInt()) != iMaxValue) {
                System.err.println("ERROR8 int " + iValue + "!=" + iMaxValue);
            }
            if ((lValue = dis.readLong()) != lMaxValue) {
                System.err.println("ERROR9 long " + lValue + "!=" + lMaxValue);
            }
            if ((sValue = dis.readShort()) != sMinValue) {
                System.err.println("ERROR10 short " + sValue + "!=" + sMinValue);
            }
            if ((iValue = dis.readInt()) != iMinValue) {
                System.err.println("ERROR11 int " + iValue + "!=" + iMinValue);
            }
            if ((lValue = dis.readLong()) != lMinValue) {
                System.err.println("ERROR12 long " + lValue + "!=" + lMinValue);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR13 " + e);
        }
    }
}

