/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.TabledInspector;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.admin.ServiceInfo;

public class BrokerServiceListInspector
extends TabledInspector {
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    @Override
    public String[] getColumnHeaders() {
        String[] stringArray = new String[3];
        stringArray[0] = acr.getString("A1111");
        stringArray[1] = acr.getString("A1112");
        stringArray[2] = acr.getString("A1113");
        String[] columnNames = stringArray;
        return columnNames;
    }

    @Override
    public Object getValueAtCollumn(ConsoleObj conObj, int col) {
        if (!(conObj instanceof BrokerServiceCObj)) {
            return null;
        }
        BrokerServiceCObj bSvcCObj = (BrokerServiceCObj)conObj;
        ServiceInfo svcInfo = bSvcCObj.getServiceInfo();
        if (col == 0) {
            return bSvcCObj;
        }
        if (col == 1) {
            String portStr;
            if (svcInfo.port == -1) {
                portStr = "-";
            } else if (svcInfo.dynamicPort) {
                switch (svcInfo.state) {
                    case -1: {
                        portStr = ar.getString("A1520");
                        break;
                    }
                    default: {
                        portStr = new Integer(svcInfo.port).toString() + " (" + ar.getString("A1520") + ")";
                        break;
                    }
                }
            } else {
                portStr = new Integer(svcInfo.port).toString() + " (" + ar.getString("A1521") + ")";
            }
            return portStr;
        }
        if (col == 2) {
            return BrokerAdminUtil.getServiceState(svcInfo.state);
        }
        return null;
    }
}

