/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.admin.bkrutil.AdminMQAddress;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.MessageAckThread;
import com.sun.messaging.jmq.admin.bkrutil.SSLAdminMQAddress;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import com.sun.messaging.jmq.io.MQAddress;
import java.io.EOFException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public abstract class BrokerAdminConn
implements ExceptionListener {
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";
    public static long defaultTimeout = 10000L;
    public static int defaultNumRetries = 5;
    public static final int RECONNECT_RETRIES = 5;
    public static final long RECONNECT_DELAY = 5000L;
    private String key = null;
    private String username;
    private String passwd;
    private int numRetries;
    private QueueConnectionFactory qcf;
    private QueueConnection connection = null;
    private Queue requestQueue;
    protected long timeout;
    protected static boolean debug = false;
    protected QueueSession session;
    protected TemporaryQueue replyQueue;
    protected QueueSender sender;
    protected QueueReceiver receiver;
    protected boolean isConnected = false;
    private MQAddress address = null;
    private boolean checkShutdownReply = true;
    private static final String[] savedQCFProperties = new String[]{"imqBrokerHostName", "imqBrokerHostPort"};
    private boolean adminKeyUsed = false;
    private boolean sslTransportUsed = false;
    private boolean isInitiator = false;
    private boolean isReconnect = false;
    private Vector eListeners = new Vector();
    private MessageAckThread msgAckThread = null;
    private boolean busy = false;

    public BrokerAdminConn(String brokerHost, int brokerPort) throws BrokerAdminException {
        this(brokerHost, brokerPort, null, null, -1L, false, -1, -1L);
    }

    public BrokerAdminConn(String brokerHost, int brokerPort, String username, String passwd) throws BrokerAdminException {
        this(brokerHost, brokerPort, username, passwd, -1L, false, -1, -1L);
    }

    public BrokerAdminConn(String brokerHost, int brokerPort, String username, String passwd, int timeout) throws BrokerAdminException {
        this(brokerHost, brokerPort, username, passwd, timeout, false, -1, -1L);
    }

    public BrokerAdminConn(String brokerAddress, String username, String passwd, int timeout, boolean useSSL) throws BrokerAdminException {
        this(brokerAddress, username, passwd, timeout, false, -1, -1L, useSSL);
    }

    public BrokerAdminConn(String brokerHost, int brokerPort, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay) throws BrokerAdminException {
        Properties tmpProps = new Properties();
        if (brokerHost != null) {
            tmpProps.setProperty("imqBrokerHostName", brokerHost);
        }
        if (brokerPort > 0) {
            tmpProps.setProperty("imqBrokerHostPort", String.valueOf(brokerPort));
        }
        if (reconnect) {
            tmpProps.setProperty("imqReconnectEnabled", String.valueOf(reconnect));
            tmpProps.setProperty("imqReconnectAttempts", String.valueOf(reconnectRetries));
            tmpProps.setProperty("imqReconnectInterval", String.valueOf(reconnectDelay));
        }
        this.timeout = timeout >= 0L ? timeout : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = username;
        this.passwd = passwd;
        this.createFactory(tmpProps);
    }

    public BrokerAdminConn(String brokerAddress, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay, boolean useSSL) throws BrokerAdminException {
        Properties tmpProps = new Properties();
        if (brokerAddress == null) {
            brokerAddress = "";
        }
        try {
            this.address = useSSL ? SSLAdminMQAddress.createAddress(brokerAddress) : AdminMQAddress.createAddress(brokerAddress);
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(16);
            bae.setBrokerAddress(brokerAddress);
            bae.setLinkedException(e);
            throw bae;
        }
        tmpProps.setProperty("imqAddressList", this.address.toString());
        if (reconnect) {
            tmpProps.setProperty("imqReconnectEnabled", String.valueOf(reconnect));
            tmpProps.setProperty("imqReconnectAttempts", String.valueOf(reconnectRetries));
            tmpProps.setProperty("imqReconnectInterval", String.valueOf(reconnectDelay));
        }
        this.timeout = timeout >= 0L ? timeout : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = username;
        this.passwd = passwd;
        this.createFactory(tmpProps);
    }

    public BrokerAdminConn(Properties brokerAttrs, String username, String passwd, long timeout) throws BrokerAdminException {
        this.timeout = timeout >= 0L ? timeout : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = username;
        this.passwd = passwd;
        this.createFactory(brokerAttrs);
    }

    public void setBrokerHost(String hostName) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostName", hostName);
        }
        catch (JMSException jmse) {
            BrokerAdminException bae = new BrokerAdminException(9);
            bae.setBadValue(hostName);
            bae.setLinkedException(jmse);
            throw bae;
        }
    }

    public String getBrokerAddress() {
        if (this.address != null) {
            return this.address.toString();
        }
        return this.getFactoryAttr("imqAddressList");
    }

    public String getBrokerHost() {
        if (this.address != null) {
            return this.address.getHostName();
        }
        return this.getFactoryAttr("imqBrokerHostName");
    }

    public void setBrokerPort(String port) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostPort", port);
        }
        catch (JMSException jmse) {
            BrokerAdminException bae = new BrokerAdminException(10);
            bae.setBadValue(port);
            bae.setLinkedException(jmse);
            throw bae;
        }
    }

    public String getBrokerPort() {
        if (this.address != null) {
            return new Integer(this.address.getPort()).toString();
        }
        return this.getFactoryAttr("imqBrokerHostPort");
    }

    public static void setDefaultTimeout(long defaultTimeout) {
        BrokerAdminConn.defaultTimeout = defaultTimeout;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn defaultTimeout set to: " + BrokerAdminConn.defaultTimeout);
        }
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static void setDefaultNumRetries(int defaultNumRetries) {
        BrokerAdminConn.defaultNumRetries = defaultNumRetries;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn defaultNumRetries set to: " + BrokerAdminConn.defaultNumRetries);
        }
    }

    public static long getDefaultNumRetries() {
        return defaultNumRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn num retries set to: " + this.numRetries);
        }
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String passwd) {
        this.passwd = passwd;
    }

    public String getPassword() {
        return this.passwd;
    }

    protected void setBusy(boolean b) {
        this.busy = b;
        if (debug) {
            CommonGlobals.stdOutPrintln("***** BrokerAdminConn.setBusy(): " + b);
        }
        if (!b && this.msgAckThread != null) {
            this.msgAckThread = null;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    protected void checkIfBusy() throws BrokerAdminException {
        if (this.isBusy()) {
            BrokerAdminException bae = new BrokerAdminException(13);
            bae.setBrokerAdminConn(this);
            throw bae;
        }
    }

    public void setAdminKeyUsed(boolean b) {
        this.adminKeyUsed = b;
    }

    public boolean getAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        return this.getBrokerHost() + ":" + this.getBrokerPort();
    }

    public void setSSLTransportUsed(boolean b) {
        this.sslTransportUsed = b;
    }

    public boolean getSSLTransportUsed() {
        return this.sslTransportUsed;
    }

    public void setInitiator(boolean b) {
        this.isInitiator = b;
    }

    private boolean isInitiator() {
        return this.isInitiator;
    }

    public void setCheckShutdownReply(boolean b) {
        this.checkShutdownReply = b;
    }

    public void setReconnect(boolean b) {
        this.isReconnect = b;
    }

    public boolean isReconnect() {
        return this.isReconnect;
    }

    public Properties getBrokerAttrs() {
        Properties tmpProps = new Properties();
        if (this.qcf == null) {
            return tmpProps;
        }
        for (int i = 0; i < savedQCFProperties.length; ++i) {
            String propName = savedQCFProperties[i];
            String propVal = this.getFactoryAttr(propName);
            tmpProps.setProperty(propName, propVal);
        }
        return tmpProps;
    }

    public void connect() throws BrokerAdminException {
        this.connect(null, null, false);
    }

    public void connect(String tempUsername, String tempPasswd) throws BrokerAdminException {
        this.connect(tempUsername, tempPasswd, true);
    }

    private void connect(String tempUsername, String tempPasswd, boolean useTempValues) throws BrokerAdminException {
        try {
            if (this.adminKeyUsed) {
                this.qcf.setConnectionType("ADMINKEY");
            }
            if (this.sslTransportUsed) {
                try {
                    this.qcf.setProperty("imqConnectionType", "SSL");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.setFactoryAttr("imqConnectionType", "SSL");
                }
                catch (JMSException jmse) {
                    BrokerAdminException bae = new BrokerAdminException(15);
                    bae.setBrokerHost(this.getBrokerHost());
                    bae.setBrokerPort(this.getBrokerPort());
                    bae.setLinkedException(jmse);
                    throw bae;
                }
            }
            if (debug) {
                this.printObjProperties(this.qcf);
            }
            this.connection = useTempValues ? this.qcf.createQueueConnection(tempUsername, tempPasswd) : this.qcf.createQueueConnection(this.username, this.passwd);
            this.connection.setExceptionListener(this);
            this.connection.start();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Creating queue connection");
            }
            this.session = this.connection.createQueueSession(false, 2);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Creating queue session: not transacted, auto ack");
            }
            this.requestQueue = this.session.createQueue(this.getAdminQueueDest());
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created requestQueue: " + this.requestQueue);
            }
            this.replyQueue = this.session.createTemporaryQueue();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created replyQueue: " + this.replyQueue);
            }
            this.sender = this.session.createSender(this.requestQueue);
            this.sender.setDeliveryMode(1);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created a sender: " + this.sender);
            }
            this.receiver = this.session.createReceiver(this.replyQueue);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created a receiver: " + this.receiver);
            }
        }
        catch (JMSException jmse) {
            BrokerAdminException bae;
            if (jmse instanceof JMSSecurityException) {
                String errorCode = jmse.getErrorCode();
                bae = "C4060".equals(errorCode) ? new BrokerAdminException(11) : new BrokerAdminException(12);
            } else {
                bae = new BrokerAdminException(0);
            }
            bae.setBrokerHost(this.getBrokerHost());
            bae.setBrokerPort(this.getBrokerPort());
            bae.setLinkedException(jmse);
            throw bae;
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            bae.setBrokerHost(this.getBrokerHost());
            bae.setBrokerPort(this.getBrokerPort());
            throw bae;
        }
    }

    public abstract String getAdminQueueDest();

    public abstract String getAdminMessagePropNameMessageType();

    public abstract String getAdminMessagePropNameErrorString();

    public abstract String getAdminMessagePropNameStatus();

    public abstract int getAdminMessageStatusOK();

    public abstract int getAdminMessageTypeSHUTDOWN_REPLY();

    public abstract CommonCmdStatusEvent newCommonCmdStatusEvent(int var1);

    public abstract CommonCmdStatusEvent getCurrentStatusEvent();

    public abstract void clearStatusEvent();

    private void printObjProperties(AdministeredObject obj) {
        CommonGlobals.stdOutPrintln("Connection Factory Object properties:");
        Properties props = obj.getConfiguration();
        Enumeration e = obj.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propLabel;
            String propName = (String)e.nextElement();
            String value = props.getProperty(propName);
            try {
                propLabel = obj.getPropertyLabel(propName);
            }
            catch (Exception ex) {
                propLabel = "UNKNOWN";
            }
            String printLabel = propName + " [" + propLabel + "]";
            CommonGlobals.stdOutPrintln("\t" + printLabel + " = " + value);
        }
        CommonGlobals.stdOutPrintln("");
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setIsConnected(boolean b) {
        this.isConnected = b;
    }

    private String getErrorMessage(Message mesg) {
        String error;
        block4: {
            error = null;
            try {
                error = mesg.getStringProperty(this.getAdminMessagePropNameErrorString());
            }
            catch (JMSException jmse) {
                if (debug) {
                    CommonGlobals.stdErrPrint("Failed to retrieve the error message: ");
                    CommonGlobals.stdErrPrintln(jmse.getMessage());
                    jmse.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!debug) break block4;
                CommonGlobals.stdErrPrintln("Exception caught: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return error;
    }

    public void forceClose() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.isConnected = false;
            if (this.msgAckThread != null) {
                this.msgAckThread.stop();
                this.msgAckThread = null;
                if (debug) {
                    CommonGlobals.stdOutPrintln("***** Stopped msgAckThread thread...");
                }
            }
        }
        catch (JMSException jmse) {
            CommonGlobals.stdErrPrintln("JMSException caught: " + jmse.getMessage());
            jmse.printStackTrace();
        }
    }

    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            if (this.msgAckThread != null) {
                this.msgAckThread.stop();
                this.msgAckThread = null;
                if (debug) {
                    CommonGlobals.stdOutPrintln("***** Stopped msgAckThread thread...");
                }
            }
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closing sender and receiver...");
            }
            this.sender.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed sender.");
            }
            this.receiver.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed receiver.");
            }
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closing queue session and queue connection...");
            }
            this.session.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed session.");
            }
        }
        catch (JMSException jmse) {
            CommonGlobals.stdErrPrintln("JMSException caught: " + jmse.getMessage());
            jmse.printStackTrace();
        }
        catch (Exception e) {
            CommonGlobals.stdErrPrintln("Exception caught: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                if (debug) {
                    CommonGlobals.stdOutPrintln("***** Closed connection.");
                }
            }
            this.isConnected = false;
            this.setBusy(false);
        }
        catch (JMSException jmse) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            } else {
                CommonGlobals.stdErrPrintln("JMSException caught: " + jmse.getMessage());
                jmse.printStackTrace();
            }
        }
        catch (Exception e) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            }
            CommonGlobals.stdErrPrintln("Exception caught: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setFactoryAttr(String propName, String propVal) throws JMSException {
        if (this.qcf == null) {
            return;
        }
        this.qcf.setProperty(propName, propVal);
    }

    private String getFactoryAttr(String propName) {
        String s;
        if (this.qcf == null) {
            return null;
        }
        try {
            s = this.qcf.getProperty(propName);
        }
        catch (JMSException jmse) {
            s = null;
        }
        return s;
    }

    private void createFactory(Properties brokerAttrs) throws BrokerAdminException {
        this.qcf = new QueueConnectionFactory();
        try {
            this.qcf.setConnectionType("ADMIN");
            Enumeration<?> e = brokerAttrs.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String value = brokerAttrs.getProperty(propName);
                if (value == null) continue;
                this.qcf.setProperty(propName, value);
            }
        }
        catch (JMSException jmse) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(jmse);
            bae.setBrokerHost(this.getBrokerHost());
            bae.setBrokerPort(this.getBrokerPort());
            throw bae;
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            bae.setBrokerHost(this.getBrokerHost());
            bae.setBrokerPort(this.getBrokerPort());
            throw bae;
        }
        if (debug) {
            CommonGlobals.stdOutPrintln("***** BrokerAdminConn instance: " + this.getKey());
            CommonGlobals.stdOutPrintln("BrokerAdminConn created with timeout set to: " + this.timeout / 1000L + " seconds");
            CommonGlobals.stdOutPrintln("BrokerAdminConn created with num retries set to: " + this.numRetries);
        }
    }

    protected Message receiveCheckMessageTimeout(boolean isShutdownReply) throws BrokerAdminException {
        return this.receiveCheckMessageTimeout(isShutdownReply, true);
    }

    protected Message receiveCheckMessageTimeout(boolean isShutdownReply, boolean waitForResponse) throws BrokerAdminException {
        ObjectMessage mesg = null;
        long incrTimeout = this.timeout;
        int localNumRetries = 0;
        try {
            while (localNumRetries <= this.numRetries && (mesg = (ObjectMessage)this.receiver.receive(incrTimeout)) == null) {
                if (isShutdownReply) {
                    this.isConnected = false;
                    break;
                }
                incrTimeout += this.timeout;
                if (++localNumRetries <= this.numRetries) {
                    CommonCmdStatusEvent cse = this.newCommonCmdStatusEvent(10000);
                    cse.setNumRetriesAttempted(localNumRetries);
                    cse.setMaxNumRetries(this.numRetries);
                    cse.setRetryTimeount(incrTimeout / 1000L);
                    this.fireAdminEventDispatched(cse);
                    continue;
                }
                this.msgAckThread = new MessageAckThread(this);
                this.msgAckThread.start();
                BrokerAdminException bae = waitForResponse ? new BrokerAdminException(6) : new BrokerAdminException(14);
                throw bae;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return mesg;
    }

    protected void checkReplyTypeStatus(Message mesg, int msgType, String msgTypeString) throws BrokerAdminException {
        int actualReplyStatus;
        int actualMsgType;
        if (mesg == null && this.checkShutdownReply && msgType == this.getAdminMessageTypeSHUTDOWN_REPLY()) {
            this.isConnected = false;
            return;
        }
        try {
            actualMsgType = mesg.getIntProperty(this.getAdminMessagePropNameMessageType());
        }
        catch (JMSException jmse) {
            BrokerAdminException bae = new BrokerAdminException(4);
            bae.setLinkedException(jmse);
            throw bae;
        }
        try {
            actualReplyStatus = mesg.getIntProperty(this.getAdminMessagePropNameStatus());
        }
        catch (JMSException jmse) {
            BrokerAdminException bae = new BrokerAdminException(5);
            bae.setLinkedException(jmse);
            throw bae;
        }
        if (debug) {
            CommonGlobals.stdOutPrintln("\tReplyMsgType=" + actualMsgType + "(expecting " + msgType + "[" + msgTypeString + "]), ReplyStatus=" + actualReplyStatus);
        }
        if (msgType == actualMsgType && actualReplyStatus == this.getAdminMessageStatusOK()) {
            if (msgType == this.getAdminMessageTypeSHUTDOWN_REPLY()) {
                this.isConnected = false;
            }
            return;
        }
        String errorStr = this.getErrorMessage(mesg);
        if (debug) {
            CommonGlobals.stdOutPrintln("\tJMQ_ERROR_STRING=" + errorStr);
        }
        BrokerAdminException bae = new BrokerAdminException(2);
        bae.setBrokerErrorStr(errorStr);
        bae.setReplyMsgType(actualMsgType);
        bae.setReplyStatus(actualReplyStatus);
        bae.setReplyMsg(mesg);
        throw bae;
    }

    protected void handleSendExceptions(Exception e) throws BrokerAdminException {
        if (e instanceof BrokerAdminException) {
            throw (BrokerAdminException)e;
        }
        if (e instanceof JMSException) {
            BrokerAdminException bae = new BrokerAdminException(1);
            bae.setLinkedException(e);
            throw bae;
        }
        BrokerAdminException bae = new BrokerAdminException(1);
        bae.setLinkedException(e);
        throw bae;
    }

    protected void handleReceiveExceptions(Exception e) throws BrokerAdminException {
        if (e instanceof BrokerAdminException) {
            throw (BrokerAdminException)e;
        }
        if (e instanceof JMSException) {
            BrokerAdminException bae = new BrokerAdminException(2);
            bae.setLinkedException(e);
            throw bae;
        }
        BrokerAdminException bae = new BrokerAdminException(2);
        bae.setLinkedException(e);
        throw bae;
    }

    public void addAdminEventListener(AdminEventListener l) {
        this.eListeners.addElement(l);
    }

    public void removeAdminEventListener(AdminEventListener l) {
        this.eListeners.removeElement(l);
    }

    public void removeAllAdminEventListeners() {
        this.eListeners.removeAllElements();
    }

    public void fireAdminEventDispatched(AdminEvent ae) {
        for (int i = 0; i < this.eListeners.size(); ++i) {
            ((AdminEventListener)this.eListeners.elementAt(i)).adminEventDispatched(ae);
        }
    }

    protected void sendStatusEvent(Message mesg, Exception ex) {
        if (this.getCurrentStatusEvent() != null) {
            if (mesg == null) {
                this.getCurrentStatusEvent().setSuccess(false);
                this.getCurrentStatusEvent().setLinkedException(ex);
            } else {
                try {
                    this.checkReplyTypeStatus(mesg, this.getCurrentStatusEvent().getReplyType(), this.getCurrentStatusEvent().getReplyTypeString());
                    if (mesg instanceof ObjectMessage) {
                        try {
                            this.getCurrentStatusEvent().setReturnedObject(((ObjectMessage)mesg).getObject());
                        }
                        catch (JMSException jmse) {
                            this.getCurrentStatusEvent().setSuccess(false);
                            this.getCurrentStatusEvent().setLinkedException(jmse);
                        }
                    }
                    this.getCurrentStatusEvent().setSuccess(true);
                }
                catch (BrokerAdminException bae) {
                    this.getCurrentStatusEvent().setSuccess(false);
                    this.getCurrentStatusEvent().setLinkedException(bae);
                }
            }
            this.fireAdminEventDispatched(this.getCurrentStatusEvent());
            this.clearStatusEvent();
        }
    }

    @Override
    public void onException(JMSException jmse) {
        BrokerErrorEvent bee = null;
        this.isConnected = false;
        if ("C4056" == jmse.getErrorCode()) {
            if (!this.isInitiator()) {
                bee = new BrokerErrorEvent(this, 1);
                bee.setBrokerHost(this.getBrokerHost());
                bee.setBrokerPort(this.getBrokerPort());
                bee.setBrokerName(this.getKey());
            }
        } else if (jmse.getLinkedException() instanceof EOFException) {
            bee = new BrokerErrorEvent(this, 0);
            bee.setBrokerHost(this.getBrokerHost());
            bee.setBrokerPort(this.getBrokerPort());
            bee.setBrokerName(this.getKey());
        } else {
            bee = new BrokerErrorEvent(this, 2);
            bee.setBrokerHost(this.getBrokerHost());
            bee.setBrokerPort(this.getBrokerPort());
            bee.setBrokerName(this.getKey());
        }
        if (bee != null) {
            this.fireAdminEventDispatched(bee);
        }
        this.removeAllAdminEventListeners();
    }

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static boolean getDebug() {
        return debug;
    }
}

