/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.ServiceEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServiceTable {
    private static boolean DEBUG = false;
    private String brokerInstanceName = "???";
    private String brokerVersion = "???";
    private Hashtable remoteServices = new Hashtable();
    private String activeBroker = null;
    private Hashtable table = new Hashtable();

    public void add(ServiceEntry e) {
        this.table.remove(e.getName());
        this.table.put(e.getName(), e);
    }

    public ServiceEntry get(String name) {
        return (ServiceEntry)this.table.get(name);
    }

    public Hashtable getServices() {
        return this.table;
    }

    public String getServiceAddress(String service) {
        ServiceEntry se = (ServiceEntry)this.table.get(service);
        if (se == null) {
            return null;
        }
        return se.getAddress();
    }

    public String getServiceAddress(String type, String protocol) {
        String addr = null;
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            ServiceEntry se = (ServiceEntry)e.nextElement();
            if (!se.getProtocol().equals(protocol) || !se.getType().equals(type)) continue;
            addr = se.getAddress();
            break;
        }
        return addr;
    }

    public void remove(String name) {
        this.table.remove(name);
    }

    public void remove(ServiceEntry e) {
        this.table.remove(e.getName());
    }

    public void setBrokerInstanceName(String brokerInstanceName) {
        this.brokerInstanceName = brokerInstanceName;
    }

    public String getBrokerInstanceName() {
        return this.brokerInstanceName;
    }

    public void setBrokerVersion(String brokerVersion) {
        this.brokerVersion = brokerVersion;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public void addRemoteService(String address) {
        this.remoteServices.put(address, address);
    }

    public void removeRemoteService(String address) {
        this.remoteServices.remove(address);
    }

    public Hashtable getRemoteServices() {
        return this.remoteServices;
    }

    public void setActiveBroker(String address) {
        this.activeBroker = address;
    }

    public String getActiveBroker() {
        return this.activeBroker;
    }

    public void dumpServiceTable() {
        System.out.println("brokerInstanceName = " + this.brokerInstanceName);
        System.out.println("brokerVersion = " + this.brokerVersion);
        System.out.println("active broker = " + this.activeBroker);
        System.out.println("Remote Services :");
        Enumeration<Object> e = this.remoteServices.keys();
        while (e.hasMoreElements()) {
            System.out.println("\t" + (String)e.nextElement());
        }
        System.out.println("Local Services :");
        e = this.table.elements();
        while (e.hasMoreElements()) {
            System.out.println("\t" + ((ServiceEntry)e.nextElement()).toString());
        }
    }
}

