/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.UniqueID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;

public class UID
implements Serializable {
    private static final long serialVersionUID = -583620884703541778L;
    protected static short prefix = (short)new Random().nextInt(Short.MAX_VALUE);
    protected long id = 0L;
    transient int hashCode = 0;
    transient String unique_id = null;

    public UID() {
        this.id = UniqueID.generateID(prefix);
    }

    public UID(long id) {
        this.id = id;
    }

    public static void setPrefix(short p) {
        prefix = p;
    }

    public static short getPrefix() {
        return prefix;
    }

    public long longValue() {
        return this.id;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = UniqueID.hashCode(this.id);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UID)) {
            return false;
        }
        return this.id == ((UID)obj).id;
    }

    public long age() {
        return UniqueID.age(this.id);
    }

    public long age(long currentTime) {
        return UniqueID.age(this.id, currentTime);
    }

    public long getTimestamp() {
        return UniqueID.getTimestamp(this.id);
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public String getUniqueName() {
        if (this.unique_id == null) {
            this.unique_id = this.toString();
        }
        return this.unique_id;
    }

    public String toLongString() {
        return UniqueID.toLongString(this.id);
    }

    public void writeUID(DataOutputStream out) throws IOException {
        out.writeLong(this.id);
    }

    public static UID readUID(DataInputStream in) throws IOException {
        long n = in.readLong();
        return new UID(n);
    }
}

