/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.util.Hashtable;

public class TakeoverHandler
extends AdminCmdHandler {
    private static boolean DEBUG = TakeoverHandler.getDEBUG();

    public TakeoverHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Taking over broker: " + cmd_props);
        }
        String brokerID = (String)cmd_props.get("JMQBrokerID");
        int status = 200;
        String errMsg = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            this.logger.log(8, "B1190", brokerID);
            try {
                BrokerStateHandler bsh = Globals.getBrokerStateHandler();
                bsh.takeoverBroker(brokerID, null, true);
            }
            catch (Exception ex) {
                this.logger.logStack(32, Globals.getBrokerResources().getKString("B3231", brokerID, ex.getMessage()), ex);
                status = 500;
                errMsg = ex.toString();
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        TakeoverHandler.setProperties(reply, 77, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

