/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ConsumerUtil {
    private static CompositeType monitorCompType = null;

    public static int toExternalAckMode(int internalAckMode) {
        switch (internalAckMode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static String toExternalAckModeString(int internalAckMode) {
        switch (internalAckMode) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 32768: {
                return "NO_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN";
    }

    public static int toInternalAckMode(int externalAckMode) {
        switch (externalAckMode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static HashMap getAllConsumersNoChildren() {
        Iterator it = Consumer.getAllConsumers();
        HashMap<ConsumerUID, Consumer> consumersNoChildren = new HashMap<ConsumerUID, Consumer>();
        while (it.hasNext()) {
            Consumer oneCon = (Consumer)it.next();
            ConsumerUID cid = oneCon.getConsumerUID();
            if (oneCon.getSubscription() != null) continue;
            consumersNoChildren.put(cid, oneCon);
        }
        return consumersNoChildren;
    }

    public static int getNumConsumersNoChildren() {
        return ConsumerUtil.getAllConsumersNoChildren().size();
    }

    public static boolean isDurable(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con != null) {
            return con.isDurableSubscriber();
        }
        return false;
    }

    public static boolean isWildcard(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con != null) {
            return con.isWildcard();
        }
        return false;
    }

    public static String getNextMessageID(ConsumerUID cid) {
        PacketReference r;
        Consumer con = Consumer.getConsumer(cid);
        if (con != null && (r = con.peekNext()) != null) {
            return r.getSysMessageID().toString();
        }
        return "";
    }

    public static boolean isDurableActive(ConsumerUID cid) {
        if (!ConsumerUtil.isDurable(cid)) {
            return false;
        }
        Consumer con = Consumer.getConsumer(cid);
        if (con != null) {
            return con.isActive();
        }
        return false;
    }

    public static ConnectionUID getConnectionUID(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        ConnectionUID cxnId = null;
        if (ConsumerUtil.isDurable(cid) && !ConsumerUtil.isDurableActive(cid)) {
            return null;
        }
        if (con != null) {
            cxnId = con.getConnectionUID();
        }
        return cxnId;
    }

    public static Destination getDestination(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        Destination d = null;
        if (con != null) {
            d = con.getFirstDestination();
        }
        return d;
    }

    public static DestinationUID getDestinationUID(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        DestinationUID id = null;
        if (con != null) {
            id = con.getDestinationUID();
        }
        return id;
    }

    public static Long getCreationTime(ConsumerUID cid) {
        long currentTime = System.currentTimeMillis();
        return new Long(currentTime - cid.age(currentTime));
    }

    public static String[] getConsumerIDs() {
        int numConsumers = 0;
        HashSet hs = new HashSet(ConsumerUtil.getAllConsumersNoChildren().values());
        numConsumers = hs.size();
        if (numConsumers <= 0) {
            return null;
        }
        String[] ids = new String[numConsumers];
        Iterator consumers = hs.iterator();
        int i = 0;
        while (consumers.hasNext()) {
            String id;
            Consumer oneCon = (Consumer)consumers.next();
            long conID = oneCon.getConsumerUID().longValue();
            ids[i] = id = Long.toString(conID);
            ++i;
        }
        return ids;
    }

    public static CompositeData[] getConsumerInfo() throws BrokerException, OpenDataException {
        String[] ids = ConsumerUtil.getConsumerIDs();
        if (ids == null) {
            return null;
        }
        CompositeData[] cds = new CompositeData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            cds[i] = ConsumerUtil.getConsumerInfo(ids[i]);
        }
        return cds;
    }

    public static CompositeData getConsumerInfo(String consumerID) throws BrokerException, OpenDataException {
        CompositeData cd = null;
        ConsumerUID cid = null;
        BrokerResources rb = Globals.getBrokerResources();
        if (consumerID == null) {
            throw new IllegalArgumentException(rb.getString("B4259"));
        }
        long longCid = 0L;
        try {
            longCid = Long.parseLong(consumerID);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(rb.getString("B4260", consumerID));
        }
        ConsumerUID tmpcid = new ConsumerUID(longCid);
        Consumer con = Consumer.getConsumer(tmpcid);
        if (con == null) {
            throw new BrokerException(rb.getString("B4261", consumerID));
        }
        con.load();
        cid = con.getConsumerUID();
        if (cid == null) {
            throw new BrokerException(rb.getString("B4261", consumerID));
        }
        cd = ConsumerUtil.getConsumerInfo(cid);
        return cd;
    }

    private static Integer getAcknowledgeMode(ConsumerUID cid) {
        return new Integer(ConsumerUtil.toExternalAckMode(cid.getAckType()));
    }

    private static String getAcknowledgeModeLabel(ConsumerUID cid) {
        return ConsumerUtil.toExternalAckModeString(cid.getAckType());
    }

    private static String getClientID(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return con.getClientID();
    }

    private static String getConnectionID(ConsumerUID cid) {
        ConnectionUID cxnId = ConsumerUtil.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        return Long.toString(cxnId.longValue());
    }

    private static String[] getDestinationNames(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        String[] ret = null;
        if (con == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        Set dests = con.getUniqueDestinations();
        if (dests == null) {
            return null;
        }
        for (Destination dest : dests) {
            al.add(dest.getDestinationName());
        }
        if (al.size() > 0) {
            ret = new String[al.size()];
            ret = al.toArray(ret);
        }
        return ret;
    }

    private static String getDestinationName(ConsumerUID cid) {
        DestinationUID id = ConsumerUtil.getDestinationUID(cid);
        if (id == null) {
            return null;
        }
        return id.getName();
    }

    private static String getDestinationType(ConsumerUID cid) {
        Destination d = ConsumerUtil.getDestination(cid);
        if (d == null) {
            return null;
        }
        return d.isQueue() ? "q" : "t";
    }

    private static Boolean getWildcard(ConsumerUID cid) {
        return new Boolean(ConsumerUtil.isWildcard(cid));
    }

    private static Boolean getDurable(ConsumerUID cid) {
        return new Boolean(ConsumerUtil.isDurable(cid));
    }

    private static Boolean getDurableActive(ConsumerUID cid) {
        if (!ConsumerUtil.getDurable(cid).booleanValue()) {
            return null;
        }
        return new Boolean(ConsumerUtil.isDurableActive(cid));
    }

    private static String getDurableName(ConsumerUID cid) {
        if (!ConsumerUtil.getDurable(cid).booleanValue()) {
            return null;
        }
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        if (con instanceof Subscription) {
            return ((Subscription)con).getDurableName();
        }
        Subscription sub = con.getSubscription();
        if (sub != null) {
            return sub.getDurableName();
        }
        return null;
    }

    private static Boolean getFlowPaused(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Boolean(con.getIsFlowPaused());
    }

    private static String getHost(ConsumerUID cid) {
        ConnectionUID cxnId = ConsumerUtil.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(cxnId.longValue());
        if (cxnInfo == null) {
            return null;
        }
        String host = null;
        if (cxnInfo.remoteIP != null) {
            host = String.valueOf(IPAddress.rawIPToString(cxnInfo.remoteIP, true, true));
        }
        return host;
    }

    private static Long getLastAckTime(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.getLastAckTime());
    }

    private static Long getNumMsgs(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.totalMsgsDelivered());
    }

    private static Long getNumMsgsPendingAcks(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.numPendingAcks());
    }

    private static Long getNumPendingMsgs(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.numInProcessMsgs());
    }

    private static String getSelector(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return con.getSelectorStr();
    }

    private static String getServiceName(ConsumerUID cid) {
        ConnectionUID cxnId = ConsumerUtil.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        String serviceName = ConnectionUtil.getServiceOfConnection(cxnId.longValue());
        return serviceName;
    }

    private static String getUser(ConsumerUID cid) {
        ConnectionUID cxnId = ConsumerUtil.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(cxnId.longValue());
        if (cxnInfo == null) {
            return null;
        }
        return cxnInfo.user;
    }

    private static CompositeData getConsumerInfo(ConsumerUID cid) throws OpenDataException {
        String[] consumerInfoMonitorItemNames;
        String[] consumerInfoMonitorItemDesc = consumerInfoMonitorItemNames = new String[]{"AcknowledgeMode", "AcknowledgeModeLabel", "ClientID", "ConnectionID", "ConsumerID", "CreationTime", "DestinationName", "DestinationNames", "DestinationType", "Durable", "DurableActive", "DurableName", "FlowPaused", "Host", "LastAckTime", "NumMsgs", "NumMsgsPending", "NumMsgsPendingAcks", "Selector", "ServiceName", "User", "Wildcard", "NextMessageID"};
        OpenType[] consumerInfoMonitorItemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING};
        Object[] consumerInfoMonitorItemValues = new Object[]{ConsumerUtil.getAcknowledgeMode(cid), ConsumerUtil.getAcknowledgeModeLabel(cid), ConsumerUtil.getClientID(cid), ConsumerUtil.getConnectionID(cid), Long.toString(cid.longValue()), ConsumerUtil.getCreationTime(cid), ConsumerUtil.getDestinationName(cid), ConsumerUtil.getDestinationNames(cid), ConsumerUtil.getDestinationType(cid), ConsumerUtil.getDurable(cid), ConsumerUtil.getDurableActive(cid), ConsumerUtil.getDurableName(cid), ConsumerUtil.getFlowPaused(cid), ConsumerUtil.getHost(cid), ConsumerUtil.getLastAckTime(cid), ConsumerUtil.getNumMsgs(cid), ConsumerUtil.getNumPendingMsgs(cid), ConsumerUtil.getNumMsgsPendingAcks(cid), ConsumerUtil.getSelector(cid), ConsumerUtil.getServiceName(cid), ConsumerUtil.getUser(cid), ConsumerUtil.getWildcard(cid), ConsumerUtil.getNextMessageID(cid)};
        CompositeDataSupport cd = null;
        Consumer con = Consumer.getConsumer(cid);
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("ConsumerMonitorInfo", "ConsumerMonitorInfo", consumerInfoMonitorItemNames, consumerInfoMonitorItemDesc, consumerInfoMonitorItemTypes);
        }
        cd = new CompositeDataSupport(monitorCompType, consumerInfoMonitorItemNames, consumerInfoMonitorItemValues);
        return cd;
    }
}

