/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.memory;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.memory.MemoryCallback;
import com.sun.messaging.jmq.jmsserver.memory.MemoryCallbackEntry;
import com.sun.messaging.jmq.jmsserver.memory.MemoryLevelHandler;
import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;

public class MemoryManager
implements DiagManager.Data {
    private static boolean NO_GC_DEFAULT = false;
    private static final String GC_JAVA_VERSION = "1.4.2";
    private static final String PACKAGE = "com.sun.messaging.jmq.jmsserver.memory.levels.";
    protected static final Logger logger = Globals.getLogger();
    public boolean NO_GC = Globals.getConfig().getBooleanProperty("imq.memory_management.nogc", NO_GC_DEFAULT);
    private static boolean DEBUG;
    ArrayList diagDictionary = null;
    MemoryLevelHandler[] levelHandlers = null;
    long[] byteLevels = null;
    protected int currentLevel = 0;
    protected String currentLevelString = "";
    protected long baseMemory;
    protected long maxMessageSize;
    protected long maxAvailableMemory;
    protected long maxSizeOfVM;
    protected long totalMemory;
    protected long freeMemory;
    protected long allocatedMemory;
    protected long availMemory;
    protected int producerCount = 0;
    protected int JMQSizeValue = 0;
    protected long JMQBytesValue = 0L;
    protected long JMQMaxMessageSize = 0L;
    protected long averageMemUsage = 0L;
    protected long highestMemUsage = 0L;
    protected long memoryCheckCount = 0L;
    protected long timeInLevel = 0L;
    protected long cumulativeTimeInLevel = 0L;
    protected long startTime = 0L;
    private static final int GC_DELTA_DEFAULT = 1024;
    private static int GC_DELTA;
    private static long OVERHEAD_MEMORY_DEFAULT;
    private static long OVERHEAD_MEMORY;
    private boolean turnOffMemory = !Globals.getConfig().getBooleanProperty("imq.memory_management.enabled", true);
    private static int THRESHOLD_DELTA_DEFAULT;
    private static int THRESHOLD_DELTA;
    private HashMap callbacklist = new HashMap();
    private List pausedList = new ArrayList();
    private boolean active = false;
    private Object stateChangeLock = new Object();
    private Object valuesObjectLock = new Object();
    private Object timerObjectLock = new Object();
    private MyTimerTask mytimer = null;
    boolean completedRunningCleanup = true;
    int cleanupCnt = 0;

    private static boolean getNoGCDefault() {
        boolean NoGCDefault = false;
        Version v = Globals.getVersion();
        int cmp = Version.compareVersions((String)System.getProperties().get("java.version"), GC_JAVA_VERSION, true);
        NoGCDefault = cmp >= 0;
        logger.log(1, "NoGC commuted from JDK:  " + NoGCDefault);
        return NoGCDefault;
    }

    public Hashtable getDebugState() {
        int i;
        Vector<Object> v;
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("turnOffMemory", this.turnOffMemory);
        ht.put("active", this.active);
        ht.put("noForcedGC", this.NO_GC);
        ht.put("baseMemory", new Long(this.baseMemory));
        ht.put("maxMessageSize", new Long(this.maxMessageSize));
        ht.put("maxAvailableMemory", new Long(this.maxAvailableMemory));
        ht.put("maxSizeOfVM", new Long(this.maxSizeOfVM));
        ht.put("totalMemory", new Long(this.totalMemory));
        ht.put("freeMemory", new Long(this.freeMemory));
        ht.put("allocatedMemory", new Long(this.allocatedMemory));
        ht.put("availMemory", new Long(this.availMemory));
        ht.put("allocatedMemory", new Long(this.allocatedMemory));
        ht.put("JMQBytesValue", new Long(this.JMQBytesValue));
        ht.put("JMQMaxMessageSize", new Long(this.JMQMaxMessageSize));
        ht.put("averageMemUsage", new Long(this.averageMemUsage));
        ht.put("highestMemUsage", new Long(this.highestMemUsage));
        ht.put("memoryCheckCount", new Long(this.memoryCheckCount));
        ht.put("timeInLevel", new Long(this.timeInLevel));
        ht.put("cumulativeTimeInLevel", new Long(this.cumulativeTimeInLevel));
        ht.put("startTime", new Long(this.startTime));
        ht.put("OVERHEAD_MEMORY", new Long(OVERHEAD_MEMORY));
        ht.put("currentLevel", new Integer(this.currentLevel));
        ht.put("producerCount", new Integer(this.producerCount));
        ht.put("JMQSizeValue", new Integer(this.JMQSizeValue));
        ht.put("GC_DELTA", new Integer(GC_DELTA));
        ht.put("THRESHOLD_DELTA", new Integer(THRESHOLD_DELTA));
        ht.put("currentLevelString", this.currentLevelString);
        if (this.byteLevels != null) {
            ht.put("byteLevels#", new Integer(this.byteLevels.length));
            v = new Vector();
            for (i = 0; i < this.byteLevels.length; ++i) {
                v.add(new Long(this.byteLevels[i]));
            }
            ht.put("byteLevels", v);
        }
        if (this.levelHandlers != null) {
            v = new Vector<Object>();
            ht.put("levelHandlers#", new Integer(this.levelHandlers.length));
            for (i = 0; i < this.levelHandlers.length; ++i) {
                v.add(this.levelHandlers[i].getDebugState());
            }
            ht.put("levelHandlers", v);
        }
        ht.put("pausedList#", new Integer(this.pausedList.size()));
        ht.put("callbacklist#", new Integer(this.callbacklist.size()));
        if (this.pausedList.size() > 0) {
            v = new Vector();
            for (i = 0; i < this.pausedList.size(); ++i) {
                v.add(this.pausedList.get(i).toString());
            }
            ht.put("pausedList", v);
        }
        if (this.callbacklist.size() > 0) {
            v = new Vector();
            Iterator itr = this.callbacklist.values().iterator();
            while (itr.hasNext()) {
                v.add(itr.next().toString());
            }
            ht.put("callbacklist", v);
        }
        return ht;
    }

    public MemoryManager() {
        if (this.turnOffMemory) {
            this.JMQSizeValue = -1;
            this.JMQBytesValue = -1L;
            this.JMQMaxMessageSize = -1L;
            return;
        }
        this.maxSizeOfVM = Runtime.getRuntime().maxMemory() - 0L;
        this.maxAvailableMemory = this.maxSizeOfVM - OVERHEAD_MEMORY_DEFAULT;
        String[] levels = Globals.getConfig().getArray("imq.memory.levels");
        if (levels == null) {
            levels = new String[]{};
        }
        try {
            this.levelHandlers = new MemoryLevelHandler[levels.length];
            this.byteLevels = new long[levels.length];
            for (int i = 0; i < levels.length; ++i) {
                String fullclassname = Globals.getConfig().getProperty("imq." + levels[i] + ".classname");
                if (fullclassname == null) {
                    StringBuffer classname = new StringBuffer(levels[i]);
                    char first = classname.charAt(0);
                    char upper = Character.toUpperCase(first);
                    classname.setCharAt(0, upper);
                    fullclassname = PACKAGE + classname;
                }
                if (DEBUG) {
                    logger.log(4, "Loading level " + levels[i] + " as " + fullclassname);
                }
                Class<?> myclass = Class.forName(fullclassname);
                Class[] cons_args = new Class[]{String.class};
                Constructor<?> constructor = myclass.getConstructor(cons_args);
                Object[] args = new Object[]{levels[i]};
                this.levelHandlers[i] = (MemoryLevelHandler)constructor.newInstance(args);
                this.byteLevels[i] = (long)this.levelHandlers[i].getThresholdPercent() * this.maxAvailableMemory / 100L;
            }
        }
        catch (Exception ex) {
            logger.logStack(16, "B3100", "loading memory manager", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopManagement() {
        this.active = false;
        Object object = this.timerObjectLock;
        synchronized (object) {
            if (this.mytimer != null) {
                this.mytimer.cancel();
                this.mytimer = null;
            }
        }
    }

    public void startManagement() {
        if (this.turnOffMemory) {
            logger.log(4, "Memory Management turned off");
            return;
        }
        if (this.active) {
            logger.log(4, "Memory Management already active");
            return;
        }
        this.active = true;
        logger.log(4, "Starting Memory Management: adjusted available memory is " + this.maxAvailableMemory / 1024L + "K");
        logger.log(4, "Explicitly GC : " + !this.NO_GC);
        for (int i = 0; i < this.levelHandlers.length; ++i) {
            logger.log(4, "LEVEL:" + this.levelHandlers[i].levelName() + "[percent = " + this.levelHandlers[i].getThresholdPercent() + "%" + ", bytes = " + this.byteLevels[i] / 1024L + "K]");
        }
        DiagManager.register(this);
        this.startTime = System.currentTimeMillis();
        this.baseMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.currentLevel = this.calculateState();
        MemoryLevelHandler currentHandler = this.levelHandlers[this.currentLevel];
        this.currentLevelString = currentHandler.levelName();
        currentHandler.enter(false);
        this.JMQSizeValue = currentHandler.getMessageCount(this.availMemory, this.producerCount);
        this.JMQBytesValue = currentHandler.getMemory(this.availMemory, this.producerCount);
        this.JMQMaxMessageSize = this.maxAvailableMemory / 2L;
        this.updateMaxMessageSize(-2L);
        this.mytimer = new MyTimerTask();
        long time = currentHandler.getTimeBetweenChecks();
        try {
            Globals.getTimer().schedule((TimerTask)this.mytimer, time, time);
        }
        catch (IllegalStateException ex) {
            logger.log(4, "Timer canceled ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJMQSize() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQSizeValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMQBytes() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQBytesValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMQMaxMsgBytes() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQMaxMessageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyWhenAvailable(MemoryCallback cb, long bytes) {
        if (DEBUG) {
            logger.log(4, "Registering notifyWhenAvailable at " + bytes + " for " + cb);
        }
        if (this.turnOffMemory || !this.active) {
            cb.resumeMemory(this.JMQSizeValue, this.JMQBytesValue, this.JMQMaxMessageSize);
            return;
        }
        this.checkMemoryState();
        Object object = this.valuesObjectLock;
        synchronized (object) {
            if ((bytes == 0L || bytes < this.JMQBytesValue) && this.JMQSizeValue > 1) {
                cb.resumeMemory(this.JMQSizeValue, this.JMQBytesValue, this.JMQMaxMessageSize);
                return;
            }
        }
        MemoryCallbackEntry mce = (MemoryCallbackEntry)this.callbacklist.get(cb);
        if (cb == null) {
            mce = new MemoryCallbackEntry();
            this.callbacklist.put(cb, mce);
            mce.cb = cb;
            mce.keepAfterNotify = false;
        }
        mce.paused = true;
        mce.bytes = bytes;
        List list = this.pausedList;
        synchronized (list) {
            this.pausedList.add(mce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryCallback(MemoryCallback cb) {
        if (DEBUG) {
            logger.log(4, "Registering registerMemoryCallback  for " + cb);
        }
        MemoryCallbackEntry mce = new MemoryCallbackEntry();
        mce.cb = cb;
        mce.keepAfterNotify = true;
        mce.paused = false;
        mce.bytes = 0L;
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            this.callbacklist.put(cb, mce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemoryCallback(MemoryCallback cb) {
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            this.callbacklist.remove(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentLevel() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            return this.currentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentLevelName() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            return this.levelHandlers[this.currentLevel].localizedLevelName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllOfStateChange(boolean override) {
        if (this.turnOffMemory || !this.active) {
            return;
        }
        ArrayList l = new ArrayList();
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            l.addAll(this.callbacklist.values());
        }
        long BytesValue = 0L;
        int SizeValue = 0;
        long MaxMessageSize = 0L;
        Object object = this.valuesObjectLock;
        synchronized (object) {
            BytesValue = this.JMQBytesValue;
            SizeValue = this.JMQSizeValue;
            MaxMessageSize = this.JMQMaxMessageSize;
        }
        if (DEBUG) {
            logger.log(2, "notifyAllOfStateChange [size,bytes,max] = [" + this.JMQSizeValue + "," + this.JMQBytesValue + "," + this.JMQMaxMessageSize + "]");
        }
        for (MemoryCallbackEntry mce : l) {
            if (!override && mce.paused) continue;
            if (mce.paused) {
                if (mce.bytes == 0L && mce.bytes < BytesValue) {
                    mce.paused = false;
                    List list = this.pausedList;
                    synchronized (list) {
                        this.pausedList.remove(mce);
                    }
                    mce.cb.resumeMemory(SizeValue, BytesValue, MaxMessageSize);
                    if (!DEBUG) continue;
                    logger.log(2, "\tresumeMemory for  " + mce.bytes + " bytes on " + mce.cb);
                    continue;
                }
                if (DEBUG) {
                    logger.log(2, "\tupdateMemory for  " + mce.cb);
                }
                mce.cb.updateMemory(SizeValue, BytesValue, MaxMessageSize);
                continue;
            }
            if (DEBUG) {
                logger.log(2, "\tupdateMemory for  " + mce.cb);
            }
            mce.cb.updateMemory(SizeValue, BytesValue, MaxMessageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotifyPaused() {
        if (DEBUG) {
            logger.log(2, "checkAndNotifyPaused [size,bytes,max] = [" + this.JMQSizeValue + "," + this.JMQBytesValue + "," + this.JMQMaxMessageSize + "]");
        }
        ArrayList l = null;
        List list = this.pausedList;
        synchronized (list) {
            if (this.pausedList.isEmpty()) {
                return;
            }
            l = new ArrayList();
            l.addAll(this.pausedList);
        }
        long BytesValue = 0L;
        int SizeValue = 0;
        long MaxMessageSize = 0L;
        Object object = this.valuesObjectLock;
        synchronized (object) {
            BytesValue = this.JMQBytesValue;
            SizeValue = this.JMQSizeValue;
            MaxMessageSize = this.JMQMaxMessageSize;
        }
        Iterator waiting = l.iterator();
        while (waiting.hasNext()) {
            MemoryCallbackEntry mce = (MemoryCallbackEntry)waiting.next();
            if (mce.bytes != 0L || mce.bytes >= BytesValue) continue;
            mce.paused = false;
            waiting.remove();
            List list2 = this.pausedList;
            synchronized (list2) {
                this.pausedList.remove(mce);
            }
            if (DEBUG) {
                logger.log(2, "\tresumeMemory for  " + mce.bytes + " bytes on " + mce.cb);
            }
            mce.cb.resumeMemory(SizeValue, BytesValue, MaxMessageSize);
        }
    }

    public String toString() {
        return "MemoryManager";
    }

    public synchronized void addProducer() {
        ++this.producerCount;
        if (DEBUG) {
            logger.log(4, "addProducer " + this.producerCount);
        }
    }

    public synchronized void removeProducer() {
        --this.producerCount;
        if (DEBUG) {
            logger.log(4, "removeProducer " + this.producerCount);
        }
    }

    public synchronized void removeProducer(int cnt) {
        this.producerCount -= cnt;
        if (DEBUG) {
            logger.log(4, "removeProducer(" + cnt + ") " + this.producerCount);
        }
    }

    private boolean quickState(int state) {
        if (this.turnOffMemory || !this.active) {
            return false;
        }
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.allocatedMemory = this.totalMemory - this.freeMemory;
        return state < this.byteLevels.length - 1 && this.allocatedMemory > this.byteLevels[state + 1];
    }

    public boolean allocateMemCheck(long size) {
        if (DEBUG) {
            int level = this.currentLevel;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.byteLevels.length; ++i) {
                sb.append("byteLevel[" + i + "]=" + this.byteLevels[i] + ", ");
            }
            long freem = Runtime.getRuntime().freeMemory();
            long totalm = Runtime.getRuntime().totalMemory();
            long allocatedm = totalm - freem;
            logger.log(8, "MemoryManager: turnOffMemory=" + this.turnOffMemory + ", active=" + this.active + ", check size=" + size + ", currentLevel=" + level + "(" + this.byteLevels.length + "), " + sb.toString() + ", freemem=" + freem + ", totalmem=" + totalm + ", allocatedmem=" + allocatedm);
        }
        if (this.turnOffMemory || !this.active) {
            return true;
        }
        int currentl = this.currentLevel;
        if (currentl >= this.byteLevels.length - 1) {
            return false;
        }
        long freem = Runtime.getRuntime().freeMemory();
        long totalm = Runtime.getRuntime().totalMemory();
        long allocatedm = totalm - freem + size;
        return allocatedm <= this.byteLevels[this.byteLevels.length - 1];
    }

    private int calculateState() {
        if (this.turnOffMemory || !this.active) {
            return 0;
        }
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.allocatedMemory = this.totalMemory - this.freeMemory;
        long foo = Runtime.getRuntime().maxMemory();
        if (this.allocatedMemory > this.maxAvailableMemory) {
            this.recalcMemory();
        }
        this.availMemory = this.maxAvailableMemory - this.allocatedMemory;
        int targetstate = 0;
        for (int i = this.byteLevels.length - 1; i >= 0; --i) {
            if (this.allocatedMemory <= this.byteLevels[i]) continue;
            targetstate = i;
            break;
        }
        int returnstate = targetstate;
        if (targetstate < this.byteLevels.length - 1 && this.allocatedMemory > this.byteLevels[targetstate + 1] - (long)THRESHOLD_DELTA) {
            if (DEBUG) {
                logger.log(2, "calculateState:didnt meet delta requirements");
            }
            returnstate = targetstate + 1;
        }
        if (DEBUG) {
            logger.log(2, "calculateState [oldstate, calcstate, returnstate] = [" + this.currentLevel + "," + targetstate + "," + returnstate + "]");
        }
        return returnstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxMessageSize(long size) {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            if (size != -2L) {
                this.maxMessageSize = size;
            }
            this.JMQMaxMessageSize = this.maxAvailableMemory / 2L;
            if (this.maxMessageSize > -1L && this.maxMessageSize < this.JMQMaxMessageSize) {
                this.JMQMaxMessageSize = this.maxMessageSize;
            }
            if (DEBUG) {
                logger.log(4, "updateMaxMessageSize [size, JMQMaxMessageSize] = [" + size + "," + this.JMQMaxMessageSize + "]");
            }
        }
    }

    public void quickMemoryCheck() {
        if (this.quickState(this.currentLevel)) {
            this.checkMemoryState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemoryState() {
        if (this.turnOffMemory || !this.active) {
            return;
        }
        if (DEBUG) {
            logger.log(4, "checkMemoryState  " + this.memoryCheckCount);
        }
        boolean notify = false;
        int oldLevel = 0;
        int newState = 0;
        Object object = this.stateChangeLock;
        synchronized (object) {
            newState = this.calculateState();
            oldLevel = this.currentLevel;
            this.currentLevel = newState;
        }
        MemoryLevelHandler currentHandler = this.levelHandlers[oldLevel];
        if (newState != oldLevel) {
            int i;
            MemoryLevelHandler newHandler = this.levelHandlers[newState];
            if (newState > oldLevel) {
                this.gc(newHandler.gcCount());
                newState = this.calculateState();
            }
            for (i = oldLevel; i < newState; ++i) {
                notify = this.levelHandlers[i + 1].enter(false);
                notify |= this.levelHandlers[i].leave(true);
            }
            for (i = oldLevel; i > newState; --i) {
                notify |= this.levelHandlers[i - 1].enter(true);
                notify |= this.levelHandlers[i].leave(false);
            }
            newHandler = this.levelHandlers[newState];
            Object i2 = this.valuesObjectLock;
            synchronized (i2) {
                this.JMQSizeValue = newHandler.getMessageCount(this.availMemory, this.producerCount);
                this.JMQBytesValue = newHandler.getMemory(this.availMemory, this.producerCount);
            }
            if (notify) {
                this.notifyAllOfStateChange(true);
            }
            this.currentLevel = newState;
            if (newState > oldLevel) {
                this.completedRunningCleanup = false;
                this.cleanupCnt = 0;
                this.completedRunningCleanup = this.levelHandlers[newState].cleanup(this.cleanupCnt++);
            } else if (newState < oldLevel) {
                this.completedRunningCleanup = true;
                this.cleanupCnt = 0;
            }
            if (newState != oldLevel) {
                Object[] args = new String[]{this.levelHandlers[newState].localizedLevelName(), this.levelHandlers[oldLevel].localizedLevelName(), String.valueOf(this.allocatedMemory / 1024L), String.valueOf(this.allocatedMemory * 100L / this.maxAvailableMemory)};
                logger.log(8, "B1088", args);
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyResourceStateChange(this.levelHandlers[oldLevel].localizedLevelName(), this.levelHandlers[newState].localizedLevelName(), null);
                }
                this.currentLevel = newState;
                currentHandler = newHandler;
                this.currentLevelString = currentHandler.levelName();
                Object object2 = this.timerObjectLock;
                synchronized (object2) {
                    if (this.mytimer != null) {
                        this.mytimer.cancel();
                        this.mytimer = null;
                    }
                    this.mytimer = new MyTimerTask();
                    long time = currentHandler.getTimeBetweenChecks();
                    try {
                        Globals.getTimer(true).schedule((TimerTask)this.mytimer, time, time);
                    }
                    catch (IllegalStateException ex) {
                        logger.log(4, "Timer canceled ", ex);
                    }
                }
            }
        } else {
            if (!this.completedRunningCleanup) {
                this.completedRunningCleanup = this.levelHandlers[oldLevel].cleanup(this.cleanupCnt++);
            }
            if (currentHandler.gcIteration() != 0 && this.memoryCheckCount % (long)currentHandler.gcIteration() == 0L) {
                this.gc();
            }
            Object object3 = this.valuesObjectLock;
            synchronized (object3) {
                this.JMQSizeValue = currentHandler.getMessageCount(this.availMemory, this.producerCount);
                this.JMQBytesValue = currentHandler.getMemory(this.availMemory, this.producerCount);
            }
            if (this.JMQSizeValue > 0) {
                this.checkAndNotifyPaused();
            }
        }
        if (this.allocatedMemory > this.highestMemUsage) {
            this.highestMemUsage = this.allocatedMemory;
        }
        this.averageMemUsage = (this.averageMemUsage * this.memoryCheckCount + this.allocatedMemory) / (this.memoryCheckCount + 1L);
        ++this.memoryCheckCount;
    }

    public void forceRedState() {
        long size = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory();
        logger.log(16, "B2075", (Object)String.valueOf(size), String.valueOf(Runtime.getRuntime().maxMemory()));
        this.recalcMemory();
        this.checkMemoryState();
    }

    public void recalcMemory() {
        this.maxAvailableMemory = Runtime.getRuntime().totalMemory();
        this.updateMaxMessageSize(-2L);
        for (int i = 0; i < this.byteLevels.length; ++i) {
            this.byteLevels[i] = (long)this.levelHandlers[i].getThresholdPercent() * this.maxAvailableMemory / 100L;
        }
    }

    protected void gc() {
        this.gc(1, GC_DELTA);
    }

    protected void gc(int count) {
        this.gc(count, GC_DELTA);
    }

    protected void gc(int count, long delta) {
        if (!this.NO_GC) {
            logger.log(4, "calling Runtime.freeMemory()");
            long free = Runtime.getRuntime().freeMemory();
            int i = 0;
            for (i = 0; i < count; ++i) {
                Runtime.getRuntime().gc();
                long newfree = Runtime.getRuntime().freeMemory();
                if (free - newfree > delta) break;
            }
        }
    }

    @Override
    public synchronized List getDictionary() {
        if (this.diagDictionary == null) {
            this.diagDictionary = new ArrayList();
            this.diagDictionary.add(new DiagDictionaryEntry("currentLevelString", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("allocatedMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("timeInLevel", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("cumulativeTimeInLevel", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQSizeValue", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQBytesValue", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQMaxMessageSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("totalMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("freeMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("availMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("maxAvailableMemory", 2));
            this.diagDictionary.add(new DiagDictionaryEntry("producerCount", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("averageMemUsage", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("memoryCheckCount", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("highestMemUsage", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("maxSizeOfVM", 2));
        }
        return this.diagDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        this.calculateState();
        MemoryLevelHandler currentHandler = null;
        Object object = this.stateChangeLock;
        synchronized (object) {
            currentHandler = this.levelHandlers[this.currentLevel];
        }
        this.timeInLevel = currentHandler.getCurrentTimeInLevel();
        this.cumulativeTimeInLevel = currentHandler.getTotalTimeInLevel();
    }

    @Override
    public String getPrefix() {
        return "mem_mgr";
    }

    @Override
    public String getTitle() {
        return "MemoryManager";
    }

    public String toDebugString() {
        int i;
        String retstr = "MemoryManager: [" + this.currentLevel + "]" + "\n";
        for (i = 0; i < this.levelHandlers.length; ++i) {
            retstr = retstr + "\t" + i + "\t" + this.levelHandlers[i].levelName() + "\t" + this.levelHandlers[i].getThresholdPercent() + "\t" + this.byteLevels[i] + "\n";
        }
        for (i = 0; i < this.levelHandlers.length; ++i) {
            retstr = retstr + "-------------------------------\n";
            retstr = retstr + this.levelHandlers[i].toDebugString() + " \n\n";
        }
        return retstr;
    }

    static {
        NO_GC_DEFAULT = MemoryManager.getNoGCDefault();
        DEBUG = false;
        GC_DELTA = Globals.getConfig().getIntProperty("imq.memory.gcdelta", 1024);
        OVERHEAD_MEMORY_DEFAULT = 10240L;
        OVERHEAD_MEMORY = Globals.getConfig().getLongProperty("imq.memory.overhead", OVERHEAD_MEMORY_DEFAULT);
        THRESHOLD_DELTA_DEFAULT = 1024;
        THRESHOLD_DELTA = Globals.getConfig().getIntProperty("imq.memory.hysteresis", THRESHOLD_DELTA_DEFAULT);
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            MemoryManager.this.checkMemoryState();
        }
    }
}

