/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;

class JoinRunnable
implements Runnable {
    String groupName = null;
    String nodeName = null;
    String masterHostPort = null;
    byte[] commitToken = null;
    Long syncTimeout = null;
    BrokerAddress from = null;
    BDBStore store = null;
    ClusterProtocolHelper cpi = null;
    boolean takeoverPrepare = false;
    String uuid = null;

    public JoinRunnable(String groupName, String nodeName, String masterHostPort, byte[] commitToken, Long syncTimeout, boolean takeoverPrepare, String uuid, BrokerAddress from, ClusterProtocolHelper cpi, BDBStore store) {
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.masterHostPort = masterHostPort;
        this.commitToken = commitToken;
        this.syncTimeout = syncTimeout;
        this.takeoverPrepare = takeoverPrepare;
        this.uuid = uuid;
        this.from = from;
        this.store = store;
        this.cpi = cpi;
    }

    @Override
    public void run() {
        int status = 200;
        String reason = null;
        try {
            ReplicatedEnvironment env = this.store.joinReplicationGroup(this.groupName, this.nodeName, this.masterHostPort, this.commitToken, this.syncTimeout, this.takeoverPrepare, false, this.from);
            if (this.takeoverPrepare) {
                this.store.storeTakeoverSession(this.nodeName, "TAKEOVER_PREPARED:" + this.uuid, true, true, new String[]{"TAKEOVER_PREPARE:" + this.uuid});
            }
            this.cpi.sendReply(this.from, status, reason, env.getRepConfig().getNodeHostPort());
        }
        catch (Throwable t) {
            status = 500;
            reason = t.getMessage();
            Globals.getLogger().logStack(32, t.getMessage() + this.cpi, t);
            this.cpi.sendReply(this.from, status, reason, null);
            return;
        }
    }
}

