/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.util.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

class PropertiesStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;

    protected PropertiesStore(BDBStore p) {
        this.parent = p;
        this.db = p.getPropDatabase();
    }

    protected void updateProperty(Transaction txn, String name, Object value) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(name.getBytes("UTF-8"));
            if (value == null) {
                OperationStatus status = this.db.delete(txn, key);
                if (status == OperationStatus.NOTFOUND) {
                    String emsg = "XXX property " + name + " not found in store";
                    this.logger.log(16, emsg);
                }
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream bos = new ObjectOutputStream(baos);
            bos.writeObject(value);
            bos.close();
            byte[] obj = baos.toByteArray();
            DatabaseEntry data = new DatabaseEntry(obj);
            this.db.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4112", name);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected Object getProperty(Transaction txn, String name) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(name.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return null;
            }
            byte[] obj = data.getData();
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getData());
            MQObjectInputStream ois = new MQObjectInputStream(bais);
            Object o = ois.readObject();
            ois.close();
            bais.close();
            return o;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4231", name);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected String[] getPropertyNames(Transaction txn) throws BrokerException {
        ArrayList<String> names = new ArrayList<String>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            String name = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                name = new String(key.getData(), "UTF-8");
                names.add(name);
            }
            cs.close();
            String[] stringArray = names.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4113");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all property names from store: " + e.getMessage());
                }
            }
        }
    }

    protected Properties getProperties(Transaction txn) throws BrokerException {
        Properties props = new Properties();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            String name = null;
            Object object = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                name = new String(key.getData(), "UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(data.getData());
                MQObjectInputStream ois = new MQObjectInputStream(bais);
                object = ois.readObject();
                ois.close();
                bais.close();
                props.put(name, object);
            }
            cs.close();
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4113");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all properties from store: " + e.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction txn) throws BrokerException {
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cs.delete();
            }
            cs.close();
        }
        catch (Exception e) {
            String emsg = "Failed to clear all properties from store";
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in clearing all propertiers from store: " + e.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "PropertiesStore: closing " + this.db.count() + " with properties");
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("dbCount", String.valueOf(this.db.count()));
        t.put("dbConfig", this.db.getConfig().toString());
        return t;
    }
}

