/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

class ReplicationStateChangeListener
implements StateChangeListener {
    private BDBStore parent = null;
    private String nodeName = null;
    private String groupName = null;
    String master = null;
    int DEFAULT_INIT_WAIT_INTERVAL = 15000;

    public ReplicationStateChangeListener(BDBStore parent, String node, String group) {
        this.parent = parent;
        this.nodeName = node;
        this.groupName = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitBecomeMaster(long timeout) throws Exception {
        long endtime = System.currentTimeMillis() + timeout;
        long waittime = timeout;
        if (waittime > (long)this.DEFAULT_INIT_WAIT_INTERVAL) {
            waittime = this.DEFAULT_INIT_WAIT_INTERVAL;
        }
        ReplicationStateChangeListener replicationStateChangeListener = this;
        synchronized (replicationStateChangeListener) {
            while (this.master == null) {
                Globals.getLogger().log(8, "Waiting for replication state change event ..");
                this.wait(waittime);
                if (this.master != null) break;
                long curtime = System.currentTimeMillis();
                if (curtime >= endtime) {
                    throw new BrokerException("Waiting for replication state change event timed out");
                }
                waittime = endtime - curtime;
                if (waittime <= (long)this.DEFAULT_INIT_WAIT_INTERVAL) continue;
                waittime = this.DEFAULT_INIT_WAIT_INTERVAL;
            }
            if (this.master == null || !this.master.equals(this.nodeName)) {
                throw new BrokerException("Expected " + this.nodeName + " to be the replication master for replication group [" + this.groupName + "], but got master " + this.master);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChange(StateChangeEvent event) {
        Logger logger = Globals.getLogger();
        ReplicatedEnvironment.State state = event.getState();
        logger.log(8, "ReplicationStateChangeEvent(" + state + ") on [" + this.groupName + ", " + this.nodeName + "]");
        if (state == ReplicatedEnvironment.State.MASTER || state == ReplicatedEnvironment.State.REPLICA) {
            String m = event.getMasterNodeName();
            logger.log(8, "Replication group [" + this.groupName + "] has master: " + m);
            ReplicationStateChangeListener replicationStateChangeListener = this;
            synchronized (replicationStateChangeListener) {
                this.master = m;
                this.notifyAll();
            }
        }
        if (state == ReplicatedEnvironment.State.REPLICA) {
            logger.log(8, "Becoming replica for replication group [" + this.groupName + "]");
        }
    }
}

