/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TransactionAckArray;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TransactionUIDTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;

class TxnStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];
    private BDBStore parent = null;
    private Database txndb = null;
    private Database txnackdb = null;
    private TupleBinding tidBinding = null;
    private EntryBinding tinfoBinding = null;
    private EntryBinding tacksBinding = null;

    protected TxnStore(BDBStore p) {
        this.parent = p;
        this.txndb = p.getTxnDatabase();
        this.txnackdb = p.getTxnAckDatabase();
        this.tidBinding = new TransactionUIDTupleBinding();
        this.tinfoBinding = new SerialBinding((ClassCatalog)p.getClassCatalog(), TransactionInfo.class);
        this.tacksBinding = new SerialBinding((ClassCatalog)p.getClassCatalog(), TransactionAckArray.class);
    }

    protected void storeTransaction(Transaction txn, TransactionUID tid, TransactionState ts) throws BrokerException {
        TransactionInfo tinfo = null;
        try {
            tinfo = new TransactionInfo(new TransactionState(ts));
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            OperationStatus status = this.txndb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3015", tid + "[" + ts.toString() + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4019", tid + "[" + ts.toString() + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void storeClusterTransaction(Transaction txn, TransactionUID tid, TransactionState ts, TransactionBroker[] brokers, boolean force) throws BrokerException {
        TransactionInfo tinfo = null;
        try {
            tinfo = !force ? new TransactionInfo(new TransactionState(ts), null, brokers, 2) : new TransactionInfo(new TransactionState(ts), Globals.getMyAddress(), brokers, 2);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            OperationStatus status = this.txndb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                if (!force) {
                    String emsg = this.br.getString("B3015", tid + "[" + tinfo + "][" + Arrays.toString(brokers) + "]");
                    this.logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
                TransactionInfo otinfo = this.getTransactionInfo(txn, tid);
                BrokerAddress ba = otinfo.getTransactionHomeBroker();
                tinfo = new TransactionInfo(new TransactionState(ts), ba, brokers, 2);
                data = new DatabaseEntry();
                this.tinfoBinding.objectToEntry((Object)tinfo, data);
                this.txndb.put(txn, key, data);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4019", tid + "[" + tinfo + "][" + Arrays.toString(brokers) + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void storeRemoteTransaction(Transaction txn, TransactionUID tid, TransactionState ts, TransactionAcknowledgement[] acks, BrokerAddress txnHomeBroker) throws BrokerException {
        TransactionInfo tinfo = null;
        try {
            tinfo = new TransactionInfo(new TransactionState(ts), txnHomeBroker, null, 3);
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status != OperationStatus.NOTFOUND) {
                String emsg = this.br.getString("B3015", tid + "[" + tinfo + "][" + Arrays.toString(acks) + "]");
                throw new BrokerException(emsg);
            }
            this.storeTransactionAcks(txn, tid, acks);
            data = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            status = this.txndb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getString("B3015", tid + "[" + tinfo + "][" + Arrays.toString(acks) + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            if (e instanceof BrokerException && e.getCause() instanceof ConflictException) {
                throw (BrokerException)e;
            }
            String emsg = this.br.getString("B4019", tid + "[" + tinfo + "][" + Arrays.toString(acks) + "]");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void storeTransaction(Transaction txn, TransactionUID tid, TransactionInfo tinfo) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            OperationStatus status = this.txndb.putNoOverwrite(null, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3015", tid + "[" + tinfo + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4019", tid + "[" + tinfo + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeTransaction(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            OperationStatus status = this.txndb.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3016", tid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg, 404);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4138", tid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateTransactionState(Transaction txn, TransactionUID tid, int ts) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3016", tid + "[" + TransactionState.toString(ts) + "]");
                throw new BrokerException(emsg);
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            TransactionState txnState = tinfo.getTransactionState();
            if (txnState.getState() != ts) {
                txnState.setState(ts);
            }
            data = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            status = this.txndb.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4137", tid + "[" + TransactionState.toString(ts) + "]");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateClusterTransaction(Transaction txn, TransactionUID tid, TransactionBroker[] brokers) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3016", tid + "[" + Arrays.toString(brokers) + "]");
                throw new BrokerException(emsg);
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            tinfo.setType(2);
            tinfo.setTransactionBrokers(brokers);
            data = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            status = this.txndb.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4019", tid + "[" + brokers + "]");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateTransactionBrokerState(Transaction txn, TransactionUID tid, int expectedTxnState, TransactionBroker txnBkr) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3016", tid + "[" + txnBkr + "](" + TransactionState.toString(expectedTxnState) + ")");
                throw new BrokerException(emsg);
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            TransactionState txnState = tinfo.getTransactionState();
            if (txnState.getState() != expectedTxnState) {
                Object[] args = new Object[]{txnBkr, tid, TransactionState.toString(expectedTxnState), TransactionState.toString(txnState.getState())};
                throw new BrokerException(this.br.getKString("B3219", args), 409);
            }
            tinfo.updateBrokerState(txnBkr);
            data = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)tinfo, data);
            status = this.txndb.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4019", tid + "[" + txnBkr + "](" + TransactionState.toString(expectedTxnState) + ")");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected TransactionState getTransactionState(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3016", tid);
                throw new BrokerException(emsg);
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            TransactionState txnState = tinfo.getTransactionState();
            return txnState;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4233", tid);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected int getTransactionStateValue(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return -1;
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            TransactionState txnState = tinfo.getTransactionState();
            if (txnState != null) {
                return txnState.getState();
            }
            return -1;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4233", tid);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected TransactionInfo getTransactionInfo(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", tid));
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            return tinfo;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4233", tid);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected BrokerAddress getRemoteTransactionHomeBroker(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", tid));
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            return tinfo.getTransactionHomeBroker();
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4233", tid);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected TransactionBroker[] getClusterTransactionBrokers(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", tid));
            }
            TransactionInfo tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
            return tinfo.getTransactionBrokers();
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4233", tid);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected HashMap getAllTransactionStates(Transaction txn) throws BrokerException {
        HashMap<TransactionUID, TransactionInfo> map = new HashMap<TransactionUID, TransactionInfo>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            TransactionUID tid = null;
            TransactionInfo tinfo = null;
            cs = this.txndb.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                tid = (TransactionUID)this.tidBinding.entryToObject(key);
                tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
                int type = tinfo.getType();
                if (type != 1 && type != 2) continue;
                map.put(tid, tinfo);
            }
            cs.close();
            HashMap<TransactionUID, TransactionInfo> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4032");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all transactions from store: " + e.getMessage());
                }
            }
        }
    }

    protected HashMap getAllRemoteTransactionStates(Transaction txn) throws BrokerException {
        HashMap<TransactionUID, TransactionState> map = new HashMap<TransactionUID, TransactionState>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            TransactionUID tid = null;
            TransactionInfo tinfo = null;
            cs = this.txndb.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                tid = (TransactionUID)this.tidBinding.entryToObject(key);
                tinfo = (TransactionInfo)this.tinfoBinding.entryToObject(data);
                int type = tinfo.getType();
                if (type != 3) continue;
                map.put(tid, tinfo.getTransactionState());
            }
            cs.close();
            HashMap<TransactionUID, TransactionState> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4032");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all remote transactions from store: " + e.getMessage());
                }
            }
        }
    }

    protected Collection getAllTransactions(Transaction txn) throws BrokerException {
        ArrayList<TransactionUID> tids = new ArrayList<TransactionUID>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            TransactionUID tid = null;
            cs = this.txndb.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                tid = (TransactionUID)this.tidBinding.entryToObject(key);
                tids.add(tid);
            }
            cs.close();
            ArrayList<TransactionUID> arrayList = tids;
            return arrayList;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4032");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all transactions from store: " + e.getMessage());
                }
            }
        }
    }

    protected void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore.clearAll() called");
        }
    }

    protected void storeTransactionAck(Transaction txn, TransactionUID tid, TransactionAcknowledgement ack) throws BrokerException {
        if (ack == null) {
            throw new BrokerException("null ack on store transaction ack");
        }
        TransactionAcknowledgement[] acks = new TransactionAcknowledgement[]{ack};
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.txndb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", tid.toString()));
            }
            data = new DatabaseEntry();
            status = this.txnackdb.get(txn, key, data, null);
            boolean notfound = true;
            if (status != OperationStatus.NOTFOUND) {
                notfound = false;
                TransactionAckArray oldacks = (TransactionAckArray)this.tacksBinding.entryToObject(data);
                ArrayList<TransactionAcknowledgement> a = new ArrayList<TransactionAcknowledgement>(Arrays.asList(oldacks.getAcks()));
                if (a.contains(ack)) {
                    throw new BrokerException(this.br.getKString("B3062", ack, tid));
                }
                a.add(ack);
                acks = a.toArray(new TransactionAcknowledgement[0]);
            }
            TransactionAckArray acka = new TransactionAckArray(acks);
            data = new DatabaseEntry();
            this.tacksBinding.objectToEntry((Object)acka, data);
            if (notfound) {
                status = this.txnackdb.putNoOverwrite(txn, key, data);
                if (status == OperationStatus.KEYEXIST) {
                    String emsg = "Transaction ack update conflict for transation " + tid + "[" + ack + "]";
                    this.logger.log(16, emsg);
                    throw new ConflictException(emsg);
                }
            } else {
                status = this.txnackdb.put(txn, key, data);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4056", tid + "[" + ack + "]");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void storeTransactionAcks(Transaction txn, TransactionUID tid, TransactionAcknowledgement[] txnAcks) throws BrokerException {
        if (txnAcks == null || txnAcks.length == 0) {
            return;
        }
        Object[] acks = txnAcks;
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txnackdb.get(txn, key, data, null);
            boolean notfound = true;
            if (status != OperationStatus.NOTFOUND) {
                notfound = false;
                TransactionAckArray oldacks = (TransactionAckArray)this.tacksBinding.entryToObject(data);
                ArrayList<TransactionAcknowledgement> a = new ArrayList<TransactionAcknowledgement>(Arrays.asList(oldacks.getAcks()));
                a.addAll(Arrays.asList(txnAcks));
                acks = a.toArray(new TransactionAcknowledgement[0]);
            }
            TransactionAckArray acka = new TransactionAckArray((TransactionAcknowledgement[])acks);
            data = new DatabaseEntry();
            this.tacksBinding.objectToEntry((Object)acka, data);
            if (notfound) {
                status = this.txnackdb.putNoOverwrite(txn, key, data);
                if (status == OperationStatus.KEYEXIST) {
                    String emsg = "Transaction ack update conflict for transation " + tid + "[" + Arrays.toString(txnAcks) + "]";
                    this.logger.log(16, emsg);
                    throw new ConflictException(emsg);
                }
            } else {
                status = this.txnackdb.put(txn, key, data);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4056", tid + "[" + Arrays.toString(acks) + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeTransactionAck(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            OperationStatus status = this.txnackdb.delete(txn, key);
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4060", tid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected TransactionAcknowledgement[] getTransactionAcks(Transaction txn, TransactionUID tid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)tid, key);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.txnackdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return this.emptyAckArray;
            }
            TransactionAckArray acka = (TransactionAckArray)this.tacksBinding.entryToObject(data);
            return acka.getAcks();
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4229", tid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected HashMap getAllTransactionAcks(Transaction txn) throws BrokerException {
        HashMap<TransactionUID, TransactionAcknowledgement[]> map = new HashMap<TransactionUID, TransactionAcknowledgement[]>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            TransactionUID tid = null;
            TransactionAckArray acka = null;
            cs = this.txnackdb.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                tid = (TransactionUID)this.tidBinding.entryToObject(key);
                acka = (TransactionAckArray)this.tacksBinding.entryToObject(data);
                map.put(tid, acka.getAcks());
            }
            cs.close();
            HashMap<TransactionUID, TransactionAcknowledgement[]> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4054");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all transaction acks from store: " + e.getMessage());
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("txndbCount", String.valueOf(this.txndb.count()));
        t.put("txndbConfig", this.txndb.getConfig().toString());
        t.put("txnackdbCount", String.valueOf(this.txnackdb.count()));
        t.put("txnackdbConfig", this.txnackdb.getConfig().toString());
        return t;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore: closing " + this.txndb.count() + " txn records and " + this.txnackdb.count() + " txn-ack records");
        }
    }
}

