/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class MessageDAOImpl
extends BaseDAOImpl
implements MessageDAO {
    protected String tableName;
    protected static int msgColumnType = -2147483647;
    protected String insertSQL;
    protected String updateDestinationSQL;
    protected String deleteSQL;
    protected String deleteByDstSQL;
    protected String deleteByDstBySessionSQL;
    protected String selectSQL;
    protected String selectMsgsBySessionSQL;
    protected String selectMsgsByBrokerSQL;
    protected String selectMsgIDsAndDstIDsByBrokerSQL;
    protected String selectForUpdateSQL;
    protected String selectBrokerSQL;
    protected String selectCountByDstBrokerSQL;
    protected String selectCountByDstSessionSQL;
    protected String selectCountByBrokerSQL;
    protected String selectCountByConsumerAckedSQL;
    protected String selectIDsByDstBrokerSQL;
    protected String selectIDsByDstSessionSQL;
    protected String selectMsgsByDstBrokerSQL;
    protected String selectMsgsByDstSessionSQL;
    protected String selectExistSQL;
    protected String selectCanInsertSQL;
    protected FaultInjection fi = FaultInjection.getInjection();

    MessageDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQMSG41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("STORE_SESSION_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ?, ").append("MESSAGE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("DESTINATION_ID").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("BROKER_ID").append(" = ?)").toString();
        this.deleteByDstBySessionSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("DESTINATION_ID").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("BROKER_ID").append(" = ? ").append(" AND ").append("ID").append(" = ?)").toString();
        this.selectCountByBrokerSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectCountByDstBrokerSQL = new StringBuffer(128).append("SELECT totalmsg, totalsize, ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQDST41")).append(", (SELECT COUNT(msgTbl.").append("ID").append(") AS totalmsg, SUM(").append("MESSAGE_SIZE").append(") AS totalsize").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?) msgtable").append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectCountByDstSessionSQL = new StringBuffer(128).append("SELECT totalmsg, totalsize, ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQDST41")).append(", (SELECT COUNT(").append("ID").append(") AS totalmsg, SUM(").append("MESSAGE_SIZE").append(") AS totalsize").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append("= ?").append(" AND ").append("DESTINATION_ID").append(" = ?) msgtable").append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectCountByConsumerAckedSQL = new StringBuffer(128).append("SELECT COUNT(*) AS total, SUM(CASE WHEN ").append("STATE").append(" = ").append(2).append(" THEN 1 ELSE 0 END) AS totalAcked").append(" FROM ").append(dbMgr.getTableName("MQCONSTATE41")).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectMsgsBySessionSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").toString();
        this.selectMsgsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectMsgIDsAndDstIDsByBrokerSQL = new StringBuffer(128).append("SELECT msgTbl.").append("ID").append(", msgTbl.").append("DESTINATION_ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectForUpdateSQL = new StringBuffer(128).append(this.selectSQL).append(" FOR UPDATE").toString();
        this.selectBrokerSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE msgTbl.").append("ID").append(" = ?").append(" AND msgTbl.").append("STORE_SESSION_ID").append(" = sesTbl.").append("ID").toString();
        this.selectIDsByDstBrokerSQL = new StringBuffer(128).append("SELECT msgTbl.").append("ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectIDsByDstSessionSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE STORE_SESSION_ID_COLUMN = ?").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectMsgsByDstBrokerSQL = new StringBuffer(128).append("SELECT msgTbl.").append("MESSAGE").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectMsgsByDstSessionSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append("= ?").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        StringBuffer strBuff = new StringBuffer(256).append("SELECT MAX(msgTS), MAX(dstTS), MAX(bkrState) FROM (").append("SELECT ").append("CREATED_TS").append(" AS msgTS, 0 AS dstTS, 0 AS bkrState FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" UNION ").append("SELECT 0 AS msgTS, ").append("CREATED_TS").append(" AS dstTS, 0 AS bkrState FROM ").append(dbMgr.getTableName("MQDST41")).append(" WHERE ").append("ID").append(" = ?");
        if (Globals.getHAEnabled()) {
            strBuff.append(" UNION ").append("SELECT 0 AS msgTS, 0 AS dstTS, ").append("STATE").append(" AS bkrState FROM ").append(dbMgr.getTableName("MQBKR41")).append(" WHERE ").append("ID").append(" = ? AND ").append("STATE").append(" IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")");
        }
        strBuff.append(") tbl");
        this.selectCanInsertSQL = strBuff.toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQMSG41";
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, DestinationUID dstUID, Packet message, ConsumerUID[] conUIDs, int[] states, long storeSessionID, long createdTime, boolean checkMsgExist, boolean replaycheck) throws BrokerException {
        String dstID = null;
        if (dstUID != null) {
            dstID = dstUID.toString();
        }
        this.insert(conn, dstID, message, conUIDs, states, storeSessionID, createdTime, checkMsgExist, replaycheck);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void insert(Connection conn, String dstID, Packet message, ConsumerUID[] conUIDs, int[] states, long storeSessionID, long createdTime, boolean checkMsgExist, boolean replaycheck) throws BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void moveMessage(Connection conn, Packet message, DestinationUID fromDst, DestinationUID toDst, ConsumerUID[] conUIDs, int[] states) throws IOException, BrokerException {
        block15: {
            Exception myex;
            PreparedStatement pstmt;
            block14: {
                SysMessageID sysMsgID = (SysMessageID)message.getSysMessageID().clone();
                String id = sysMsgID.getUniqueName();
                int size = message.getPacketSize();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    byte[] data = message.getBytes();
                    pstmt = conn.prepareStatement(this.updateDestinationSQL);
                    pstmt.setString(1, toDst.toString());
                    pstmt.setInt(2, size);
                    Util.setBytes(pstmt, 3, data);
                    pstmt.setString(4, id);
                    if (pstmt.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3007", id, fromDst), 404);
                    }
                    ConsumerStateDAO conStateDAO = dbMgr.getDAOFactory().getConsumerStateDAO();
                    conStateDAO.deleteByMessageID(conn, sysMsgID);
                    if (conUIDs != null || states != null) {
                        conStateDAO.insert(conn, toDst.toString(), sysMsgID, conUIDs, states, false, false);
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)e) : e;
                        Object[] args = new Object[]{id, fromDst, toDst};
                        throw new BrokerException(this.br.getKString("B4187", args), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block15;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void delete(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID, boolean replaycheck) throws BrokerException {
        block26: {
            Exception myex;
            PreparedStatement pstmt;
            block24: {
                boolean deleteFailed;
                boolean myConn;
                String id;
                block22: {
                    block25: {
                        block23: {
                            id = sysMsgID.getUniqueName();
                            myConn = false;
                            pstmt = null;
                            myex = null;
                            DBManager dbMgr = DBManager.getDBManager();
                            if (conn == null) {
                                conn = dbMgr.getConnection(false);
                                myConn = true;
                            }
                            if (this.fi.FAULT_INJECTION) {
                                HashMap<String, String> fips = new HashMap<String, String>();
                                fips.put("mqDestinationName", DestinationUID.getUniqueString(dstUID.getName(), dstUID.isQueue()));
                                this.fi.checkFaultAndExit("txn.commit.1_8", fips, 2, false);
                            }
                            deleteFailed = false;
                            pstmt = conn.prepareStatement(this.deleteSQL);
                            pstmt.setString(1, id);
                            if (pstmt.executeUpdate() == 0) {
                                deleteFailed = true;
                            } else if (Globals.getHAEnabled()) {
                                String brokerID = dbMgr.getBrokerID();
                                BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                                if (dao.isBeingTakenOver(conn, brokerID)) {
                                    StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                    try {
                                        HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                        this.logger.log(32, this.br.getKString("B4117", bkrInfo.toString()), be);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    throw be;
                                }
                            }
                            dbMgr.getDAOFactory().getConsumerStateDAO().deleteByMessageID(conn, sysMsgID);
                            if (!deleteFailed || !replaycheck) break block22;
                            this.logger.log(8, "B1430", id + "[" + dstUID + "]delete");
                            if (!myConn) break block23;
                            Util.close(null, pstmt, conn, myex);
                            break block25;
                        }
                        Util.close(null, pstmt, null, myex);
                    }
                    return;
                }
                try {
                    if (deleteFailed) {
                        throw new BrokerException(this.br.getKString("B3007", id, dstUID), 404);
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block24;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        boolean replayck = false;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            replayck = true;
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            if (!(e instanceof StoreBeingTakenOverException) && ((BrokerException)e).getStatusCode() != 404) {
                                ((BrokerException)e).setSQLRecoverable(true);
                                ((BrokerException)e).setSQLReplayCheck(replayck);
                            }
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4033", id), ex);
                        be.setSQLRecoverable(true);
                        be.setSQLReplayCheck(replayck);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block26;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public int deleteByDestinationBySession(Connection conn, DestinationUID dstUID, Long storeSession) throws BrokerException {
        int msgCount;
        block15: {
            Exception myex;
            PreparedStatement pstmt;
            block14: {
                String dstID = dstUID.toString();
                String sql = this.deleteByDstSQL;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    dbMgr.getDAOFactory().getDestinationDAO().checkDestination(conn, dstID);
                    dbMgr.getDAOFactory().getConsumerStateDAO().deleteByDestinationBySession(conn, dstUID, storeSession);
                    if (storeSession != null) {
                        sql = this.deleteByDstBySessionSQL;
                    }
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, dstID);
                    pstmt.setString(2, dbMgr.getBrokerID());
                    if (storeSession != null) {
                        pstmt.setLong(3, storeSession);
                    }
                    msgCount = pstmt.executeUpdate();
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4150", dstID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block15;
            }
            Util.close(null, pstmt, null, myex);
        }
        return msgCount;
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        String whereClause = null;
        if (Globals.getHAEnabled()) {
            DBManager dbMgr = DBManager.getDBManager();
            whereClause = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("')").toString();
        }
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public String getBroker(Connection conn, DestinationUID dstUID, String id) throws BrokerException {
        String brokerID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                brokerID = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectBrokerSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3007", id, dstUID), 404);
                    }
                    brokerID = rs.getString(1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectBrokerSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4107", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return brokerID;
    }

    @Override
    public Packet getMessage(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID) throws BrokerException {
        return this.getMessage(conn, dstUID, sysMsgID.toString());
    }

    @Override
    public Packet getMessage(Connection conn, DestinationUID dstUID, String id) throws BrokerException {
        Packet msg;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                msg = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    msg = (Packet)this.loadData(rs, true);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.selectSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B4107", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        if (msg == null) {
            throw new BrokerException(this.br.getKString("B3007", id, dstUID), 404);
        }
        return msg;
    }

    @Override
    public List getMessagesByBroker(Connection conn, String brokerID) throws BrokerException {
        List list;
        block12: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block11: {
                list = Collections.EMPTY_LIST;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectMsgsByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    list = (List)this.loadData(rs, false);
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.selectMsgsByBrokerSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectMsgsByBrokerSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B3176", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block12;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public Map getMsgIDsAndDstIDsByBroker(Connection conn, String brokerID) throws BrokerException {
        HashMap<String, String> map;
        block14: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block13: {
                map = new HashMap<String, String>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    pstmt = conn.prepareStatement(this.selectMsgIDsAndDstIDsByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getString(2));
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.selectMsgIDsAndDstIDsByBrokerSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectMsgIDsAndDstIDsByBrokerSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B3176", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block14;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return map;
    }

    @Override
    public List getIDsByDst(Connection conn, Destination dst, String brokerID, Long storeSession) throws BrokerException {
        ArrayList<String> list;
        block16: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block15: {
                list = new ArrayList<String>();
                String dstID = dst.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                String sql = this.selectIDsByDstBrokerSQL;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (storeSession != null) {
                        StoreSessionDAOImpl.checkStoreSessionOwner(conn, storeSession, brokerID);
                        sql = this.selectIDsByDstSessionSQL;
                    }
                    pstmt = conn.prepareStatement(sql);
                    if (storeSession != null) {
                        pstmt.setLong(1, storeSession);
                    } else {
                        pstmt.setString(1, brokerID);
                    }
                    pstmt.setString(2, dstID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String msgID = rs.getString(1);
                        list.add(msgID);
                    }
                    if (!myConn) break block15;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4145"), dstID, ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block16;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public Enumeration messageEnumeration(Destination dst, String brokerID, Long storeSession) throws BrokerException {
        Connection conn = null;
        BrokerException myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            conn = dbMgr.getConnection(true);
            dbMgr.getDAOFactory().getDestinationDAO().checkDestination(conn, dst.getUniqueName());
            Iterator msgIDItr = this.getIDsByDst(conn, dst, brokerID, storeSession).iterator();
            MsgEnumeration msgEnumeration = new MsgEnumeration(dst.getDestinationUID(), this, msgIDItr);
            return msgEnumeration;
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    @Override
    public Enumeration messageEnumerationCursor(Destination dst, String brokerID, Long storeSession) throws BrokerException {
        String dstID = dst.getUniqueName();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = this.selectMsgsByDstBrokerSQL;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            conn = dbMgr.getConnection(true);
            dbMgr.getDAOFactory().getDestinationDAO().checkDestination(conn, dstID);
            if (storeSession != null) {
                StoreSessionDAOImpl.checkStoreSessionOwner(conn, storeSession, brokerID);
                sql = this.selectMsgsByDstSessionSQL;
            }
            pstmt = conn.prepareStatement(sql);
            if (storeSession != null) {
                pstmt.setLong(1, storeSession);
            } else {
                pstmt.setString(1, brokerID);
            }
            pstmt.setString(2, dstID);
            rs = pstmt.executeQuery();
            return new MessageEnumeration(rs, pstmt, conn, sql, this, Globals.getStore());
        }
        catch (Throwable e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Throwable ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
            Util.close(rs, pstmt, conn, ex);
            throw new BrokerException(this.br.getKString("B4145"), dstID, ex);
        }
    }

    @Override
    public boolean hasMessageBeenAcked(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID) throws BrokerException {
        int totalAcked;
        int total;
        block14: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block13: {
                total = -1;
                totalAcked = -1;
                String id = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectCountByConsumerAckedSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3007", id, dstUID), 404);
                    }
                    total = rs.getInt(1);
                    totalAcked = rs.getInt(2);
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectCountByConsumerAckedSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            if (((BrokerException)e).getStatusCode() != 404) {
                                ((BrokerException)e).setSQLRecoverable(true);
                            }
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByConsumerAckedSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4107", id), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block14;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return total > 0 && total == totalAcked;
    }

    @Override
    public boolean hasMessage(Connection conn, String id) throws BrokerException {
        boolean found;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                found = false;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectExistSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        found = true;
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectExistSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4107", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return found;
    }

    @Override
    public void checkMessage(Connection conn, String dstID, String mid) throws BrokerException {
        if (!this.hasMessage(conn, mid)) {
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[checkMessage():" + mid + ", " + dstID + "]", rbe);
            }
            throw new BrokerException(this.br.getKString("B3007", mid, dstID), 404);
        }
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("Messages(" + this.tableName + ")", String.valueOf(count));
        return map;
    }

    @Override
    public int getMessageCount(Connection conn, String brokerID) throws BrokerException {
        int size;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                size = -1;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectCountByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectCountByBrokerSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4230", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return size;
    }

    @Override
    public HashMap getMessageStorageInfo(Connection conn, Destination dst, Long storeSession) throws BrokerException {
        HashMap<String, Number> data;
        block16: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block15: {
                data = new HashMap<String, Number>(2);
                String dstID = dst.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                String sql = this.selectCountByDstBrokerSQL;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    if (storeSession != null) {
                        StoreSessionDAOImpl.checkStoreSessionOwner(conn, storeSession, dbMgr.getBrokerID());
                        sql = this.selectCountByDstSessionSQL;
                    }
                    pstmt = conn.prepareStatement(sql);
                    if (storeSession != null) {
                        pstmt.setLong(1, storeSession);
                    } else {
                        pstmt.setString(1, dbMgr.getBrokerID());
                    }
                    pstmt.setString(2, dstID);
                    pstmt.setString(3, dstID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3013", dstID), 404);
                    }
                    data.put("numMsgs", new Integer(rs.getInt(1)));
                    data.put("totalMsgBytes", new Long(rs.getLong(2)));
                    if (!myConn) break block15;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4152", dstID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block16;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    protected Object loadData(ResultSet rs, boolean isSingleRow) throws IOException, SQLException {
        ArrayList<Packet> list = null;
        if (!isSingleRow) {
            list = new ArrayList<Packet>(100);
        }
        while (rs.next()) {
            Packet msg = new Packet(false);
            msg.generateTimestamp(false);
            msg.generateSequenceNumber(false);
            InputStream is = null;
            if (this.getMsgColumnType(rs, 1) == 2004) {
                Blob blob = rs.getBlob(1);
                is = blob.getBinaryStream();
            } else {
                is = rs.getBinaryStream(1);
            }
            msg.readPacket(is);
            is.close();
            if (Store.getDEBUG()) {
                this.logger.log(4, "Loaded message from database for " + msg.getMessageID());
            }
            if (isSingleRow) {
                return msg;
            }
            list.add(msg);
        }
        return list;
    }

    protected int getMsgColumnType(ResultSet rs, int msgColumnIndex) throws SQLException {
        if (msgColumnType == -2147483647) {
            msgColumnType = rs.getMetaData().getColumnType(msgColumnIndex);
        }
        return msgColumnType;
    }

    protected void canInsertMsg(Connection conn, String msgID, String dstID, String brokerID) throws BrokerException {
        Exception myex;
        ResultSet rs;
        PreparedStatement pstmt;
        block14: {
            pstmt = null;
            rs = null;
            myex = null;
            try {
                pstmt = conn.prepareStatement(this.selectCanInsertSQL);
                pstmt.setString(1, msgID);
                pstmt.setString(2, dstID);
                if (Globals.getHAEnabled()) {
                    pstmt.setString(3, brokerID);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    if (rs.getLong(1) > 0L) {
                        throw new BrokerException(this.br.getKString("B3008", msgID, dstID), 409);
                    }
                    if (rs.getLong(2) == 0L) {
                        throw new BrokerException(this.br.getKString("B3013", dstID), 404);
                    }
                    if (!Globals.getHAEnabled() || rs.getInt(3) <= 0) break block14;
                    StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                    try {
                        DBManager dbMgr = DBManager.getDBManager();
                        BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                        HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, dbMgr.getBrokerID());
                        this.logger.log(32, this.br.getKString("B4117", bkrInfo.toString()), be);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw be;
                }
                throw new BrokerException(this.br.getKString("B4166", this.selectCanInsertSQL));
            }
            catch (Exception e) {
                try {
                    myex = e;
                    try {
                        if (conn != null && !conn.getAutoCommit()) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException rbe) {
                        this.logger.log(32, "B4080[" + this.selectCanInsertSQL + "]", rbe);
                    }
                    if (e instanceof BrokerException) {
                        throw (BrokerException)e;
                    }
                    Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCanInsertSQL + "]", (SQLException)e) : e;
                    throw new BrokerException(this.br.getKString("B4166", this.selectCanInsertSQL), ex);
                }
                catch (Throwable throwable) {
                    Util.close(rs, pstmt, null, myex);
                    throw throwable;
                }
            }
        }
        Util.close(rs, pstmt, null, myex);
    }

    private static class MsgEnumeration
    implements Enumeration {
        DestinationUID dID = null;
        MessageDAO msgDAO = null;
        Iterator msgIDItr = null;
        Object msgToReturn = null;

        MsgEnumeration(DestinationUID dstUID, MessageDAO dao, Iterator itr) {
            this.dID = dstUID;
            this.msgDAO = dao;
            this.msgIDItr = itr;
        }

        @Override
        public boolean hasMoreElements() {
            Packet msg = null;
            while (this.msgIDItr.hasNext()) {
                String mid = null;
                try {
                    mid = (String)this.msgIDItr.next();
                    msg = this.msgDAO.getMessage(null, this.dID, mid);
                    this.msgToReturn = msg;
                    return true;
                }
                catch (Exception e) {
                    Globals.getLogger().logStack(32, "B4107", mid, (Throwable)e);
                }
            }
            this.msgToReturn = null;
            return false;
        }

        public Object nextElement() {
            if (this.msgToReturn != null) {
                return this.msgToReturn;
            }
            throw new NoSuchElementException();
        }
    }
}

