/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class Encoding
implements ASN1Value {
    private SEQUENCE seq = new SEQUENCE();
    private byte[] iv;
    private OBJECT_IDENTIFIER encOID;
    private byte[] ctext;
    private byte[] keyID;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public Encoding(byte[] byArray, byte[] byArray2, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, byte[] byArray3) {
        this.keyID = byArray;
        this.iv = byArray2;
        this.encOID = oBJECT_IDENTIFIER;
        this.ctext = byArray3;
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oBJECT_IDENTIFIER, new OCTET_STRING(byArray2));
        this.seq.addElement(new OCTET_STRING(byArray));
        this.seq.addElement(algorithmIdentifier);
        this.seq.addElement(new OCTET_STRING(byArray3));
    }

    public byte[] getKeyID() {
        return this.keyID;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public OBJECT_IDENTIFIER getEncryptionOID() {
        return this.encOID;
    }

    public byte[] getCiphertext() {
        return this.ctext;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.seq.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    extends SEQUENCE.Template {
        private SEQUENCE.Template template = new SEQUENCE.Template();

        public Template() {
            this.template.addElement(OCTET_STRING.getTemplate());
            this.template.addElement(AlgorithmIdentifier.getTemplate());
            this.template.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.template.decode(tag, inputStream);
            OCTET_STRING oCTET_STRING = (OCTET_STRING)sEQUENCE.elementAt(0);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)sEQUENCE.elementAt(1);
            OCTET_STRING oCTET_STRING2 = (OCTET_STRING)((ANY)algorithmIdentifier.getParameters()).decodeWith(OCTET_STRING.getTemplate());
            OCTET_STRING oCTET_STRING3 = (OCTET_STRING)sEQUENCE.elementAt(2);
            return new Encoding(oCTET_STRING.toByteArray(), oCTET_STRING2.toByteArray(), algorithmIdentifier.getOID(), oCTET_STRING3.toByteArray());
        }
    }
}

